/*
 * @(#)CartesianPoint.java  1.0   26 January 2003
 *
 * <P> A class that represents  a point 
 * in the cartesian coordinate system <P>
 *
 * @author Viera K. Proulx
 */
class CartesianPoint extends AMapPoint {

	/*------------------------------------------------------------------------- 
	 The constructor
    -------------------------------------------------------------------------*/
	CartesianPoint(double anX, double aY){
		this.x = anX;
		this.y = aY;
	}
	
	
	/*------------------------------------------------------------------------- 
	 Methods: 
    -------------------------------------------------------------------------*/
	
	/*------------------------------------------------------------------------- 	 
	 Purpose: 	to compute the distance of this point from the origin 
	         
	 Template: 	... this.x...this.y ... 
   -------------------------------------------------------------------------*/
	double distanceToOrigin(){
		return (double)(Math.sqrt(this.x * this.x +
		                       this.y * this.y));
	}

}
