/*
 * @(#)Cartesian3dPoint.java  1.0   26 January 2003 
 *
 * <P> A class that represents  a point 
 * in the 3-dimaensional cartesian coordinate system <P>
 *
 * @author Viera K. Proulx
 */
class Cartesian3dPoint extends AMapPoint {

	/*------------------------------------------------------------------------- 
	 Additional member data 
	 ------------------------------------------------------------------------*/
	
	/* z coordinate */
	double z;
	
	/*------------------------------------------------------------------------- 
	 The constructor
    -------------------------------------------------------------------------*/
	Cartesian3dPoint(double anX, double aY, double aZ){
        this.x = anX;
        this.y = aY;
        this.z = aZ;
	}
	
	/*------------------------------------------------------------------------- 
	 Methods: 
    -------------------------------------------------------------------------*/
	
	/*------------------------------------------------------------------------- 	 
	 Purpose: 	to compute the distance of this point from the origin 
	 
	 Template: 	... this.x...this.y ... this.z ...
   -------------------------------------------------------------------------*/
	double distanceToOrigin(){
		return (double)(Math.sqrt(this.x * this.x + 
		                       this.y * this.y + 
		                       this.z * this.z));
	}
	
	/*------------------------------------------------------------------------- 
	 Helper method to print the object member data - overriding the base method
    -------------------------------------------------------------------------*/
	public String toString(){
		return("new " + getClass().getName() + "(" +
					x    + ", " + 
					y    + ", " + 
					z    + ")");
	}
}
