/*
 * @(#)AMapPoint.java  1.0   26 January 2003 
 */

/** An abstract class that represents a point in some coordinate system */
/*
 * @(#)AMapPoint.java  1.0  23 January 2003
 *
 * <P> A base class for a number of different classes that 
 *  represent coordinates of a point
 *
 * @author Viera K. Proulx
 */
abstract class AMapPoint {

	/*------------------------------------------------------------------------- 
	 Data Definition: 
    -------------------------------------------------------------------------*/
	
	/* x coordinate */
	double x;
	
	/* y coordinate */
	double y;
	
	/*------------------------------------------------------------------------- 
	 Methods: 
    -------------------------------------------------------------------------*/
	
	/*------------------------------------------------------------------------- 	 
	 Purpose: 	to compute the distance of this point from the origin 
	 
	 Template: 	... this.x...this.y ... 
   -------------------------------------------------------------------------*/
	abstract double distanceToOrigin();
	

	/*------------------------------------------------------------------------- 
	 Purpose: 	to determine whether this point 
	 			is within the given distance from the origin
	  
	 Template:	... this.x ... this.y ... 
    -------------------------------------------------------------------------*/
	boolean isWithin(double someDistance){
		return (this.distanceToOrigin() < someDistance);		
	}
	
	
	/*------------------------------------------------------------------------- 	 
	 Purpose: 	to determine whether this point is closer to the origin 
	 			than some given point
	         
	 Template: 	... this.x ... this.y ... 
			    ... somePoint.x ... somePoint.y ... 
   -------------------------------------------------------------------------*/
	boolean isCloserThan(AMapPoint somePoint){
		return( this.distanceToOrigin() < somePoint.distanceToOrigin() );
	}
	
	
	/*------------------------------------------------------------------------- 
	 Purpose: to return the point that is closer to the origin
	 		  choosing between this and a given Point

	 Template: 	... this.x ... this.y ... somePoint.x ... somePoint.y ...
    -------------------------------------------------------------------------*/
	AMapPoint getCloserPoint(AMapPoint somePoint){

		if ( this.distanceToOrigin() < somePoint.distanceToOrigin() )
			return this;
		else
			return somePoint;		
	}
	
	
	/*------------------------------------------------------------------------- 
	 Helper method to print the object member data.
    -------------------------------------------------------------------------*/
	public String toString(){
		return("new " + getClass().getName() + "(" +
					x    + ", " + 
					y    + ")");
	}

}
