/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AlertEvent;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.util.JPTUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class Annotation
extends DisplayPanel {
    public static final String ALERT_ICON = "alert.icon";
    public static final int DEFAULT_ALIGNMENT = 1;
    protected Color oldForeground = null;
    protected Color oldBackground = null;
    protected JLabel iconLabel = new JLabel();
    protected JTextArea textLabel = new 1();
    protected int align = 1;
    protected Icon alertIcon = null;

    public Annotation() {
        this(null, null, 1);
    }

    public Annotation(String text) {
        this(text, null, 1);
    }

    public Annotation(Icon icon) {
        this(null, icon, 1);
    }

    public Annotation(String text, Icon icon, int alignment) {
        this.setAlignment(alignment);
        this.textLabel.setFont(this.iconLabel.getFont());
        this.textLabel.setForeground(this.iconLabel.getForeground());
        this.textLabel.setBackground(this.iconLabel.getBackground());
        this.textLabel.setLineWrap(false);
        this.textLabel.setEditable(false);
        this.setText(text);
        this.setIcon(icon);
    }

    public void dataMalformed(MalformedDataEvent evt) {
        if (evt.isAlertOn()) {
            this.startAlert(evt);
        } else {
            this.endAlert(evt);
        }
    }

    public void startAlert(AlertEvent evt) {
        this.oldForeground = this.textLabel.getForeground();
        this.oldBackground = this.getBackground();
        this.setForeground(SystemColor.textHighlightText);
        this.setBackground(SystemColor.textHighlight);
        if (this.alertIcon != null) {
            this.iconLabel.setIcon(this.alertIcon);
        }
    }

    public void endAlert(AlertEvent evt) {
        this.setForeground(this.oldForeground);
        this.setBackground(this.oldBackground);
        this.setEnabled(this.isEnabled());
    }

    public void setAlignment(int alignment) {
        int oldAlignment = this.getAlignment();
        switch (alignment) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.align = alignment;
                break;
            }
            case -1: {
                this.align = 1;
                break;
            }
            default: {
                return;
            }
        }
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.textLabel, "Center");
        this.add((Component)this.iconLabel, JPTUtilities.getBorderLayoutLocation(this.align));
        this.revalidate();
        if (this.getAlignment() != oldAlignment) {
            this.firePropertyChange("alignment", oldAlignment, this.getAlignment());
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setForeground(Color foreground) {
        if (foreground == null) {
            return;
        }
        if (this.iconLabel != null) {
            this.iconLabel.setForeground(foreground);
        }
        if (this.textLabel != null) {
            this.textLabel.setForeground(foreground);
        }
        super.setForeground(foreground);
    }

    public void setBackground(Color background) {
        if (background == null) {
            return;
        }
        if (this.iconLabel != null) {
            this.iconLabel.setBackground(background);
        }
        if (this.textLabel != null) {
            this.textLabel.setBackground(background);
        }
        super.setBackground(background);
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        if (this.iconLabel != null) {
            this.iconLabel.setFont(font);
        }
        if (this.textLabel != null) {
            this.textLabel.setFont(font);
        }
        super.setFont(font);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (this.textLabel != null) {
            this.textLabel.setText(text);
        }
    }

    public String getText() {
        if (this.textLabel != null) {
            return this.textLabel.getText();
        }
        return null;
    }

    public void setIcon(Icon icon) {
        if (this.iconLabel != null) {
            this.iconLabel.setIcon(icon);
        }
    }

    public Icon getIcon() {
        if (this.iconLabel != null) {
            return this.iconLabel.getIcon();
        }
        return null;
    }

    public void setDisabledIcon(Icon icon) {
        if (this.iconLabel != null) {
            this.iconLabel.setDisabledIcon(icon);
        }
    }

    public Icon getDisabledIcon() {
        if (this.iconLabel != null) {
            return this.iconLabel.getDisabledIcon();
        }
        return null;
    }

    public void setAlertIcon(Icon icon) {
        Icon oldIcon = this.getAlertIcon();
        this.alertIcon = icon;
        if (this.getAlertIcon() != oldIcon) {
            this.firePropertyChange(ALERT_ICON, oldIcon, this.getAlertIcon());
        }
    }

    public Icon getAlertIcon() {
        return this.alertIcon;
    }

    private final class 1
    extends JTextArea {
        public boolean isFocusTraversable() {
            return this.isEditable();
        }

        public void requestFocus() {
            if (!this.isEditable()) {
                this.transferFocus();
            }
        }

        /* synthetic */ 1() {
        }
    }
}

