/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ActionWrapper;
import edu.neu.ccs.gui.DisplayPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JRootPane;

public class ActionsPanel
extends DisplayPanel {
    private Hashtable map = new Hashtable();

    public ActionsPanel() {
    }

    public ActionsPanel(LayoutManager layout) {
        this(null, null, layout);
    }

    public ActionsPanel(Action[] actions) {
        this(actions, null, null);
    }

    public ActionsPanel(Action[] actions, LayoutManager layout) {
        this(actions, null, layout);
    }

    public ActionsPanel(Action[] actions, Object[] constraints, LayoutManager layout) {
        if (layout != null) {
            this.setLayout(layout);
        }
        this.addActions(actions, constraints);
    }

    public JButton addAction(Action action) {
        return this.addAction(action, null);
    }

    public JButton addAction(Action action, Object constraint) {
        if (action == null) {
            return null;
        }
        JButton button = new JButton(action);
        this.map.put(action, button);
        this.map.put(button, action);
        this.add((Component)button, constraint);
        return button;
    }

    public JButton[] addActions(Action[] actions) {
        return this.addActions(actions, null);
    }

    public JButton[] addActions(Action[] actions, Object[] constraints) {
        if (actions == null) {
            return null;
        }
        int actionslength = actions.length;
        int constraintslength = constraints != null ? constraints.length : -1;
        JButton[] buttons = new JButton[actionslength];
        int i = 0;
        while (i < actionslength) {
            if (actions[i] != null) {
                buttons[i] = i < constraintslength ? this.addAction(actions[i], constraints[i]) : this.addAction(actions[i], null);
            }
            ++i;
        }
        return buttons;
    }

    public Action getAction(JButton button) {
        if (button == null) {
            return null;
        }
        return (Action)this.map.get(button);
    }

    public JButton getButton(Action action) {
        if (action == null) {
            return null;
        }
        return (JButton)this.map.get(action);
    }

    public Action[] getActions() {
        JButton[] buttons = this.getActionButtons();
        if (buttons == null) {
            return null;
        }
        int buttonslength = buttons.length;
        Action[] actions = new Action[buttonslength];
        int i = 0;
        while (i < buttonslength) {
            actions[i] = (Action)this.map.get(buttons[i]);
            ++i;
        }
        return actions;
    }

    public JButton[] getActionButtons() {
        Vector<Component> buttons = new Vector<Component>();
        Component[] child = this.getComponents();
        int i = 0;
        while (i < child.length) {
            if (child[i] instanceof JButton && this.map.containsKey(child[i])) {
                buttons.add(child[i]);
            }
            ++i;
        }
        return buttons.toArray(new JButton[0]);
    }

    public Action findMatchedAction(Action action) {
        if (action == null) {
            return null;
        }
        if (this.map.containsKey(action)) {
            return action;
        }
        Action base = ActionWrapper.getBaseAction(action);
        Action[] actions = this.getActions();
        int i = 0;
        while (i < actions.length) {
            if (base == ActionWrapper.getBaseAction(actions[i])) {
                return actions[i];
            }
            ++i;
        }
        return null;
    }

    public JButton findMatchedButton(Action action) {
        return this.getButton(this.findMatchedAction(action));
    }

    public Action findMatchedAction(String name) {
        if (name == null) {
            return null;
        }
        Action[] actions = this.getActions();
        int i = 0;
        while (i < actions.length) {
            if (name.equals((String)actions[i].getValue("Name"))) {
                return actions[i];
            }
            ++i;
        }
        return null;
    }

    public JButton findMatchedButton(String name) {
        return this.getButton(this.findMatchedAction(name));
    }

    public void setDefaultButton(JButton button) {
        JRootPane pane = this.getRootPane();
        if (pane != null) {
            pane.setDefaultButton(button);
        }
    }

    public void setDefaultButton(Action action) {
        this.setDefaultButton(this.findMatchedButton(action));
    }

    public void setDefaultButton(String name) {
        this.setDefaultButton(this.findMatchedButton(name));
    }

    public static void setText(Action action, String text) {
        if (action == null) {
            return;
        }
        action.putValue("Name", text);
    }

    public static void setIcon(Action action, Icon icon) {
        if (action == null) {
            return;
        }
        action.putValue("SmallIcon", icon);
    }

    public static void setToolTipText(Action action, String text) {
        if (action == null) {
            return;
        }
        action.putValue("ShortDescription", text);
    }

    public static String getText(Action action) {
        if (action == null) {
            return null;
        }
        Object o = action.getValue("Name");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static Icon getIcon(Action action) {
        if (action == null) {
            return null;
        }
        Object o = action.getValue("SmallIcon");
        if (o instanceof Icon) {
            return (Icon)o;
        }
        return null;
    }

    public static String getToolTipText(Action action) {
        if (action == null) {
            return null;
        }
        Object o = action.getValue("ShortDescription");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }
}

