/*
 * Decompiled with CFR 0.152.
 */
import edu.neu.ccs.util.MathUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class ActivityIconAlt {
    public static Color inputColor = Color.green;
    public static Color actionColor = Color.yellow;
    public static Color outputColor = Color.red;
    public static Color boxColor = Color.black;
    private static int linewidth = 4;
    private static int arrowsize = 4;
    private static int boxsize = 24;
    private static int halfsize = boxsize / 2;
    private static int height = boxsize;

    public static class InputIcon
    extends JComponent {
        private int width = ActivityIconAlt.access$0() + ActivityIconAlt.access$1() + ActivityIconAlt.access$2();
        private Rectangle2D.Double box = new Rectangle2D.Double();
        private Line2D.Double line = new Line2D.Double();
        private Arc2D.Double arc = new Arc2D.Double();

        public InputIcon() {
            this.setPreferredSize(new Dimension(this.width, height));
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(linewidth, 1, 1));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (boxColor == null) {
                boxColor = Color.black;
            }
            g2.setPaint(boxColor);
            this.box.setFrame(0.0, 0.0, boxsize, boxsize);
            g2.fill(this.box);
            if (inputColor == null) {
                inputColor = Color.green;
            }
            g2.setPaint(inputColor);
            int x = boxsize + arrowsize + linewidth;
            int y = 0;
            int h = halfsize - linewidth / 2;
            this.line.setLine(x, y, x, y + h);
            g2.draw(this.line);
            y = halfsize;
            int w = boxsize / 2;
            this.line.setLine(x, y, w, y);
            g2.draw(this.line);
            x = boxsize / 2;
            this.line.setLine(x, y, x + arrowsize, y - arrowsize);
            g2.draw(this.line);
            this.line.setLine(x, y, x + arrowsize, y + arrowsize);
            g2.draw(this.line);
        }
    }

    public static class ActionIcon
    extends JComponent {
        private int width = ActivityIconAlt.access$0();
        private int inset = 2;
        private Rectangle2D.Double box = new Rectangle2D.Double();
        private Line2D.Double line = new Line2D.Double();
        private Arc2D.Double arc = new Arc2D.Double();

        public ActionIcon() {
            this.setPreferredSize(new Dimension(this.width, height));
        }

        protected void paintComponent(Graphics g) {
            int x;
            int w;
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(linewidth, 1, 1));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (boxColor == null) {
                boxColor = Color.black;
            }
            g2.setPaint(boxColor);
            this.box.setFrame(0.0, 0.0, boxsize, boxsize);
            g2.fill(this.box);
            if (actionColor == null) {
                actionColor = Color.yellow;
            }
            g2.setPaint(actionColor);
            int h = w = boxsize - linewidth - 2 * this.inset;
            int y = x = this.inset + linewidth / 2;
            int start = 135;
            int total = 315;
            this.arc.setArc(x, y, w, h, start, total, 0);
            g2.draw(this.arc);
            int radius = halfsize - x;
            int side = (int)Math.round((double)radius * MathUtilities.sindeg((double)45.0));
            y = x = halfsize - side;
            this.line.setLine(x, y, x - arrowsize, y);
            g2.draw(this.line);
            this.line.setLine(x, y, x + 1, y + arrowsize);
            g2.draw(this.line);
        }
    }

    public static class OutputIcon
    extends JComponent {
        private int width = ActivityIconAlt.access$0() + ActivityIconAlt.access$1() + ActivityIconAlt.access$2();
        private Rectangle2D.Double box = new Rectangle2D.Double();
        private Line2D.Double line = new Line2D.Double();
        private Arc2D.Double arc = new Arc2D.Double();

        public OutputIcon() {
            this.setPreferredSize(new Dimension(this.width, height));
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(linewidth, 1, 1));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (boxColor == null) {
                boxColor = Color.black;
            }
            g2.setPaint(boxColor);
            this.box.setFrame(halfsize + arrowsize, 0.0, boxsize, boxsize);
            g2.fill(this.box);
            if (outputColor == null) {
                outputColor = Color.blue;
            }
            g2.setPaint(outputColor);
            int x = boxsize + arrowsize;
            int y = halfsize;
            int w = boxsize - linewidth / 2;
            this.line.setLine(x, y, x - w, y);
            g2.draw(this.line);
            y = linewidth / 2;
            int h = halfsize - linewidth / 2;
            this.line.setLine(x -= w, y, x, y + h);
            g2.draw(this.line);
            this.line.setLine(x, y, x - arrowsize, y + arrowsize);
            g2.draw(this.line);
            this.line.setLine(x, y, x + arrowsize, y + arrowsize);
            g2.draw(this.line);
        }
    }
}

