/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern 
*/

class TreeRange implements IRange {

    /* a list of nodes on the way down */
    ABTIlist ptr; 
    
    TreeRange(ABinTreeStudent t) { 
       
        if (t instanceof EmptyBinTreeStudent)
            ptr = new EmptyABTIlist();
            
        else {       
            /* insert the current node into the list */
            ptr = new ConsBTlist((ConsBinTreeStudent)t, 
                                 new EmptyABTIlist());
            
            /* insert all the left children of this node 
             into the list */ 
            ptr = ((ConsBTlist)ptr).insertLeft();   
        }     
    }
    // --------------------------------------------------------------


    public void next() {
    
        /* give decent names to the first and rest */
        ConsBinTreeStudent t = ((ConsBTlist)ptr).first;
        ABTIlist theRest = ((ConsBTlist)ptr).rest;
        
        /* if the to node had a right child,
           insert the right child into the list
           then insert all of its left children too */
        if (t.right instanceof ConsBinTreeStudent){
            ptr = (new ConsBTlist(((ConsBinTreeStudent)t.right), 
                                    theRest)).insertLeft();
            }
            
        /* otherwise, just keep the rest of the list */
        else
            ptr = theRest;
    }


    public Object current() {
        return ((ConsBTlist)ptr).first.node; 
    }
    
    public boolean hasMore() {
        return (ptr instanceof ConsBTlist); 
    }
}

/* A list where to keep track of the nodes to visit */        
abstract class ABTIlist{ }

class EmptyABTIlist extends ABTIlist{
    public String toString(){ return("@%@"); }
}

class ConsBTlist extends ABTIlist{
    
    /* insist that only non-empty trees get inserted */
    ConsBinTreeStudent first;
    ABTIlist           rest;
    
    ConsBTlist(ConsBinTreeStudent aFirst, ABTIlist aRest){
        this.first = aFirst;
        this.rest  = aRest;
    }
    
    /* produce a new list which contains all the left children
       of the tree which is the first item in this list */
    ConsBTlist insertLeft(){
    
        /* tree whose left children will be inserted into the new list */
        ConsBinTreeStudent ptr = this.first;
        
        /* the new list starts with this list*/
        ConsBTlist newList = this;
        
        /* go down to the left and insert the next node */
        while (ptr.left instanceof ConsBinTreeStudent){
            newList = new ConsBTlist(((ConsBinTreeStudent)ptr.left), newList);
            ptr = (ConsBinTreeStudent)ptr.left;
        }
        
        return newList;
    }
    
    public String toString(){
        return("*" + 
                this.first.node + "*, " +
                this.rest + "\n");
    }
}