/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern 
*/

class ReverseTreeRange implements IRange {

    /* a list of nodes on the way down */
    ARBTIlist ptr; 
    
    ReverseTreeRange(ABinTreeStudent t) { 
    
        if (t instanceof EmptyBinTreeStudent)
            ptr = new EmptyRBTIlist();
            
        else {       
            /* insert the current node into the list */
            ptr = new ConsRBTIlist((ConsBinTreeStudent)t, 
                                   new EmptyRBTIlist());
            
            /* insert all the right children of this node into the list */ 
            ptr = ((ConsRBTIlist)ptr).insertRight();        
        }
    }
    // --------------------------------------------------------------


    public void next() {
    
        /* give decent names to the first and rest */
        ConsBinTreeStudent t = ((ConsRBTIlist)ptr).first;
        ARBTIlist theRest = ((ConsRBTIlist)ptr).rest;
        
        /* if the to node had a left child,
           insert the left child into the list
           then insert all of its right children too */
        if (t.left instanceof ConsBinTreeStudent){
            ptr = (new ConsRBTIlist(((ConsBinTreeStudent)t.left), 
                                    theRest)).insertRight();
            }
            
        /* otherwise, just keep the rest of the list */
        else
            ptr = theRest;
    }


    public Object current() {
        return ((ConsRBTIlist)ptr).first.node; 
    }
    
    public boolean hasMore() {
        return (ptr instanceof ConsRBTIlist); 
    }
}

/* A list where to keep track of the nodes to visit */        
abstract class ARBTIlist{ }

class EmptyRBTIlist extends ARBTIlist{
    public String toString(){ return("@%@"); }
}

class ConsRBTIlist extends ARBTIlist{
    
    /* insist that only non-empty trees get inserted */
    ConsBinTreeStudent first;
    ARBTIlist          rest;
    
    ConsRBTIlist(ConsBinTreeStudent aFirst, ARBTIlist aRest){
        this.first = aFirst;
        this.rest  = aRest;
    }
    
    /* produce a new list which contains all the right children
       of the tree which is the first item in this list */
    ConsRBTIlist insertRight(){
    
        /* tree whose right children will be inserted into the new list */
        ConsBinTreeStudent ptr = this.first;
        
        /* the new list starts with this list*/
        ConsRBTIlist newList = this;
        
        /* go down to the right and insert the next node */
        while (ptr.right instanceof ConsBinTreeStudent){
            newList = new ConsRBTIlist(((ConsBinTreeStudent)ptr.right), newList);
            ptr = (ConsBinTreeStudent)ptr.right;
        }
        
        return newList;
    }
    
    public String toString(){
        return("*" + 
                this.first.node + "*, " +
                this.rest + "\n");
    }
}