/* IRangeTests.java 1.0  12 December 2002 */

public class IRangeTests extends JPFalt 
{
    public static void main(String[] args) { new IRangeTests(); }
    
/*---------------------------------------------------------------
 Sample data sets
 --------------------------------------------------------------*/

    /* A list of Students -------------------------------------*/
    AListOfStudent studentList = 
        new ConsListOfStudent(new Student("Smart", "Math", 3.7), 
        new ConsListOfStudent(new Student("Wise", "Physics", 3.2),
        new ConsListOfStudent(new Student("Lazy", "None", 2.1),
        new EmptyListOfStudent())));
                               
    /* An array of Integers ----------------------------------*/
    Object studentArray[] = new Object[]
                            {new Student("Smart", "Math", 3.7), 
                             new Student("Lazy", "None", 2.1),
                             new Student("Wise", "Physics", 3.2)};
                                     
    /* Empty binary search tree ------------------------------*/
    ABinTreeStudent empty = new EmptyBinTreeStudent();
    
    /* A binary search tree with one item --------------------*/
    ConsBinTreeStudent myTree = 
        new ConsBinTreeStudent(new Student("Smart", "Math", 3.7), 
                               empty, empty);
                
    /* A binary search tree with five items ------------------*/
    ConsBinTreeStudent newTree = 
            myTree.insert(new Student("Smart", "Math", 3.7)) 
                  .insert(new Student("Lazy", "None", 2.1))
                  .insert(new Student("Quick", "History", 2.1))
                  .insert(new Student("Clever", "Bio", 2.9))
                  .insert(new Student("Wise", "Physics", 3.2));
                                  
/*---------------------------------------------------------------
 Place your actual methods here.
---------------------------------------------------------------*/

    /*-------------------------------------------------------
     Print all items in the data set
     ------------------------------------------------------*/
    void printer(IRange i) { 
        console.out.print("["); 
        for(IRange r = i; r.hasMore(); r.next())
            console.out.print(" " + r.current() + " "); 
        console.out.println("]"); 
    }

    /*--------------------------------------------------------
     Determine whether the given item in the data set
     -------------------------------------------------------*/
    boolean find(Student s, IRange i){
        for (IRange r = i; r.hasMore(); r.next()){
            if (((Student)r.current()).name.equals(s.name))
                return true;
        }
        return false;
    }

    /*--------------------------------------------------------
     Test the list iterator
     -------------------------------------------------------*/
    void TestListIterator(){

        /* manual traversal to print every item ------------*/
        testHeader("traversal loop");

        console.out.print("["); 
        
        for(IRange r = new ListRange(studentList); 
            r.hasMore(); r.next())
            
            console.out.print(" " + r.current() + " "); 
            
        console.out.println("]"); 

        /* test of the find method -------------------------*/
        testHeader("find(Student s, IRange i)");

        expected(false);                               
        actual(find(new Student("Dweeb", "Music", 1.7), 
                    new ListRange(studentList)));
        
        expected(true);                               
        actual(find(new Student("Lazy", "None", 2.1),
                    new ListRange(studentList)));
        
        expected(true);                               
        actual(find(new Student("Smart", "Math", 3.7),
                    new ListRange(studentList)));
        
        /* abstract and use the printer method -------------*/
        testHeader("printer(IRange i)");
        printer(new ListRange(studentList)); 
    }
    
    /*--------------------------------------------------------
     Test the array iterator
     -------------------------------------------------------*/
    void TestArrayIterator(){

        /* manual traversal to print every item ------------*/
        testHeader("traversal loop");

        console.out.print("["); 
        
        for(IRange r = new ArrayRange(studentArray); 
            r.hasMore(); r.next())
            
            console.out.print(" " + r.current() + " "); 
            
        console.out.println("]"); 

        /* test of the find method -------------------------*/
        testHeader("find(int n, IRange i)");

        expected(false);                               
        actual(find(new Student("Dweeb", "Music", 1.7),  
                    new ArrayRange(studentArray)));
        
        expected(true);                               
        actual(find(new Student("Lazy", "None", 2.1), 
                    new ArrayRange(studentArray)));
        
        expected(true);                               
        actual(find(new Student("Smart", "Math", 3.7), 
                    new ArrayRange(studentArray)));
        
        /* abstract and use the printer method -------------*/
        testHeader("printer(IRange i)");
        printer(new ArrayRange(studentArray)); 
    }

    /*--------------------------------------------------------
     Test the tree iterator
     -------------------------------------------------------*/
    void TestTreeIterator(){

        /* print the two non-empty trees -------------------*/
        println("myTree:");
        actual(myTree);
        
        println("newTree:");
        actual(newTree);
        
        /* manual traversal to print every item ------------*/
        testHeader("traversal loop");

        console.out.print("["); 
        
        for(IRange r = new TreeRange(newTree); 
            r.hasMore(); r.next())
            
            console.out.print(" " + r.current() + " "); 
            
        console.out.println("]"); 

        /* test of the find method -------------------------*/
        testHeader("find(int n, IRange i)");

        expected(false);                               
        actual(find(new Student("Dweeb", "Music", 1.7), 
                    new TreeRange(newTree)));
        
        expected(true);                               
        actual(find(new Student("Smart", "Math", 3.7), 
                    new TreeRange(newTree)));
        
        expected(true);                               
        actual(find(new Student("Quick", "History", 2.1), 
                    new TreeRange(newTree)));
        
        /* forward tree traversal --------------------------*/
        println("******* TreeTraversal **********");       
        printer(new TreeRange(newTree));
    }
        
    /*--------------------------------------------------------
     End of the direct test suite
     -------------------------------------------------------*/
}
