/* DataSet.java 1.0  15 February 2003 
 * 
 * Class which implements several algorithms on data collections
 */

public class DataSet {

/*---------------------------------------------------------------
 Member data
 --------------------------------------------------------------*/

    IRange iterator;
    
/*---------------------------------------------------------------
 Constructor
 --------------------------------------------------------------*/
 
    DataSet(IRange anIterator){
        this.iterator = anIterator;
    }
/*---------------------------------------------------------------
 Methods
 --------------------------------------------------------------*/
 
    /*--------------------------------------------------------
     Count the number of items in this data set
     -------------------------------------------------------*/
    int count(){
        int cnt = 0;
        for (IRange r = iterator; r.hasMore(); r.next()){
            cnt++;
        }
        return cnt;
    
    }
    
    /*--------------------------------------------------------
     Determine whether the given item is in this data set
     -------------------------------------------------------*/
    boolean find(Comparable obj){
        for (IRange r = iterator; r.hasMore(); r.next()){
            if (((Comparable)r.current()).compareTo(obj) == 0)
                return true;
        }
        return false;
    }

    /*--------------------------------------------------------
     Find the minimum item is in this (non-empty) data set
     -------------------------------------------------------*/
    Comparable minimum(){
    
        Comparable min = (Comparable)iterator.current();
        
        for (IRange r = iterator; r.hasMore(); r.next()){
            if (((Comparable)r.current()).compareTo(min) < 0)
                min = (Comparable)r.current();
        }
        return min;
    }


    /*--------------------------------------------------------
     Sort this data set - return a sorted list of integers
     -------------------------------------------------------*/
    AListOfStudent sort(){
        
        AListOfStudent sortedList = new EmptyListOfStudent();
        ABinTreeStudent tempTree = new EmptyBinTreeStudent();
        
        for (IRange r = iterator; r.hasMore(); r.next()){
            tempTree = tempTree.insert((Student)r.current());
        }
        
        for (IRange it = new TreeRange(tempTree);
             it.hasMore();
             it.next()){
         
            sortedList = new ConsListOfStudent((Student)it.current(),
                                           sortedList);    
        }
        
        return sortedList;       
    }

    /*--------------------------------------------------------
     End of the class DataSet
     -------------------------------------------------------*/
}
