/*
 * @(#)ConsBinTreeStudent.java  20 February 2003
 */

/**
 * Constructed binary tree of students class
 */
public class ConsBinTreeStudent extends ABinTreeStudent{

/*---------------------------------------------------------------
 Member data
 --------------------------------------------------------------*/
    Student         node;
    ABinTreeStudent left;
    ABinTreeStudent right;
    
/*---------------------------------------------------------------
 Constructor
 --------------------------------------------------------------*/
    ConsBinTreeStudent(Integer aNode, 
                       ABinTreeStudent aLeft, 
                       ABinTreeStudent aRight){
        this.node  = aNode;
        this.left  = aLeft;
        this.right = aRight;
    }
    
/*---------------------------------------------------------------
 Construct a new tree by adding one more node to the right place
 --------------------------------------------------------------*/
    ConsBinTreeStudent insert(Integer n){
        if (this.node == n)
            return this;
            
        if (this.node.intValue() < n.intValue())
            return new ConsBinTreeStudent(node,
                                      this.left,
                                      this.right.insert(n));
                                   
        else
            return new ConsBinTreeStudent(node,
                                      this.left.insert(n),
                                      this.right);                                      
   }

/*---------------------------------------------------------------
 Print all member data values.
 --------------------------------------------------------------*/
    public String toString(){
        return("\n new " + this.getClass().getName() + "(" +
                this.node + ": left[" +
                this.left + "] right[" +
                this.right + "])");
    }
            
}
    
