/*
 * @(#)ConsBinTreeStudent.java  20 February 2003
 */

/**
 * Constructed binary tree of students class
 */
public class ConsBinTreeStudent extends ABinTreeStudent{

/*---------------------------------------------------------------
 Member data
 --------------------------------------------------------------*/
    Student         node;
    ABinTreeStudent left;
    ABinTreeStudent right;
    
/*---------------------------------------------------------------
 Constructor
 --------------------------------------------------------------*/
    ConsBinTreeStudent(Student aNode, 
                       ABinTreeStudent aLeft, 
                       ABinTreeStudent aRight){
        this.node  = aNode;
        this.left  = aLeft;
        this.right = aRight;
    }
    
/*---------------------------------------------------------------
 Construct a new tree by adding one more node to the right place
 --------------------------------------------------------------*/
    ConsBinTreeStudent insert(Student s){
        if (this.node.equals(s))
            return this;
            
        if (this.node.gpa < s.gpa)
            return new ConsBinTreeStudent(node,
                                      this.left,
                                      this.right.insert(s));
                                   
        else
            return new ConsBinTreeStudent(node,
                                      this.left.insert(s),
                                      this.right);                                      
   }

/*---------------------------------------------------------------
 Print all member data values.
 --------------------------------------------------------------*/
    public String toString(){
        return("\n new " + this.getClass().getName() + "(" +
                this.node + ": left[" +
                this.left + "] right[" +
                this.right + "])");
    }
            
}
    
