/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XInt;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.JPTError;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OptionsView
extends JPanel
implements TypedView,
JPTConstants {
    public static final String OPTION_COUNT = "option.count";
    public static final String SELECTED_INDEX = "selected.index";
    public static final String DEFAULT_INDEX = "default.index";
    protected static final int DEFAULT_SELECTION = 0;
    protected int defaultValue = 0;
    protected ButtonGroup group = new ButtonGroup();
    protected JRadioButton[] button = new JRadioButton[0];
    protected InputProperties properties = new InputProperties();
    static /* synthetic */ Class class$edu$neu$ccs$XInt;

    public OptionsView() {
        this(null, 0, new GridLayout(0, 1));
    }

    public OptionsView(LayoutManager layout) {
        this(null, 0, layout);
    }

    public OptionsView(String[] labels) {
        this(labels, 0, new GridLayout(0, 1));
    }

    public OptionsView(String[] labels, int selection) {
        this(labels, selection, new GridLayout(0, 1));
    }

    public OptionsView(String[] labels, int selection, LayoutManager layout) {
        if (layout != null) {
            this.setLayout(layout);
        }
        if (labels != null) {
            if (selection < 0 || selection >= labels.length) {
                selection = 0;
            }
            int i = 0;
            while (i < labels.length) {
                this.addOption(labels[i], i == selection);
                ++i;
            }
            this.defaultValue = selection;
        }
    }

    public OptionsView(String[] labels, Action action) {
        this(labels, action, 0, (LayoutManager)new GridLayout(0, 1));
    }

    public OptionsView(String[] labels, Action action, int selection) {
        this(labels, action, selection, (LayoutManager)new GridLayout(0, 1));
    }

    public OptionsView(String[] labels, Action action, int selection, LayoutManager layout) {
        if (layout != null) {
            this.setLayout(layout);
        }
        if (labels != null) {
            if (selection < 0 || selection >= labels.length) {
                selection = 0;
            }
            int i = 0;
            while (i < labels.length) {
                this.addOption(labels[i], action, i == selection);
                ++i;
            }
            this.defaultValue = selection;
        }
    }

    public OptionsView(String[] labels, Action[] actions) {
        this(labels, actions, 0, (LayoutManager)new GridLayout(0, 1));
    }

    public OptionsView(String[] labels, Action[] actions, int selection) {
        this(labels, actions, selection, (LayoutManager)new GridLayout(0, 1));
    }

    public OptionsView(String[] labels, Action[] actions, int selection, LayoutManager layout) {
        if (layout != null) {
            this.setLayout(layout);
        }
        if (labels != null) {
            if (selection < 0 || selection >= labels.length) {
                selection = 0;
            }
            int actionslength = actions != null ? actions.length : -1;
            int i = 0;
            while (i < labels.length) {
                if (i < actionslength) {
                    this.addOption(labels[i], actions[i], i == selection);
                } else {
                    this.addOption(labels[i], i == selection);
                }
                ++i;
            }
            this.defaultValue = selection;
        }
    }

    public Stringable demandObject() {
        return new XInt(this.getSelectedIndex());
    }

    public Stringable requestObject() {
        return this.demandObject();
    }

    public void setInputProperties(InputProperties p) {
        if (p == null) {
            p = InputProperties.BASE_PROPERTIES;
        }
        InputProperties oldProperties = this.getInputProperties();
        this.properties = p;
        if (this.getInputProperties() != null && !this.getInputProperties().equals(oldProperties)) {
            this.firePropertyChange("input.properties", oldProperties, this.getInputProperties());
        }
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public Class getDataType() {
        return class$edu$neu$ccs$XInt != null ? class$edu$neu$ccs$XInt : (class$edu$neu$ccs$XInt = OptionsView.class$("edu.neu.ccs.XInt"));
    }

    public void setViewState(String data) {
        this.setSelectedIndex(OptionsView.parseInt(data, "setViewState"));
        this.firePropertyChange("view.state", null, data);
    }

    public String getViewState() {
        return String.valueOf(this.getSelectedIndex());
    }

    public void setDefaultViewState(String data) {
        this.setDefaultIndex(OptionsView.parseInt(data, "setDefaultViewState"));
        this.firePropertyChange("default.view.state", null, data);
    }

    public String getDefaultViewState() {
        return String.valueOf(this.getDefaultIndex());
    }

    public void setEnabled(boolean isEnabled) {
        int i = 0;
        while (i < this.button.length) {
            this.button[i].setEnabled(isEnabled);
            ++i;
        }
        super.setEnabled(isEnabled);
    }

    public void reset() {
        this.setSelectedIndex(this.defaultValue);
    }

    public void addOption(String label) {
        this.addOption(label, null, false);
    }

    public void addOption(String label, Action action) {
        this.addOption(label, action, false);
    }

    public void addOption(String label, boolean selected) {
        this.addOption(label, null, selected);
    }

    public void addOption(String label, Action action, boolean selected) {
        JRadioButton newButton;
        if (label == null) {
            return;
        }
        int oldCount = this.button.length;
        JRadioButton[] temp = new JRadioButton[this.button.length + 1];
        int i = 0;
        while (i < this.button.length) {
            temp[i] = this.button[i];
            ++i;
        }
        this.button = temp;
        int newCount = this.button.length;
        this.button[newCount - 1] = newButton = new JRadioButton(label);
        if (newCount == 1) {
            selected = true;
        }
        this.group.add(newButton);
        this.group.setSelected(newButton.getModel(), selected);
        if (action != null) {
            newButton.addActionListener(action);
        }
        this.add(newButton);
        this.revalidate();
        this.firePropertyChange(OPTION_COUNT, oldCount, newCount);
    }

    public void addOptions(String[] labels) {
        if (labels == null) {
            return;
        }
        int i = 0;
        while (i < labels.length) {
            this.addOption(labels[i]);
            ++i;
        }
    }

    public void addOptions(String[] labels, Action action) {
        if (labels == null) {
            return;
        }
        int i = 0;
        while (i < labels.length) {
            this.addOption(labels[i], action);
            ++i;
        }
    }

    public void addOptions(String[] labels, Action[] actions) {
        if (labels == null) {
            return;
        }
        int actionslength = actions != null ? actions.length : -1;
        int i = 0;
        while (i < labels.length) {
            if (i < actionslength) {
                this.addOption(labels[i], actions[i]);
            } else {
                this.addOption(labels[i]);
            }
            ++i;
        }
    }

    public int getOptionCount() {
        return this.button.length;
    }

    public JRadioButton getOptionButton(int index) {
        return this.button[index];
    }

    public JRadioButton[] getOptionButtons() {
        return this.button;
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.button.length) {
            return;
        }
        int oldSelection = this.getSelectedIndex();
        this.group.setSelected(this.button[index].getModel(), true);
        this.repaint();
        int newSelection = this.getSelectedIndex();
        if (newSelection != oldSelection) {
            this.firePropertyChange(SELECTED_INDEX, oldSelection, newSelection);
        }
    }

    public int getSelectedIndex() {
        int i = 0;
        while (i < this.button.length) {
            if (this.group.isSelected(this.button[i].getModel())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean setSelectedLabel(String text) {
        int i = 0;
        while (i < this.button.length) {
            String s = this.button[i].getText();
            if (s != null && s.equals(text)) {
                this.setSelectedIndex(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getSelectedLabel() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        return this.button[selectedIndex].getText();
    }

    public void setDefaultIndex(int index) {
        if (index < 0 || index >= this.button.length) {
            return;
        }
        int oldDefaultValue = this.defaultValue;
        this.defaultValue = index;
        if (this.defaultValue != oldDefaultValue) {
            this.firePropertyChange(DEFAULT_INDEX, oldDefaultValue, this.defaultValue);
        }
    }

    public int getDefaultIndex() {
        return this.defaultValue;
    }

    public boolean setDefaultLabel(String text) {
        int i = 0;
        while (i < this.button.length) {
            String s = this.button[i].getText();
            if (s != null && s.equals(text)) {
                this.defaultValue = i;
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getDefaultLabel() {
        if (this.defaultValue < 0 || this.defaultValue >= this.button.length) {
            return null;
        }
        return this.button[this.defaultValue].getText();
    }

    public void setLabelText(int index, String label) {
        if (index < 0 || index >= this.button.length) {
            return;
        }
        if (label == null) {
            label = "";
        }
        this.button[index].setText(label);
    }

    public String getLabelText(int index) {
        if (index < 0 || index >= this.button.length) {
            return null;
        }
        return this.button[index].getText();
    }

    protected static int parseInt(String data, String caller) {
        try {
            return new XInt(data).getValue();
        }
        catch (ParseException parseException) {
            throw new JPTError("Malformed data in OptionsView." + caller + ": " + data);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

