/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.codec.CodecUtilities;
import edu.neu.ccs.gui.AlertEvent;
import edu.neu.ccs.gui.AlertListener;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.Fragile;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.util.DimensionUtilities;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DisplayPanel
extends JPanel
implements Displayable,
MalformedDataListener,
JPTConstants {
    public static final String CODEC = "codec";
    protected Color background = SystemColor.control;
    protected String codec = CodecUtilities.getDefaultCodec();

    public DisplayPanel() {
    }

    public DisplayPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public DisplayPanel(LayoutManager layout) {
        super(layout);
    }

    public DisplayPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public void setViewState(String data) {
        if (data == null) {
            return;
        }
        String[] decoded = CodecUtilities.decode(data);
        if (decoded == null) {
            return;
        }
        int i = 0;
        int pos = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof Displayable) {
                Displayable d = (Displayable)((Object)c);
                if (decoded != null && pos < decoded.length) {
                    d.setViewState(decoded[pos++]);
                }
            }
            ++i;
        }
        this.firePropertyChange("view.state", null, data);
    }

    public String getViewState() {
        Vector<String> temp = new Vector<String>();
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof Displayable) {
                Displayable d = (Displayable)((Object)c);
                temp.add(d.getViewState());
            }
            ++i;
        }
        String[] data = null;
        if (temp.size() > 0) {
            data = new String[temp.size()];
            int i2 = 0;
            while (i2 < temp.size()) {
                data[i2] = (String)temp.get(i2);
                ++i2;
            }
        }
        return CodecUtilities.encode(data, this.codec);
    }

    public void setDefaultViewState(String data) {
        String[] decoded = CodecUtilities.decode(data);
        int i = 0;
        int pos = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof Displayable) {
                Displayable d = (Displayable)((Object)c);
                if (decoded != null && pos < decoded.length) {
                    d.setDefaultViewState(decoded[pos++]);
                }
            }
            ++i;
        }
        this.firePropertyChange("default.view.state", null, data);
    }

    public String getDefaultViewState() {
        String[] defaultStates = null;
        Vector<String> v = new Vector<String>();
        int i = 0;
        boolean pos = false;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof Displayable) {
                Displayable d = (Displayable)((Object)c);
                v.add(d.getDefaultViewState());
            }
            ++i;
        }
        if (v.size() > 0) {
            Object[] statesArray = v.toArray();
            defaultStates = new String[statesArray.length];
            int i2 = 0;
            while (i2 < statesArray.length) {
                defaultStates[i2] = (String)statesArray[i2];
                ++i2;
            }
        }
        return CodecUtilities.encode(defaultStates);
    }

    public void setEnabled(boolean isEnabled) {
        int i = 0;
        while (i < this.getComponentCount()) {
            this.getComponent(i).setEnabled(isEnabled);
            ++i;
        }
        super.setEnabled(isEnabled);
    }

    public void reset() {
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof Displayable) {
                Displayable d = (Displayable)((Object)c);
                d.reset();
            }
            ++i;
        }
    }

    public void dataMalformed(MalformedDataEvent evt) {
        if (evt.isAlertOn()) {
            this.startAlert(evt);
        } else {
            this.endAlert(evt);
        }
    }

    public void startAlert(AlertEvent evt) {
        this.background = this.getBackground();
        this.setBackground(SystemColor.textHighlight);
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof AlertListener) {
                AlertListener a = (AlertListener)((Object)c);
                a.startAlert(evt);
            }
            ++i;
        }
    }

    public void endAlert(AlertEvent evt) {
        this.setBackground(this.background);
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof AlertListener) {
                AlertListener a = (AlertListener)((Object)c);
                a.endAlert(evt);
            }
            ++i;
        }
    }

    public Component add(Component c) {
        return this.add(c, -1);
    }

    public Component add(Component c, int index) {
        super.add(c, index);
        if (c != null && c instanceof Fragile) {
            Fragile f = (Fragile)((Object)c);
            f.addMalformedDataListener(this);
        }
        this.revalidate();
        return c;
    }

    public void add(Component c, Object constraints) {
        super.add(c, constraints);
        if (c != null && c instanceof Fragile) {
            Fragile f = (Fragile)((Object)c);
            f.addMalformedDataListener(this);
        }
        this.revalidate();
    }

    public void add(Component c, Object constraints, int index) {
        super.add(c, constraints, index);
        if (c != null && c instanceof Fragile) {
            Fragile f = (Fragile)((Object)c);
            f.addMalformedDataListener(this);
        }
        this.revalidate();
    }

    public Component add(String name, Component c) {
        super.add(name, c);
        if (c != null && c instanceof Fragile) {
            Fragile f = (Fragile)((Object)c);
            f.addMalformedDataListener(this);
        }
        this.revalidate();
        return c;
    }

    public Component addObject(Object object) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component);
        }
        return component;
    }

    public Component addObject(Object object, int index) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, index);
        }
        return component;
    }

    public Component addObject(Object object, Object constraints) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, constraints);
        }
        return component;
    }

    public Component addObject(Object object, Object constraints, int index) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, constraints, index);
        }
        return component;
    }

    public Component makeComponent(Object o) {
        return ComponentFactory.makeComponent(o);
    }

    public void remove(Component c) {
        super.remove(c);
        if (c != null && c instanceof Fragile) {
            Fragile f = (Fragile)((Object)c);
            f.removeMalformedDataListener(this);
        }
        this.revalidate();
    }

    public void remove(int index) {
        try {
            try {
                Component c = this.getComponent(index);
                if (c != null && c instanceof Fragile) {
                    Fragile f = (Fragile)((Object)c);
                    f.removeMalformedDataListener(this);
                }
            }
            catch (Exception exception) {
            }
            Object var3_4 = null;
            super.remove(index);
            this.revalidate();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            super.remove(index);
            this.revalidate();
            throw throwable;
        }
    }

    public void removeAll() {
        while (this.getComponentCount() > 0) {
            this.remove(0);
        }
    }

    public void uniformizeSize() {
        Component[] list = this.getComponents();
        int length = list.length;
        JComponent component = null;
        Dimension d = new Dimension();
        int i = 0;
        while (i < length) {
            if (list[i] instanceof JComponent) {
                component = (JComponent)list[i];
                d = DimensionUtilities.max(d, component.getPreferredSize());
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < length) {
            if (list[i2] instanceof JComponent) {
                component = (JComponent)list[i2];
                component.setPreferredSize(d);
            }
            ++i2;
        }
    }

    public void setCodec(String codecID) {
        String oldCodec = this.getCodec();
        if (codecID != null) {
            this.codec = codecID;
        }
        if (this.getCodec() != oldCodec) {
            this.firePropertyChange(CODEC, oldCodec, this.getCodec());
        }
    }

    public String getCodec() {
        return this.codec;
    }
}

