/*
 * @(#)ConsStrings.java  9 February 2003
 *
 *   Viera Proulx      vkp@ccs.neu.edu
 */

/*
 * A class that defines the behavior of a constructed
 * list of objects
 */
import java.awt.*;
import java.awt.geom.*;

public class ConsStrings extends AListStrings{


    /*--------------------------------------------------------
     Member data
     -------------------------------------------------------*/
    String  first;
    AListStrings rest;

    /*--------------------------------------------------------
     Constructor
     -------------------------------------------------------*/
    public ConsStrings(String s, AListStrings alos){
        this.first = s;
        this.rest  = alos;
    }
                                       
    /*--------------------------------------------------------
     MapStringToString: 
     consume (String1 -> String2) (list of String1)
     produce (list of String2)
    --------------------------------------------------------*/
    AListStrings mapStringToString(IString2String s2s){
        return new ConsStrings( s2s.apply(this.first), 
                                rest.mapStringToString(s2s));
    }
     
    /*--------------------------------------------------------
     MapStringToBoolean: 
     consume (String1 -> boolean) (list of String1)
     produce (list of boolean)
    --------------------------------------------------------*/
    AListBool mapStringToBool(IString2Bool s2b){
        return new ConsBool( s2b.apply(this.first), 
                                rest.mapStringToBool(s2b));
    }
     
    /*--------------------------------------------------------
     OrMap: (String -> boolean) (list of String) -> boolean
    --------------------------------------------------------*/
    boolean orMapString(IString2Bool s2b){
        if (s2b.apply(this.first))
            return true;
        else
            return rest.orMapString(s2b);
    }

    /*--------------------------------------------------------
     Count the number of the items in this list
     -------------------------------------------------------*/
    int count(){
        return (1 + this.rest.count());
    }
        
    /*--------------------------------------------------------
     Print the contents of this list
     -------------------------------------------------------*/
    public String toString(){
        return "new " + getClass().getName() + "("
               + first.toString() + ",\n\t" + rest.toString() + ")";
    }
        
    
}
    
