/* AListStringTest.java 5 February 2003 */

public class AListStringTest extends JPFalt 
{
    public static void main(String[] args) { new AListStringTest(); }

    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////

    /* Test suite for the class AListStringTest, EmptyStrings, ConsStrings */

	/*---------------------------------------------------------------- 
	 Define three AListStrings objects to use in all tests.
	----------------------------------------------------------------*/	
	
	AListStrings emptyList = new EmptyStrings();
	AListStrings list1 = new EmptyStrings();
	
	AListStrings list2 = new ConsStrings(new String("nowhere"),
	                     new ConsStrings(new String("here"), 
	                     emptyList));
	
	AListStrings list3 = new ConsStrings(new String("how now my"), 
	                     new ConsStrings(new String("now where"), 
	                     new ConsStrings(new String("brown cow"), 
	                     new ConsStrings(new String("cowardly lion"), 
	                     new ConsStrings(new String("lower than"), 
	                     emptyList)))));
	                     
    /*-------------------------------------------------------------------- 
     Print the member data values of the defined AListStringTest objects.
    --------------------------------------------------------------------*/
    void TestConsStrings(){

    	println("\nDefine AListObjects objects");
        actual(list1);
        actual(list2);
        actual(list3);
    
    }
    /*-------------------------------------------------------------------- 
     Test the count method.
    --------------------------------------------------------------------*/
    void TestCountMethod(){
    	testHeader( "count()");
    	                    
    	expected(0);
    	actual( list1.count());
    	
    	expected(2);
    	actual( list2.count());
    	
    	expected(5);
    	actual( list3.count());
    	
    }

    /*----------------------------------------------------
     Test of the IString2String and map
     ---------------------------------------------------*/
    void TestMapS2S(){
    
    	println("\nTest map from String to replace 'w' with 'x'\n");
    	
    	actual(list3.mapStringToString(
    	
    	    /* define the map method implementing class */
           new IString2String(){
               public String apply(String s){
               
                   return new String(s.replace('w', 'x'));
                   
               } // end on-the-fly method definition
           } // end annonymous inner class definition
    	                         ) // end map_command invocation
    	                         
    	); // end actual invocation
    }
    
    /*----------------------------------------------------
     Test of the IString2Bool and mapString2Bool
     ---------------------------------------------------*/
    void TestMapS2B(){

    	println("\nTest mapString2Bool: s of length <9 \n");
    	actual(list3.mapStringToBool(
    	
    	    /* define the map method implementing class */
           new IString2Bool(){
               public boolean apply(String s){
               
                   return (s.length() > 9);
                   
               } // end on-the-fly method definition
           } // end annonymous inner class definition
    	                         ) // end map_command invocation
    	                         
    	); // end actual invocation

    }
    
    /*----------------------------------------------------
     Test of the IString2Bool and orMapString
     ---------------------------------------------------*/
    void TestOrMapS2B(){

        /* first test - with list1 */
    	println("\nTest orMapString: s of length >9 \n");
    	
    	expected(true);
    	actual(list3.orMapString(
    	
    	    /* define the map method implementing class */
           new IString2Bool(){
               public boolean apply(String s){
               
                   return (s.length() > 9);
                   
               } // end on-the-fly method definition
           } // end annonymous inner class definition
    	                         ) // end map_command invocation
    	                         
    	); // end actual invocation

        /* second test - with list2 */
    	println("\nTest orMapString of String-s of length >9 \n");
    	
    	expected(false);
    	actual(list2.orMapString(
    	
    	    /* define the map method implementing class */
           new IString2Bool(){
               public boolean apply(String s){
               
                   return (s.length() > 9);
                   
               } // end on-the-fly method definition
           } // end annonymous inner class definition
    	                         ) // end map_command invocation
    	                         
    	); // end actual invocation
  
        /* third test - with list3 */
    	println("\nTest andMap of String-s of length <5");
    	
    	expected(true);
    	actual(list3.orMapString(
    	
    	    /* define the map method implementing class */
           new IString2Bool(){
               public boolean apply(String s){
               
                   return (s.length() > 5);
                   
               } // end on-the-fly method definition
           } // end annonymous inner class definition
    	                         ) // end map_command invocation
    	                         
    	); // end actual invocation
  
    }    
    /*--------------------------------------------------------------------- 
     End of test suite for classes AListStrings, EmptyStrings, ConsStrings
    ---------------------------------------------------------------------*/    
    
}
