/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;

public class Transform1D
implements Cloneable,
Serializable {
    protected double factor = 1.0;
    protected double offset = 0.0;

    public Transform1D() {
    }

    public Transform1D(double f, double o) {
        this.setTransform(f, o);
    }

    public Transform1D(double a1, double a2, double b1, double b2) {
        this.setTransform(a1, a2, b1, b2);
    }

    public void setTransform(double f, double o) {
        this.factor = f;
        this.offset = o;
    }

    public void setTransform(double a1, double a2, double b1, double b2) {
        double ma = (a1 + a2) / 2.0;
        double mb = (b1 + b2) / 2.0;
        double da = a2 - a1;
        double db = b2 - b1;
        this.factor = da != 0.0 ? db / da : 0.0;
        this.offset = mb - this.factor * ma;
    }

    public void setTransform(Transform1D other) {
        this.factor = other.factor;
        this.offset = other.offset;
    }

    public void setFactor(double f) {
        this.factor = f;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setOffset(double o) {
        this.offset = o;
    }

    public double getOffset() {
        return this.offset;
    }

    public double transform(double z) {
        return this.factor * z + this.offset;
    }

    public boolean hasInverse() {
        return this.factor != 0.0;
    }

    public double inverseTransform(double w) throws NoninvertibleTransformException {
        if (this.hasInverse()) {
            return (w - this.offset) / this.factor;
        }
        throw new NoninvertibleTransformException("Transform1D has no inverse");
    }

    public Transform1D createInverse() throws NoninvertibleTransformException {
        if (this.hasInverse()) {
            return new Transform1D(1.0 / this.factor, -this.offset / this.factor);
        }
        throw new NoninvertibleTransformException("Transform1D has no inverse");
    }
}

