/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Displayable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class DisplayCollection
extends DisplayPanel {
    public static final int DEFAULT_ORIENTATION = 1;
    protected int direction = 1;
    protected DisplayPanel inner = new DisplayPanel();

    public DisplayCollection() {
        this(null, 1);
    }

    public DisplayCollection(int orientation) {
        this(null, orientation);
    }

    public DisplayCollection(Displayable[] obj) {
        this(obj, 1);
    }

    public DisplayCollection(Displayable[] obj, int orientation) {
        this.setLayout(new BorderLayout());
        super.add((Component)this.inner, "North");
        super.add((Component)new JPanel(), "Center");
        this.setOrientation(orientation);
        if (obj != null) {
            int i = 0;
            while (i < obj.length) {
                this.add((Component)((Object)obj[i]));
                ++i;
            }
        }
    }

    public void setViewState(String data) {
        this.inner.setViewState(data);
        this.firePropertyChange("view.state", null, data);
    }

    public String getViewState() {
        return this.inner.getViewState();
    }

    public void setDefaultViewState(String data) {
        this.inner.setDefaultViewState(data);
        this.firePropertyChange("default.view.state", null, data);
    }

    public String getDefaultViewState() {
        return this.inner.getDefaultViewState();
    }

    public void reset() {
        this.inner.reset();
    }

    public Component add(Component c) {
        this.inner.add(c);
        this.revalidate();
        return c;
    }

    public Component add(Component c, int index) {
        this.inner.add(c, index);
        this.revalidate();
        return c;
    }

    public void add(Component c, Object constraints) {
        this.inner.add(c, constraints);
        this.revalidate();
    }

    public void add(Component c, Object constraints, int index) {
        this.inner.add(c, constraints, index);
        this.revalidate();
    }

    public Component add(String name, Component c) {
        this.inner.add(name, c);
        this.revalidate();
        return c;
    }

    public void remove(Component c) {
        this.inner.remove(c);
        this.revalidate();
    }

    public void remove(int index) {
        this.inner.remove(index);
        this.revalidate();
    }

    public void removeAll() {
        this.inner.removeAll();
        this.revalidate();
    }

    public Component getItem(int index) {
        return this.inner.getComponent(index);
    }

    public Component[] getItemArray() {
        return this.inner.getComponents();
    }

    public int getItemCount() {
        return this.inner.getComponentCount();
    }

    public void setOrientation(int orientation) {
        int oldOrientation = this.getOrientation();
        switch (orientation) {
            case 0: 
            case 1: {
                this.direction = orientation;
                break;
            }
            case -1: {
                this.direction = 1;
                break;
            }
            default: {
                return;
            }
        }
        switch (this.direction) {
            case 0: {
                this.inner.setLayout(new BoxLayout(this.inner, 0));
                break;
            }
            default: {
                this.inner.setLayout(new BoxLayout(this.inner, 1));
            }
        }
        this.revalidate();
        if (this.getOrientation() != oldOrientation) {
            this.firePropertyChange("orientation", oldOrientation, this.getOrientation());
        }
    }

    public int getOrientation() {
        return this.direction;
    }

    public DisplayPanel getCollectionPanel() {
        return this.inner;
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        int i = 0;
        while (i < this.getComponentCount()) {
            Component comp = this.getComponent(i);
            comp.setBackground(background);
            ++i;
        }
    }
}

