/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.console;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.console.ConsoleTextPane;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.util.FileExistsException;
import edu.neu.ccs.util.FileUtilities;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

final class ConsoleWindow
extends JPTFrame
implements ConsoleAware,
JPTConstants,
Serializable {
    public static final int OUT = 0;
    public static final int ERR = 1;
    public static final int IN = 2;
    private Hashtable actions = null;
    private Action save = null;
    private Action transcript = null;
    private transient FileOutputStream scriptStream = null;
    private File scriptFile = null;
    private JScrollPane scroll = null;
    private ConsoleTextPane tablet = null;

    public ConsoleWindow() {
        super("Text console");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new 1());
        this.tablet = new ConsoleTextPane(this);
        this.actions = this.createActionsTable();
        this.setJMenuBar(this.createMenuBar());
        this.save.setEnabled(false);
        this.scroll = new JScrollPane(this.tablet);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.setContentPane(this.scroll);
        ((Component)this).setSize(640, 480);
        this.setResizable(false);
        this.setFontSize(14);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.scriptStream = new FileOutputStream(this.scriptFile);
        }
        catch (Exception exception) {
            this.scriptFile = null;
            this.scriptStream = null;
            this.transcript.putValue("Name", "Start transcript");
        }
    }

    public void consoleInputPerformed(String text) {
        this.save.setEnabled(true);
        this.fireConsoleInputPerformed(text);
    }

    public void consoleOutputPerformed(String text, int stream) {
        block2: {
            this.save.setEnabled(true);
            this.tablet.append(text, stream);
            if (this.scriptStream == null) break block2;
            try {
                this.scriptStream.write(text.getBytes());
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "There was an error writing to the transcript file.", "Warning!", 2);
            }
        }
    }

    public synchronized void setInputMode(boolean input) {
        if (input) {
            this.tablet.setStream(2);
        } else {
            this.tablet.setStream(0);
        }
    }

    public void setInputColor(Color c) {
        this.tablet.setInputColor(c);
    }

    public Color getInputColor() {
        return this.tablet.getInputColor();
    }

    public void setOutputColor(Color c) {
        this.tablet.setOutputColor(c);
    }

    public Color getOutputColor() {
        return this.tablet.getOutputColor();
    }

    public void setErrorColor(Color c) {
        this.tablet.setErrorColor(c);
    }

    public Color getErrorColor() {
        return this.tablet.getErrorColor();
    }

    public void setFontSize(int size) {
        size = size < 4 ? 4 : size;
        size = size > 72 ? 72 : size;
        this.tablet.setFontSize(size);
    }

    public void close() {
        if (this.save.isEnabled() && JOptionPane.showConfirmDialog(this, "Do you want to save a transcript of the console contents?", "Save contents", 0) == 0) {
            this.save();
        }
        ConsoleAware.console.setActivated(false);
        ((Component)this).setVisible(false);
        this.dispose();
        if (JPTFrame.getJPTFrameCount() == 0) {
            System.exit(0);
        }
    }

    private synchronized void fireConsoleInputPerformed(String text) {
        ConsoleAware.console.consoleInputPerformed(text);
    }

    private Hashtable createActionsTable() {
        Hashtable<String, Action> table = new Hashtable<String, Action>();
        Action[] a = this.tablet.getActions();
        int i = 0;
        while (i < a.length) {
            table.put((String)a[i].getValue("Name"), a[i]);
            ++i;
        }
        return table;
    }

    private Action getAction(String name) {
        return (Action)this.actions.get(name);
    }

    private JMenuBar createMenuBar() {
        JMenuBar m = new JMenuBar();
        JMenu file = new JMenu("File");
        this.save = new 2("Save contents");
        file.add(this.save);
        this.transcript = new 3("Start transcript");
        file.add(this.transcript);
        file.addSeparator();
        file.add(new 4("Close window"));
        m.add(file);
        JMenu edit = new JMenu("Edit");
        edit.add(new 5("Cut"));
        edit.add(new 6("Copy"));
        edit.add(new 7("Paste"));
        edit.addSeparator();
        edit.add(new 8("Select all"));
        m.add(edit);
        JMenu font = new JMenu("Font size");
        font.add(new 9("10 point"));
        font.add(new 10("12 point"));
        font.add(new 11("14 point"));
        font.add(new 12("16 point"));
        font.add(new 13("18 point"));
        font.add(new 14("24 point"));
        font.add(new 15("36 point"));
        m.add(font);
        return m;
    }

    private void save() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Save contents");
        fc.setFileFilter(new 16());
        while (fc.showSaveDialog(this) == 0) {
            try {
                try {
                    FileUtilities.writeFile(fc.getSelectedFile(), this.tablet.getText(), false);
                    this.save.setEnabled(false);
                }
                catch (FileExistsException fileExistsException) {
                    int result = JOptionPane.showConfirmDialog(null, "A file with that name already exists.  Do you want to overwrite it?", "Warning!", 1, 2);
                    if (result == 0) {
                        FileUtilities.writeFile(fc.getSelectedFile(), this.tablet.getText(), true);
                        this.save.setEnabled(false);
                        break;
                    }
                    if (result != 2) continue;
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "The file could not be saved.", "Error!", 0);
            }
            break;
        }
    }

    private void transcript() {
        if (this.scriptStream == null) {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Start transcript");
            fc.setFileFilter(new 17());
            while (fc.showDialog(this, "Select") == 0) {
                File file = fc.getSelectedFile();
                if (file.exists() && JOptionPane.showConfirmDialog(null, "A file with that name already exists.  Do you want to overwrite it?", "Warning!", 1, 2) != 0) continue;
                try {
                    this.scriptFile = fc.getSelectedFile();
                    this.scriptStream = new FileOutputStream(this.scriptFile);
                    this.transcript.putValue("Name", "Stop transcript");
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "The transcript could not be opened.", "Error!", 0);
                }
                break;
            }
        } else if (JOptionPane.showConfirmDialog(null, "Do you want to close the transcript file?", "Stop transcript", 0) == 0) {
            try {
                try {
                    this.scriptStream.close();
                }
                catch (IOException iOException) {
                }
                Object var2_4 = null;
                this.scriptFile = null;
                this.scriptStream = null;
                this.transcript.putValue("Name", "Start transcript");
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                this.scriptFile = null;
                this.scriptStream = null;
                this.transcript.putValue("Name", "Start transcript");
                throw throwable;
            }
        }
    }

    private ConsoleTextPane getTextPane() {
        return this.tablet;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            ConsoleWindow.this.close();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.save();
        }

        /* synthetic */ 2(String $0) {
            super($0);
        }
    }

    private final class 3
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.transcript();
        }

        /* synthetic */ 3(String $0) {
            super($0);
        }
    }

    private final class 4
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.close();
        }

        /* synthetic */ 4(String $0) {
            super($0);
        }
    }

    private final class 5
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.getTextPane().cut();
        }

        /* synthetic */ 5(String $0) {
            super($0);
        }
    }

    private final class 6
    extends AbstractAction {
        public void actionPerformed(ActionEvent evt) {
            Action a = ConsoleWindow.this.getAction("copy-to-clipboard");
            if (a != null) {
                a.actionPerformed(evt);
            }
        }

        /* synthetic */ 6(String $0) {
            super($0);
        }
    }

    private final class 7
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.getTextPane().paste();
        }

        /* synthetic */ 7(String $0) {
            super($0);
        }
    }

    private final class 8
    extends AbstractAction {
        public void actionPerformed(ActionEvent evt) {
            Action a = ConsoleWindow.this.getAction("select-all");
            if (a != null) {
                a.actionPerformed(evt);
            }
        }

        /* synthetic */ 8(String $0) {
            super($0);
        }
    }

    private final class 9
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.setFontSize(10);
        }

        /* synthetic */ 9(String $0) {
            super($0);
        }
    }

    private final class 10
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.setFontSize(12);
        }

        /* synthetic */ 10(String $0) {
            super($0);
        }
    }

    private final class 11
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.setFontSize(14);
        }

        /* synthetic */ 11(String $0) {
            super($0);
        }
    }

    private final class 12
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.setFontSize(16);
        }

        /* synthetic */ 12(String $0) {
            super($0);
        }
    }

    private final class 13
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.setFontSize(18);
        }

        /* synthetic */ 13(String $0) {
            super($0);
        }
    }

    private final class 14
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.setFontSize(24);
        }

        /* synthetic */ 14(String $0) {
            super($0);
        }
    }

    private final class 15
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.setFontSize(36);
        }

        /* synthetic */ 15(String $0) {
            super($0);
        }
    }

    private final class 16
    extends FileFilter {
        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return "All files (*.*)";
        }

        /* synthetic */ 16() {
        }
    }

    private final class 17
    extends FileFilter {
        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return "All files (*.*)";
        }

        /* synthetic */ 17() {
        }
    }
}

