/*
 * @(#)ConsObjects.java  5 February 2003
 *
 *   Viera Proulx      vkp@ccs.neu.edu
 */

/*
 * Cons variant: class that defines the behavior of
 *               a list of objects
 */
import java.awt.*;
import java.awt.geom.*;

public class ConsObjects extends AListObjects{

    IMeasurable first;
    AListObjects rest;
    
    /*--------------------------------------------------------
     Constructor
     -------------------------------------------------------*/
    public ConsObjects(IMeasurable imObj, AListObjects aLobj){
        this.first = imObj;
        this.rest  = aLobj;
    }
    
    /*--------------------------------------------------------
     Template:
         ...this.first...this.rest...this.first.size()...
         ...this.rest.totalSize()...
     -------------------------------------------------------*/
                                       
    /*--------------------------------------------------------
     Compute the total size of the items in this list
     -------------------------------------------------------*/
    int totalSize(){
        return (this.first.size() + this.rest.totalSize());
    }
        
    /*--------------------------------------------------------
     Print the contents of this list
     -------------------------------------------------------*/
    public String toString(){
        return "new " + getClass().getName() + "("
               + first + ",\n\t" + rest + ")";
    }
        
    
}
    
