/*
 * @(#)AListObjects.java  5 February 2003
 *
 *   Viera Proulx      vkp@ccs.neu.edu
 */

/*
 * Abstract class that defines the behavior of a list of objects
 */
import java.awt.*;
import java.awt.geom.*;

public abstract class AListObjects{
    
    /* data definition:
     *   List of Objects is 
     *      either empty
     *      or     structure: 
     *                 first - an Object
     *                 rest  - a List of Objects
     *
     * example:
     * a-lon: empty
     * shortListObjects:  (3 (4 (5 empty)
     * longListObjects:   (1 2 3 4 5 6 7 empty)
     */    
     
    /*--------------------------------------------------------
     Compute the total size of the items in this list
     -------------------------------------------------------*/
    abstract int totalSize();        
}
    
