/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

public class MathUtilities {
    public static int randomInt(int min, int max) {
        long b;
        long a;
        if (min <= max) {
            a = min;
            b = max;
        } else {
            a = max;
            b = min;
        }
        long r = a + (long)((double)(b - a + 1L) * Math.random());
        if (r > b) {
            r = b;
        }
        return (int)r;
    }

    public static double randomDouble(double min, double max) {
        double b;
        double a;
        if (min <= max) {
            a = min;
            b = max;
        } else {
            a = max;
            b = min;
        }
        double t = Math.random();
        double r = (1.0 - t) * a + t * b;
        if (r < a) {
            r = a;
        } else if (r > b) {
            r = b;
        }
        return r;
    }

    public static double sindeg(double degrees) {
        return Math.sin(Math.toRadians(degrees));
    }

    public static double cosdeg(double degrees) {
        return Math.cos(Math.toRadians(degrees));
    }

    public static double tandeg(double degrees) {
        return Math.tan(Math.toRadians(degrees));
    }

    public static double asindeg(double value) {
        return Math.toDegrees(Math.asin(value));
    }

    public static double acosdeg(double value) {
        return Math.toDegrees(Math.acos(value));
    }

    public static double atandeg(double value) {
        return Math.toDegrees(Math.atan(value));
    }

    public static double atan2deg(double y, double x) {
        return Math.toDegrees(Math.atan2(y, x));
    }

    public static int GCD(int a, int b) {
        if (b == 0) {
            return Math.abs(a);
        }
        return MathUtilities.GCD(b, a % b);
    }

    public static long GCD(long a, long b) {
        if (b == 0L) {
            return Math.abs(a);
        }
        return MathUtilities.GCD(b, a % b);
    }
}

