/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XShort
extends XNumber {
    public short value = 0;

    public XShort() {
    }

    public XShort(short s) {
        this.value = s;
    }

    public XShort(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        short oldValue = this.value;
        Parser p = ParserUtilities.getDefaultParser();
        Object obj = p.parse(data);
        if (!(obj instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", data.length());
        }
        XNumber n = (XNumber)obj;
        this.value = n.shortValue();
        this.changeAdapter.firePropertyChange("value", new Short(oldValue), data);
    }

    public String toStringData() {
        return String.valueOf(this.value);
    }

    public byte byteValue() {
        if (this.getValue() > 127 || this.getValue() < -128) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue();
    }

    public short shortValue() {
        return this.getValue();
    }

    public int intValue() {
        return this.getValue();
    }

    public long longValue() {
        return this.getValue();
    }

    public float floatValue() {
        return this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public boolean equals(Object other) {
        if (other instanceof XShort) {
            return this.getValue() == ((XShort)other).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Short(this.getValue()).hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(short s) {
        short oldValue = this.value;
        this.value = s;
        if (this.getValue() != oldValue) {
            this.changeAdapter.firePropertyChange("value", new Short(oldValue), new Short(this.getValue()));
        }
    }

    public short getValue() {
        return this.value;
    }

    public static short parseShort(String s) throws NumberFormatException {
        try {
            return new XShort((String)s).value;
        }
        catch (ParseException e) {
            throw new NumberFormatException(XObject.formatErrorMessage(e, s));
        }
    }

    public static short[] toPrimitiveArray(XShort[] x) {
        if (x == null) {
            return null;
        }
        short[] temp = new short[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XShort[] toXArray(short[] a) {
        if (a == null) {
            return null;
        }
        XShort[] temp = new XShort[a.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = new XShort(a[i]);
            ++i;
        }
        return temp;
    }
}

