/*
 * @(#)Staff.java  1.0  3 December 2002
 *
 * <P> A class to represent a staff member. </P>
 * @author Viera K. Proulx
 */
public class Staff extends APerson{

	/*------------------------------------------------------------------------- 
	 Data Definition: 
    -------------------------------------------------------------------------*/
    
    /* The department where this staff member works */
    String department;
    
    /* This employer's hourly wage. */
    int wages;
		
	/*------------------------------------------------------------------------- 
	 Constructor:  to create an object in the class Staff and initialize
	 		        all member data.
    -------------------------------------------------------------------------*/
    Staff(String aName, int aDOB, String aDept, int aWage){
        
        this.name = aName;
        this.dob = aDOB;
        this.department = aDept;
        this.wages = aWage;
    }
	
	/*------------------------------------------------------------------------- 
	 Methods: 
    -------------------------------------------------------------------------*/
	
	/*------------------------------------------------------------------------- 	 
	 Purpose: to determine whether this person is in the given department
	 
	 Template:
	            ...this.name...this.dob...this.department...this.wages..
    -------------------------------------------------------------------------*/
	boolean thisDepartment(String someDepartment){
		return (this.department.equals(someDepartment));
	}
	
	/*------------------------------------------------------------------------- 	 
	 Purpose: to determine this person's pay given the hours worked
	 
	 Template:
	            ...this.name...this.dob...this.department...this.wages..
    -------------------------------------------------------------------------*/
	int computePay(int someHours){
		return (this.wages * someHours);
	}
	
	/*------------------------------------------------------------------------- 
	 Helper method to print the object member data - overriding the base method
    -------------------------------------------------------------------------*/
	public String toString(){
		return("Instructor(" + 
					name       + ", " + 
					dob        + ", " + 
					department + ", " + 
					wages      + ")");
	}
}
