/*
 * @(#)Person.java  1.0  3 December 2002
 *
 * <P> A class to represent one person. </P>
 * @author Viera K. Proulx
 */
public abstract class Person {

	/*------------------------------------------------------------------------- 
	 Data Definition: 
    -------------------------------------------------------------------------*/

	/* The lastName given as a String. */
	String lastName;
	
	/* The firstName given as a String. */
	String firstName;
	
	/* The year of birth given as an int. */
	int dob;
		
	/*------------------------------------------------------------------------- 
	 Methods: 
    -------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------- 	 
	 Purpose: to find the first letter of this person's last name 
    -------------------------------------------------------------------------*/
	char initial(){
		return this.lastName.charAt(0);
	}
	
	
	/*------------------------------------------------------------------------- 	 
	 Purpose: to determine whether this person 
	           is before a given person in alphabetical order 
    -------------------------------------------------------------------------*/
	boolean isBefore(String someName){
		return (compare(this.lastName, someName));		
	}

	
	/*------------------------------------------------------------------------- 	 
	 Purpose: to determine whether this person is older than given person
    -------------------------------------------------------------------------*/
	boolean olderThan(Person somePerson){
		return (this.dob < somePerson.dob);
	}
		
	/*------------------------------------------------------------------------- 
	 Purpose:   Helper method to compare two Strings    
    -------------------------------------------------------------------------*/
	boolean compare(String firstString, String secondString){
		return (firstString.compareTo(secondString) < 0);
	}
	
	/*------------------------------------------------------------------------- 
	 Purpose:   to print the member data of a Person object   
    -------------------------------------------------------------------------*/
	public String toString(){
		return("new " + getClass().getName() + "(" + 
					lastName  + ", " + 
					firstName + ", " + 
					dob       + ")");
	}
}
