/*
 * @(#)Instructor.java  1.0  3 December 2002
 *
 * <P> A class to represent an instructor. </P>
 * @author Viera K. Proulx
 */
public class Instructor extends APerson{

	/*------------------------------------------------------------------------- 
	 Data Definition: 
    -------------------------------------------------------------------------*/
    
    /* The department where this instructor teaches */
    String department;
    
    /* This instructor's title */
    String title;
		
	/*------------------------------------------------------------------------- 
	 Constructor:  to create an object in the class Instructor and initialize
	 		        all member data.
    -------------------------------------------------------------------------*/
    Instructor(String aName, int aDOB, String aDept, String aTitle){
        
        this.name = aName;
        this.dob = aDOB;
        this.department = aDept;
        this.title = aTitle;
    }
	
	/*------------------------------------------------------------------------- 
	 Methods: 
    -------------------------------------------------------------------------*/
	
	/*------------------------------------------------------------------------- 	 
	 Purpose: to determine whether this person is in the given department
	 
	 Template:
	            ...this.name...this.dob...this.department...this.title..
    -------------------------------------------------------------------------*/
	boolean thisDepartment(String someDepartment){
		return (this.department.equals(someDepartment));
	}
	
	/*------------------------------------------------------------------------- 
	 Helper method to print the object member data - overriding the base method
    -------------------------------------------------------------------------*/
	public String toString(){
		return("Instructor(" + 
					name       + ", " + 
					dob        + ", " + 
					department + ", " + 
					title      + ")");
	}
}
