/*
 * @(#)WeatherData.java  1.0  18 November 2002
 *
 * <P> A class to define a weather record object for one day. </P> 
 *
 * @author Viera K. Proulx
 */

import java.awt.*;

public class WeatherData {

	/*------------------------------------------------------------------------- 
	 Data Definition: 
    -------------------------------------------------------------------------*/

	/* The low temperature for this day. */
	int low;
	
	/* The high temperature for this day. */
	int high;			
			
	/* The amount of precipitation for this day. */
	double precipitation;
	
	/*------------------------------------------------------------------------- 
	 The constructor
	 ---------------
	 
	 Contract: new WeatherData(lowTemp, highTemp, prec)
	 
	 Purpose: to create an object in the class WeatherData and initialize
	 		  all member data.
	 
	 Examples:
	 		WeatherData today     = new WeatherData(20, 50, 0.2);
    		WeatherData yesterday = new WeatherData(24, 49, 0);
    -------------------------------------------------------------------------*/
	WeatherData(int lowTemp, int highTemp, double prec){
		this.low           = lowTemp;
		this.high          = highTemp;
		this.precipitation = prec;
	}
	
	/*------------------------------------------------------------------------- 
	 Methods: 
    -------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------- 	 
	 Contract:	int <- tempRange()
	 
	 Purpose: 	to compute the temperature range for this day
	 
	 Example:   today     -- low: 20, high: 50, precipitation: 0.2
                yesterday -- low: 24, high: 49, precipitation: 0
	 				     
				30	<- 	today.tempRange()
				25	<- 	yesterday.tempRange()
	           
	 Template: 	int <- tempRange(){
					return ... this.low...this.high ...this.precipitation... ;
			  	} 
   -------------------------------------------------------------------------*/
	int tempRange(){
		return this.high - this.low;
	}
	
	/*------------------------------------------------------------------------- 	 
	 Contract:	int <- mean()
	 
	 Purpose: 	to compute the mean temperature for this day (rounded down)
	 
	 Example:   today     -- low: 20, high: 50, precipitation: 0.2
                yesterday -- low: 24, high: 49, precipitation: 0
	 				     
				35	<- 	today.mean()
				36	<- 	yesterday.mean()
	           
	 Template: 	int <- mean(){
					return ... this.low...this.high ...this.precipitation... ;
			  	} 
   -------------------------------------------------------------------------*/
	int mean(){
		return (this.high + this.low) / 2;
	}
	
	
	/*------------------------------------------------------------------------- 	 
	 Contract:	String <- tempPhrase()
	 
	 Purpose: 	to produce a phrase describing today's temperature
	 
	 Example:   today     -- low: 20, high: 50, precipitation: 0.2
                yesterday -- low: 74, high: 98, precipitation: 0
	 				     
				"cold"	<- 	today.tempPhrase()
				"hot"	<- 	yesterday.tempPhrase()
	           
	 Template: 	String <- tempPhrase(){
					return ... this.low...this.high ...this.precipitation... ;
			  	} 
   -------------------------------------------------------------------------*/
	String tempPhrase(){
		if (mean() < 0)
		    return "very cold";
		if (mean() < 35)
		    return "cold";
		if (mean() < 50)
		    return "cool";
		if (mean() < 70)
		    return "mild";
		if (mean() < 85)
		    return "hot";
		if (mean() < 150)
		    return "very hot";
		else
		    return "";   
	}
	
	/*------------------------------------------------------------------------- 	 
	 Contract:	Color <- mapColor()
	 
	 Purpose: 	to produce a color that represents today's temperature
	            (e.g. on a weather map)
	 
	 Example:   today     -- low: 20, high: 50, precipitation: 0.2
                yesterday -- low: 74, high: 98, precipitation: 0
	 				     
				"blue"	<- 	today.mapColor()
				"red"	<- 	yesterday.mapColor()
	           
	 Template: 	Color <- mapColor(){
					return ... this.low...this.high ...this.precipitation... ;
			  	} 
   -------------------------------------------------------------------------*/
	Color mapColor(){
		if (mean() < 0)
		    return Color.cyan;
		if (mean() < 35)
		    return Color.blue;
		if (mean() < 50)
		    return Color.green;
		if (mean() < 70)
		    return Color.yellow;
		if (mean() < 85)
		    return Color.red;
		if (mean() < 150)
		    return Color.magenta;
		else
		    return Color.white;   
	}
	
		
	/*------------------------------------------------------------------------- 
	 Helper method to print the object member data.
    -------------------------------------------------------------------------*/
	public String toString(){
		return("new " + getClass().getName() + "(" + 
					low             + ", " + 
					high            + ", " + 
					precipitation   + ")");
	}
}
