/*
 * @(#)DayData.java  1.0  4 December 2002
 *
 * <P> A class to define a weather record object for one day. </P> 
 * @author Viera K. Proulx
 */
import java.awt.*;

public class DayData {

	/*------------------------------------------------------------------------- 
	 Data Definition: 
    -------------------------------------------------------------------------*/

	/* The actual weather record for this day. */
	WeatherData today;
	
	/* The normal weather record for this day of the year. */
	WeatherData normal;
			
	/* The weather record of record values for this day of the year. */
	WeatherData record;
	
	/*------------------------------------------------------------------------- 
	 The constructor
	 ---------------
	 
	 Purpose: to create an object in the class DayData and initialize
	 		  all member data.
	 -------------------------------------------------------------------------*/
	DayData(WeatherData now, WeatherData norm, WeatherData tops){
		this.today  = now;
		this.normal = norm;
		this.record = tops;
	}
	
	/*------------------------------------------------------------------------- 
	 Methods: 
    -------------------------------------------------------------------------*/

	/*------------------------------------------------------------------------- 	 
	 Purpose: 	to determine the weather today's temperature was within normal
	 Template: 	boolean <- withinNorm(){
					return ... this.today.low  ... this.normal.low  ...
					       ... this.record.low...
					       
					       ... this.today.high ... this.normal.high ...
					       ... this.record.high ...
					       
					       ... this.today.precipitation ...
					       ... this.normal.precipitation ...
					       ... this.record.precipitation ... ;
			  	} 
   -------------------------------------------------------------------------*/
	boolean withinNorm(){
		return (   (this.today.high < this.normal.high)
		        && (this.today.low  > this.normal.low));
	}
	
	/*------------------------------------------------------------------------- 	 
	 Purpose: 	to determine the mean temperature today
	 Template: 	int <- meanToday(){
					return ... this.today.low  ... this.normal.low  ...
					       ... this.record.low...
					       
					       ... this.today.high ... this.normal.high ...
					       ... this.record.high ...
					       
					       ... this.today.precipitation ...
					       ... this.normal.precipitation ...
					       ... this.record.precipitation ... ;
			  	} 
   -------------------------------------------------------------------------*/
	int meanToday(){
		return (this.today.high + this.today.high)/2;
	}
	
	/*------------------------------------------------------------------------- 	 
	 Purpose: 	to determine the mean temperature today
	 Template: 	int <- meanToday(){
					return ... this.today.low <...
					       ... this.record.low...
					       
					       ... this.today.high >
					       ... this.record.high ...
					       
					       ... this.today.precipitation >...
					       ... this.record.precipitation ... ;
			  	} 
   -------------------------------------------------------------------------*/
	boolean newRecord(){
		if (this.today.low < this.record.low)
		    return true;
		
		if ( this.today.high >this.record.high)
		    return true;
		    
		if (this.today.precipitation > this.record.precipitation)
		    return true;
		    
		else return false;
	}
	
	/*------------------------------------------------------------------------- 
	 Helper method to print the object member data.
	 Purpose:   to print the member data of a DayData object   
    -------------------------------------------------------------------------*/
	public String toString(){
		return("new " + getClass().getName() + "(\n\t" + 
					today             + ",\n\t" + 
					normal            + ",\n\t" + 
					record   + ")\n");
	}
}
