/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ZooContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import javax.swing.JComponent;

public class ZooGroup
extends ZooContainer {
    protected Dimension oldSize = null;
    protected AffineTransform transform = new AffineTransform();

    public ZooGroup(Vector v) {
        this.setOpaque(false);
        Component[] c = v.toArray(new Component[0]);
        Rectangle bounds = this.getBoundingBox(c);
        if (bounds != null) {
            super.setBounds(bounds);
        }
        int i = 0;
        while (i < c.length) {
            c[i].setLocation(c[i].getX() - this.getX(), c[i].getY() - this.getY());
            this.add(c[i]);
            ++i;
        }
    }

    public void setLocation(int x, int y) {
        this.setBoundsImpl(x, y, this.getWidth(), this.getHeight());
    }

    public void setLocation(Point p) {
        this.setBoundsImpl(p.x, p.y, this.getWidth(), this.getHeight());
    }

    public void setSize(int width, int height) {
        this.setBoundsImpl(this.getX(), this.getY(), width, height);
    }

    public void setSize(Dimension size) {
        this.setBoundsImpl(this.getX(), this.getY(), size.width, size.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBoundsImpl(x, y, width, height);
    }

    public void setBounds(Rectangle bounds) {
        this.setBoundsImpl(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void addNotify() {
        super.addNotify();
        this.updateBoundsRestrictions();
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform oldTransform = g2.getTransform();
        this.paintBorder(g);
        this.paintComponent(g);
        AffineTransform test = new AffineTransform(oldTransform);
        test.concatenate(new AffineTransform(this.transform));
        g2.setTransform(test);
        this.paintChildren(g);
        g2.setTransform(oldTransform);
    }

    protected Dimension calculateMinimumSize() {
        Component c = this.getComponent(0);
        Dimension min = c.getMinimumSize();
        double dx = 0.0;
        double dy = 0.0;
        dx = c.getWidth() == 0 ? Double.MAX_VALUE : (double)min.width / (double)c.getWidth();
        dy = c.getHeight() == 0 ? Double.MAX_VALUE : (double)min.height / (double)c.getHeight();
        int i = 1;
        while (i < this.getComponentCount()) {
            c = this.getComponent(i);
            min = c.getMinimumSize();
            dx = c.getWidth() == 0 ? Double.MAX_VALUE : Math.max((double)min.width / (double)c.getWidth(), dx);
            dy = c.getHeight() == 0 ? Double.MAX_VALUE : Math.max((double)min.height / (double)c.getHeight(), dy);
            ++i;
        }
        double width = dx * (double)this.getWidth();
        double height = dy * (double)this.getHeight();
        return new Dimension(width > 2.147483647E9 ? Integer.MAX_VALUE : (int)(width + 1.0), height > 2.147483647E9 ? Integer.MAX_VALUE : (int)(height + 1.0));
    }

    protected Dimension calculateMaximumSize() {
        Component c = this.getComponent(0);
        Dimension max = c.getMaximumSize();
        double dx = 0.0;
        double dy = 0.0;
        dx = c.getWidth() == 0 ? Double.MAX_VALUE : (double)max.width / (double)c.getWidth();
        dy = c.getHeight() == 0 ? Double.MAX_VALUE : (double)max.height / (double)c.getHeight();
        int i = 1;
        while (i < this.getComponentCount()) {
            c = this.getComponent(i);
            max = c.getMaximumSize();
            dx = c.getWidth() == 0 ? dx : Math.min((double)max.width / (double)c.getWidth(), dx);
            dy = c.getHeight() == 0 ? dy : Math.min((double)max.height / (double)c.getHeight(), dy);
            ++i;
        }
        double width = dx * (double)this.getWidth();
        double height = dy * (double)this.getHeight();
        return new Dimension(width > 2.147483647E9 ? Integer.MAX_VALUE : (int)width, height > 2.147483647E9 ? Integer.MAX_VALUE : (int)height);
    }

    void startResize() {
        this.oldSize = this.getSize();
    }

    void endResize() {
        this.transform = new AffineTransform();
        Rectangle bounds = this.getBounds();
        double dx = (double)bounds.width / (double)this.oldSize.width;
        double dy = (double)bounds.height / (double)this.oldSize.height;
        Component[] child = this.getComponents();
        int i = 0;
        while (i < child.length) {
            bounds = child[i].getBounds();
            child[i].setBounds((int)((double)bounds.x * dx + 0.5), (int)((double)bounds.y * dy + 0.5), (int)((double)bounds.width * dx + 0.5), (int)((double)bounds.height * dy + 0.5));
            this.revalidate(child[i]);
            ++i;
        }
        this.oldSize = null;
        this.updateBoundsRestrictions();
    }

    private void updateBoundsRestrictions() {
        if (this.getComponentCount() > 0) {
            this.setMinimumSize(this.calculateMinimumSize());
            this.setMaximumSize(this.calculateMaximumSize());
        }
    }

    private void setBoundsImpl(int x, int y, int width, int height) {
        if (this.oldSize != null) {
            this.transform = AffineTransform.getScaleInstance((double)width / (double)this.oldSize.width, (double)height / (double)this.oldSize.height);
        } else {
            Rectangle bounds = this.getBounds();
            double dx = (double)width / (double)bounds.width;
            double dy = (double)height / (double)bounds.height;
            Component[] child = this.getComponents();
            int i = 0;
            while (i < child.length) {
                bounds = child[i].getBounds();
                child[i].setBounds((int)((double)bounds.x * dx + 0.5), (int)((double)bounds.y * dy + 0.5), (int)((double)bounds.width * dx + 0.5), (int)((double)bounds.height * dy + 0.5));
                this.revalidate(child[i]);
                ++i;
            }
        }
        super.setBounds(x, y, width, height);
    }

    private Rectangle getBoundingBox(Component[] c) {
        if (c == null || c.length == 0) {
            return null;
        }
        Rectangle bounds = new Rectangle(c[0].getBounds());
        int i = 1;
        while (i < c.length) {
            bounds = bounds.union(c[i].getBounds());
            ++i;
        }
        return bounds;
    }

    private void revalidate(Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.revalidate();
            return;
        }
        if (c instanceof Container) {
            Container co = (Container)c;
            co.validate();
            return;
        }
    }
}

