/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Displayable;
import java.awt.Component;
import javax.swing.JScrollPane;

public class ScrollableDisplay
extends JScrollPane
implements Displayable {
    public static final String DISPLAY = "display";

    public ScrollableDisplay() {
        this(new DisplayPanel());
    }

    public ScrollableDisplay(Displayable d) {
        this.setDisplay(d);
    }

    public void setViewState(String data) {
        this.getDisplay().setViewState(data);
        this.firePropertyChange("view.state", null, data);
    }

    public String getViewState() {
        return this.getDisplay().getViewState();
    }

    public void setDefaultViewState(String data) {
        this.getDisplay().setDefaultViewState(data);
        this.firePropertyChange("default.view.state", null, data);
    }

    public String getDefaultViewState() {
        return this.getDisplay().getDefaultViewState();
    }

    public void setEnabled(boolean isEnabled) {
        this.getDisplay().setEnabled(isEnabled);
        super.setEnabled(isEnabled);
    }

    public void reset() {
        this.getDisplay().reset();
    }

    public void setDisplay(Displayable d) {
        if (d == null) {
            return;
        }
        Displayable oldDisplay = this.getDisplay();
        this.setViewportView((Component)((Object)d));
        this.validateTree();
        if (d != oldDisplay) {
            this.firePropertyChange(DISPLAY, oldDisplay, this.getDisplay());
        }
    }

    public Displayable getDisplay() {
        return (Displayable)((Object)this.getViewport().getView());
    }
}

