/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Interval;
import edu.neu.ccs.gui.PlotMark;
import edu.neu.ccs.gui.Transform1D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class PlotTool
implements Cloneable,
Serializable {
    private static final int DEFAULT_WINDOW_SIZE = 400;
    private static final boolean DEFAULT_EQUALIZE = false;
    private static final int DEFAULT_INSET = 0;
    private static final int DEFAULT_AXES_SIZE = 3;
    private static final int MINIMUM_GRID_PIXELS = 20;
    private static final int MINIMUM_TICK_PIXELS = 8;
    private static final int DEFAULT_TICK_SIZE = 5;
    private static final Color DEFAULT_PLOT_COLOR = Color.black;
    private static final Color DEFAULT_AXES_COLOR = Color.black;
    private static final Color DEFAULT_GRID_COLOR = Color.gray;
    private static final Color DEFAULT_TICK_COLOR = Color.red;
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    protected Rectangle2D.Double worldBounds = null;
    protected Rectangle2D.Double imageBounds = null;
    protected boolean preservesShape = false;
    protected int inset = 0;
    protected AffineTransform mapping = new AffineTransform();
    protected Transform1D xMapping = new Transform1D();
    protected Transform1D yMapping = new Transform1D();
    protected AffineTransform inverseMapping = new AffineTransform();
    protected Transform1D inverseXMapping = new Transform1D();
    protected Transform1D inverseYMapping = new Transform1D();
    protected Interval worldXRange = new Interval();
    protected Interval worldYRange = new Interval();
    protected Interval imageXRange = new Interval();
    protected Interval imageYRange = new Interval();
    protected Point2D.Double scale = new Point2D.Double();
    protected transient Point2D.Double P = new Point2D.Double();
    protected transient Point2D.Double Q = new Point2D.Double();
    protected transient Line2D.Double L = new Line2D.Double();

    public PlotTool() {
        this.setPlotTool(null, null, false, 0);
    }

    public PlotTool(Rectangle2D w, Rectangle2D i) {
        this.setPlotTool(w, i, false, 0);
    }

    public PlotTool(Rectangle2D w, Rectangle2D i, boolean eq) {
        this.setPlotTool(w, i, eq, 0);
    }

    public PlotTool(Rectangle2D w, Rectangle2D i, boolean eq, int in) {
        this.setPlotTool(w, i, eq, in);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.P = new Point2D.Double();
        this.Q = new Point2D.Double();
        this.L = new Line2D.Double();
    }

    public PlotTool setPlotTool(PlotTool other) {
        if (other != null) {
            return this.setPlotTool(other.worldBounds, other.imageBounds, other.preservesShape, other.inset);
        }
        return this;
    }

    public PlotTool setPlotTool(Rectangle2D w, Rectangle2D i, boolean eq, int in) {
        this.storeWorldBounds(w);
        this.storeImageBounds(i);
        this.storePreservesShape(eq);
        this.storeInset(in);
        return this.setTransforms();
    }

    public PlotTool setWorldBounds(Rectangle2D w) {
        this.storeWorldBounds(w);
        return this.setTransforms();
    }

    public Rectangle2D getWorldBounds() {
        return (Rectangle2D)this.worldBounds.clone();
    }

    public PlotTool setWorldBounds(Point2D[] data) {
        return this.setWorldBounds(PlotTool.makeBoundsRectangle2D(data));
    }

    public PlotTool setWorldBounds(Point2D[][] data) {
        return this.setWorldBounds(PlotTool.makeBoundsRectangle2D(data));
    }

    public static Rectangle2D makeBoundsRectangle2D(Point2D[] data) {
        Rectangle2D R = null;
        boolean first = true;
        if (data != null) {
            int size = data.length;
            int i = 0;
            while (i < size) {
                if (data[i] != null) {
                    double x = data[i].getX();
                    double y = data[i].getY();
                    if (first) {
                        R = new Rectangle2D.Double(x, y, 0.0, 0.0);
                        first = false;
                    } else {
                        R.add(x, y);
                    }
                }
                ++i;
            }
        }
        return R;
    }

    public static Rectangle2D makeBoundsRectangle2D(Point2D[][] data) {
        Rectangle2D R = null;
        boolean first = true;
        if (data != null) {
            int size = data.length;
            int i = 0;
            while (i < size) {
                if (data[i] != null) {
                    int innersize = data[i].length;
                    int j = 0;
                    while (j < innersize) {
                        if (data[i][j] != null) {
                            double x = data[i][j].getX();
                            double y = data[i][j].getY();
                            if (first) {
                                R = new Rectangle2D.Double(x, y, 0.0, 0.0);
                                first = false;
                            } else {
                                R.add(x, y);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return R;
    }

    public PlotTool setImageBounds(Rectangle2D i) {
        this.storeImageBounds(i);
        return this.setTransforms();
    }

    public Rectangle2D getImageBounds() {
        return (Rectangle2D)this.imageBounds.clone();
    }

    public PlotTool setPreservesShape(boolean eq) {
        this.storePreservesShape(eq);
        return this.setTransforms();
    }

    public boolean preservesShape() {
        return this.preservesShape;
    }

    public PlotTool setInset(int in) {
        this.storeInset(in);
        return this.setTransforms();
    }

    public int getInset() {
        return this.inset;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.mapping);
    }

    public Transform1D getXTransform() {
        return new Transform1D(this.xMapping.getFactor(), this.xMapping.getOffset());
    }

    public Transform1D getYTransform() {
        return new Transform1D(this.yMapping.getFactor(), this.yMapping.getOffset());
    }

    public AffineTransform getInverseTransform() {
        return new AffineTransform(this.inverseMapping);
    }

    public Transform1D getInverseXTransform() {
        return new Transform1D(this.inverseXMapping.getFactor(), this.inverseXMapping.getOffset());
    }

    public Transform1D getInverseYTransform() {
        return new Transform1D(this.inverseYMapping.getFactor(), this.inverseYMapping.getOffset());
    }

    public Point2D scale(Point2D source, Point2D target) {
        return this.mapping.transform(source, target);
    }

    public Point2D scale(Point2D source) {
        return this.scale(source, null);
    }

    public double xScale(double x) {
        return this.xMapping.transform(x);
    }

    public double yScale(double y) {
        return this.yMapping.transform(y);
    }

    public Point2D inverseScale(Point2D source, Point2D target) {
        return this.inverseMapping.transform(source, target);
    }

    public Point2D inverseScale(Point2D source) {
        return this.inverseScale(source, null);
    }

    public double inverseXScale(double x) {
        return this.inverseXMapping.transform(x);
    }

    public double inverseYScale(double y) {
        return this.inverseYMapping.transform(y);
    }

    public void plotData(Graphics2D g, Point2D[] data, Paint color) {
        this.plotData(g, data, color, (Stroke)DEFAULT_STROKE);
    }

    public void plotData(Graphics2D g, Point2D[] data, Paint color, Stroke s) {
        if (g == null || data == null) {
            return;
        }
        if (color != null) {
            g.setPaint(color);
        } else {
            g.setPaint(DEFAULT_PLOT_COLOR);
        }
        if (s != null) {
            g.setStroke(s);
        } else {
            g.setStroke(DEFAULT_STROKE);
        }
        int size = data.length;
        boolean first = true;
        int i = 0;
        while (i < size) {
            if (data[i] != null) {
                if (first) {
                    this.scale(data[i], this.P);
                    first = false;
                } else {
                    this.scale(data[i], this.Q);
                    this.L.setLine(this.P, this.Q);
                    g.draw(this.L);
                    this.P.setLocation(this.Q);
                }
            }
            ++i;
        }
    }

    public void plotData(Graphics2D g, Point2D[][] data, Paint color) {
        this.plotData(g, data, color, (Stroke)DEFAULT_STROKE);
    }

    public void plotData(Graphics2D g, Point2D[][] data, Paint color, Stroke s) {
        if (g == null || data == null) {
            return;
        }
        int size = data.length;
        int i = 0;
        while (i < size) {
            this.plotData(g, data[i], color, s);
            ++i;
        }
    }

    public void plotData(Graphics2D g, Point2D[][] data, Paint[] color) {
        this.plotData(g, data, color, (Stroke)DEFAULT_STROKE);
    }

    public void plotData(Graphics2D g, Point2D[][] data, Paint[] color, Stroke s) {
        if (g == null || data == null) {
            return;
        }
        if (color == null) {
            color = new Paint[]{DEFAULT_PLOT_COLOR};
        }
        int size = data.length;
        int colorsize = color.length;
        int i = 0;
        while (i < size) {
            int j = i % colorsize;
            this.plotData(g, data[i], color[j], s);
            ++i;
        }
    }

    public void markData(Graphics2D g, Point2D[] data, Paint color, PlotMark m) {
        if (g == null || data == null || m == null) {
            return;
        }
        if (color != null) {
            g.setPaint(color);
        } else {
            g.setPaint(DEFAULT_PLOT_COLOR);
        }
        g.setStroke(DEFAULT_STROKE);
        int size = data.length;
        int i = 0;
        while (i < size) {
            if (data[i] != null) {
                this.scale(data[i], this.P);
                m.mark(g, this.P);
            }
            ++i;
        }
    }

    public void markData(Graphics2D g, Point2D[][] data, Paint color, PlotMark m) {
        if (g == null || data == null || m == null) {
            return;
        }
        int size = data.length;
        int i = 0;
        while (i < size) {
            this.markData(g, data[i], color, m);
            ++i;
        }
    }

    public void markData(Graphics2D g, Point2D[][] data, Paint[] color, PlotMark m) {
        if (g == null || data == null || m == null) {
            return;
        }
        if (color == null) {
            color = new Paint[]{DEFAULT_PLOT_COLOR};
        }
        int size = data.length;
        int colorsize = color.length;
        int i = 0;
        while (i < size) {
            int j = i % colorsize;
            this.markData(g, data[i], color[j], m);
            ++i;
        }
    }

    public void plotVGridLine(Graphics2D g, double xPosition) {
        if (g == null) {
            return;
        }
        double x = this.xScale(xPosition);
        this.L.setLine(x, this.imageYRange.getMinimum(), x, this.imageYRange.getMaximum());
        g.draw(this.L);
    }

    public void plotHGridLine(Graphics2D g, double yPosition) {
        if (g == null) {
            return;
        }
        double y = this.yScale(yPosition);
        this.L.setLine(this.imageXRange.getMinimum(), y, this.imageXRange.getMaximum(), y);
        g.draw(this.L);
    }

    public void plotVTickMark(Graphics2D g, double xPosition, int ticksize) {
        if (g == null) {
            return;
        }
        double x = this.xScale(xPosition);
        double y = this.yScale(0.0);
        this.L.setLine(x, y - (double)ticksize, x, y + (double)ticksize);
        g.draw(this.L);
    }

    public void plotHTickMark(Graphics2D g, double yPosition, int ticksize) {
        if (g == null) {
            return;
        }
        double x = this.xScale(0.0);
        double y = this.yScale(yPosition);
        this.L.setLine(x - (double)ticksize, y, x + (double)ticksize, y);
        g.draw(this.L);
    }

    public int xMinIndex(double delta) {
        if (this.scale.x == 0.0 || delta <= 0.0) {
            return 0;
        }
        double limit = this.inverseXScale(this.imageXRange.getMinimum());
        return (int)Math.floor(limit / delta);
    }

    public int yMinIndex(double delta) {
        if (this.scale.y == 0.0 || delta <= 0.0) {
            return 0;
        }
        double limit = this.inverseYScale(this.imageYRange.getMaximum());
        return (int)Math.floor(limit / delta);
    }

    public int xMaxIndex(double delta) {
        if (this.scale.x == 0.0 || delta <= 0.0) {
            return 0;
        }
        double limit = this.inverseXScale(this.imageXRange.getMaximum());
        return (int)Math.ceil(limit / delta);
    }

    public int yMaxIndex(double delta) {
        if (this.scale.y == 0.0 || delta <= 0.0) {
            return 0;
        }
        double limit = this.inverseYScale(this.imageYRange.getMinimum());
        return (int)Math.ceil(limit / delta);
    }

    public PlotTool plotVGridLines(Graphics2D g, Paint color, double delta) {
        if (g == null || this.scale.x == 0.0 || delta == 0.0) {
            return this;
        }
        if (color != null) {
            g.setPaint(color);
        } else {
            g.setPaint(DEFAULT_GRID_COLOR);
        }
        g.setStroke(DEFAULT_STROKE);
        delta = Math.abs(delta);
        int min = this.xMinIndex(delta);
        int max = this.xMaxIndex(delta);
        int k = min;
        while (k <= max) {
            this.plotVGridLine(g, (double)k * delta);
            ++k;
        }
        return this;
    }

    public PlotTool plotHGridLines(Graphics2D g, Paint color, double delta) {
        if (g == null || this.scale.y == 0.0 || delta == 0.0) {
            return this;
        }
        if (color != null) {
            g.setPaint(color);
        } else {
            g.setPaint(DEFAULT_GRID_COLOR);
        }
        g.setStroke(DEFAULT_STROKE);
        delta = Math.abs(delta);
        int min = this.yMinIndex(delta);
        int max = this.yMaxIndex(delta);
        int k = min;
        while (k <= max) {
            this.plotHGridLine(g, (double)k * delta);
            ++k;
        }
        return this;
    }

    public PlotTool plotGridLines(Graphics2D g, Paint color, Point2D delta) {
        if (g == null || delta == null) {
            return this;
        }
        this.plotVGridLines(g, color, delta.getX());
        this.plotHGridLines(g, color, delta.getY());
        return this;
    }

    public PlotTool plotVTickMarks(Graphics2D g, Paint color, double delta, int ticksize) {
        if (g == null || this.scale.x == 0.0 || delta == 0.0) {
            return this;
        }
        if (color != null) {
            g.setPaint(color);
        } else {
            g.setPaint(DEFAULT_TICK_COLOR);
        }
        g.setStroke(DEFAULT_STROKE);
        delta = Math.abs(delta);
        int min = this.xMinIndex(delta);
        int max = this.xMaxIndex(delta);
        int k = min;
        while (k <= max) {
            this.plotVTickMark(g, (double)k * delta, ticksize);
            ++k;
        }
        return this;
    }

    public PlotTool plotHTickMarks(Graphics2D g, Paint color, double delta, int ticksize) {
        if (g == null || this.scale.y == 0.0 || delta == 0.0) {
            return this;
        }
        if (color != null) {
            g.setPaint(color);
        } else {
            g.setPaint(DEFAULT_TICK_COLOR);
        }
        g.setStroke(DEFAULT_STROKE);
        delta = Math.abs(delta);
        int min = this.yMinIndex(delta);
        int max = this.yMaxIndex(delta);
        int k = min;
        while (k <= max) {
            this.plotHTickMark(g, (double)k * delta, ticksize);
            ++k;
        }
        return this;
    }

    public PlotTool plotTickMarks(Graphics2D g, Paint color, Point2D delta, int ticksize) {
        if (g == null || delta == null) {
            return this;
        }
        this.plotVTickMarks(g, color, delta.getX(), ticksize);
        this.plotHTickMarks(g, color, delta.getY(), ticksize);
        return this;
    }

    public static double findSpacing(double minimumDelta) {
        if (minimumDelta == 0.0) {
            return 0.0;
        }
        minimumDelta = Math.abs(minimumDelta);
        double below = 1.0;
        double above = 10.0;
        while (above < minimumDelta) {
            below = above;
            above *= 10.0;
        }
        while (below >= minimumDelta) {
            above = below;
            below /= 10.0;
        }
        if (2.0 * below >= minimumDelta) {
            return 2.0 * below;
        }
        if (5.0 * below >= minimumDelta) {
            return 5.0 * below;
        }
        return above;
    }

    public Point2D autoSpacing(int minPixel) {
        minPixel = Math.abs(minPixel);
        Point2D.Double delta = new Point2D.Double();
        delta.x = this.scale.x > 0.0 ? (double)minPixel / this.scale.x : 0.0;
        delta.y = this.scale.y > 0.0 ? (double)minPixel / this.scale.y : 0.0;
        delta.x = PlotTool.findSpacing(delta.x);
        delta.y = PlotTool.findSpacing(delta.y);
        if (this.preservesShape && delta.x != 0.0 && delta.y != 0.0) {
            if (delta.x < delta.y) {
                delta.x = delta.y;
            } else {
                delta.y = delta.x;
            }
        }
        return delta;
    }

    public PlotTool autoGridLines(Graphics2D g) {
        return this.plotGridLines(g, DEFAULT_GRID_COLOR, this.autoSpacing(20));
    }

    public PlotTool autoTickMarks(Graphics2D g) {
        return this.plotTickMarks(g, DEFAULT_TICK_COLOR, this.autoSpacing(8), 5);
    }

    public PlotTool plotAxes(Graphics2D g, Paint color, int thick) {
        if (g == null) {
            return this;
        }
        if (color != null) {
            g.setPaint(color);
        } else {
            g.setPaint(DEFAULT_AXES_COLOR);
        }
        g.setStroke(new BasicStroke(Math.abs(thick)));
        this.plotVGridLine(g, 0.0);
        this.plotHGridLine(g, 0.0);
        g.setStroke(DEFAULT_STROKE);
        return this;
    }

    public PlotTool autoAxes(Graphics2D g) {
        return this.plotAxes(g, DEFAULT_AXES_COLOR, 3);
    }

    protected void storeWorldBounds(Rectangle2D w) {
        this.worldBounds = w != null ? new Rectangle2D.Double(w.getX(), w.getY(), w.getWidth(), w.getHeight()) : new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    }

    public void storeImageBounds(Rectangle2D i) {
        this.imageBounds = i != null ? new Rectangle2D.Double(i.getX(), i.getY(), i.getWidth(), i.getHeight()) : new Rectangle2D.Double(0.0, 0.0, 400.0, 400.0);
    }

    protected void storePreservesShape(boolean ps) {
        this.preservesShape = ps;
    }

    protected void storeInset(int in) {
        this.inset = in > 0 ? in : 0;
    }

    protected PlotTool setTransforms() {
        this.worldXRange.setEndpoints(this.worldBounds.x, this.worldBounds.x + this.worldBounds.width);
        this.worldYRange.setEndpoints(this.worldBounds.y, this.worldBounds.y + this.worldBounds.height);
        this.imageXRange.setEndpoints(this.imageBounds.x, this.imageBounds.x + this.imageBounds.width);
        this.imageYRange.setEndpoints(this.imageBounds.y, this.imageBounds.y + this.imageBounds.height);
        this.scale.x = 0.0;
        this.scale.y = 0.0;
        double image_range = 0.0;
        if (this.worldXRange.getSize() != 0.0 && (image_range = this.imageXRange.getSize() - (double)(2 * this.inset)) > 0.0) {
            this.scale.x = image_range / this.worldXRange.getSize();
        }
        if (this.worldYRange.getSize() != 0.0 && (image_range = this.imageYRange.getSize() - (double)(2 * this.inset)) > 0.0) {
            this.scale.y = image_range / this.worldYRange.getSize();
        }
        if (this.preservesShape && this.scale.x != 0.0 && this.scale.y != 0.0) {
            if (this.scale.x > this.scale.y) {
                this.scale.x = this.scale.y;
            } else {
                this.scale.y = this.scale.x;
            }
        }
        double m00 = this.scale.x;
        double m10 = 0.0;
        double m01 = 0.0;
        double m11 = -this.scale.y;
        double m02 = this.imageXRange.getMidpoint() - m00 * this.worldXRange.getMidpoint();
        double m12 = this.imageYRange.getMidpoint() - m11 * this.worldYRange.getMidpoint();
        this.mapping.setTransform(m00, m10, m01, m11, m02, m12);
        this.xMapping.setTransform(m00, m02);
        this.yMapping.setTransform(m11, m12);
        if (m00 != 0.0) {
            m00 = 1.0 / m00;
        }
        if (m11 != 0.0) {
            m11 = 1.0 / m11;
        }
        m02 = this.worldXRange.getMidpoint() - m00 * this.imageXRange.getMidpoint();
        m12 = this.worldYRange.getMidpoint() - m11 * this.imageYRange.getMidpoint();
        this.inverseMapping.setTransform(m00, m10, m01, m11, m02, m12);
        this.inverseXMapping.setTransform(m00, m02);
        this.inverseYMapping.setTransform(m11, m12);
        return this;
    }
}

