/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class PlotMark
implements Cloneable,
Serializable {
    public static final int V_BAR = 1;
    public static final int H_BAR = 2;
    public static final int PLUS = 3;
    public static final int CROSS = 4;
    public static final int ASTERISK = 5;
    public static final int SQUARE = 11;
    public static final int CIRCLE = 12;
    public static final int DIAMOND = 13;
    public static final int WEDGE_N = 21;
    public static final int WEDGE_E = 22;
    public static final int WEDGE_S = 23;
    public static final int WEDGE_W = 24;
    public static final int FILLED = 100;
    public static final int FILLED_SQUARE = 111;
    public static final int FILLED_CIRCLE = 112;
    public static final int FILLED_DIAMOND = 113;
    public static final int FILLED_WEDGE_N = 121;
    public static final int FILLED_WEDGE_E = 122;
    public static final int FILLED_WEDGE_S = 123;
    public static final int FILLED_WEDGE_W = 124;
    private static final int DEFAULT_MARK_VALUE = 111;
    private static final int MARK_SIZE = 3;
    protected int markValue = 111;
    protected int markSize = 3;
    protected Graphics2D G = null;
    protected Point2D.Double P = null;
    protected transient Stroke currentStroke = null;
    protected transient Line2D.Double line = new Line2D.Double();
    protected transient Rectangle2D.Double square = new Rectangle2D.Double();
    protected transient Ellipse2D.Double circle = new Ellipse2D.Double();
    protected transient GeneralPath shape = new GeneralPath();
    protected transient BasicStroke stroke = new BasicStroke(1.0f);

    public PlotMark() {
    }

    public PlotMark(int value) {
        this.setMarkValue(value);
    }

    public PlotMark(int value, int size) {
        this.setMarkValue(value);
        this.setMarkSize(size);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.line = new Line2D.Double();
        this.square = new Rectangle2D.Double();
        this.circle = new Ellipse2D.Double();
        this.shape = new GeneralPath();
        this.stroke = new BasicStroke(1.0f);
    }

    public PlotMark setMarkValue(int value) {
        switch (value) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 111: 
            case 112: 
            case 113: 
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                this.markValue = value;
                break;
            }
            default: {
                this.markValue = 111;
            }
        }
        return this;
    }

    public PlotMark setMarkSize(int size) {
        if (size < 1) {
            size = 1;
        }
        this.markSize = size;
        return this;
    }

    public int getMarkValue() {
        return this.markValue;
    }

    public int getMarkSize() {
        return this.markSize;
    }

    public void mark(Graphics2D g, Point2D.Double p) {
        this.setup(g, p);
        switch (this.markValue) {
            case 1: {
                this.vBarMark();
                break;
            }
            case 2: {
                this.hBarMark();
                break;
            }
            case 3: {
                this.vBarMark();
                this.hBarMark();
                break;
            }
            case 4: {
                this.diagonalMark1();
                this.diagonalMark2();
                break;
            }
            case 5: {
                this.vBarMark();
                this.hBarMark();
                this.diagonalMark1();
                this.diagonalMark2();
                break;
            }
            case 11: {
                this.squareMark(false);
                break;
            }
            case 12: {
                this.circleMark(false);
                break;
            }
            case 13: {
                this.diamondMark(false);
                break;
            }
            case 21: {
                this.wedgeMarkN(false);
                break;
            }
            case 22: {
                this.wedgeMarkE(false);
                break;
            }
            case 23: {
                this.wedgeMarkS(false);
                break;
            }
            case 24: {
                this.wedgeMarkW(false);
                break;
            }
            case 111: {
                this.squareMark(true);
                break;
            }
            case 112: {
                this.circleMark(true);
                break;
            }
            case 113: {
                this.diamondMark(true);
                break;
            }
            case 121: {
                this.wedgeMarkN(true);
                break;
            }
            case 122: {
                this.wedgeMarkE(true);
                break;
            }
            case 123: {
                this.wedgeMarkS(true);
                break;
            }
            case 124: {
                this.wedgeMarkW(true);
                break;
            }
        }
        this.resetState();
    }

    private void setup(Graphics2D g, Point2D.Double p) {
        this.G = g;
        this.P = p;
        this.currentStroke = this.G.getStroke();
        this.G.setStroke(this.stroke);
    }

    private void resetState() {
        this.G.setStroke(this.currentStroke);
    }

    private void fillOrDraw(Shape s, boolean doFill) {
        if (doFill) {
            this.G.fill(s);
        } else {
            this.G.draw(s);
        }
    }

    private void vBarMark() {
        this.line.setLine(this.P.x, this.P.y - (double)this.markSize, this.P.x, this.P.y + (double)this.markSize);
        this.G.draw(this.line);
    }

    private void hBarMark() {
        this.line.setLine(this.P.x - (double)this.markSize, this.P.y, this.P.x + (double)this.markSize, this.P.y);
        this.G.draw(this.line);
    }

    private void diagonalMark1() {
        this.line.setLine(this.P.x - (double)this.markSize, this.P.y - (double)this.markSize, this.P.x + (double)this.markSize, this.P.y + (double)this.markSize);
        this.G.draw(this.line);
    }

    private void diagonalMark2() {
        this.line.setLine(this.P.x - (double)this.markSize, this.P.y + (double)this.markSize, this.P.x + (double)this.markSize, this.P.y - (double)this.markSize);
        this.G.draw(this.line);
    }

    private void squareMark(boolean doFill) {
        this.square.setRect(this.P.x - (double)this.markSize, this.P.y - (double)this.markSize, 2 * this.markSize, 2 * this.markSize);
        this.fillOrDraw(this.square, doFill);
    }

    private void circleMark(boolean doFill) {
        this.circle.setFrame(this.P.x - (double)this.markSize, this.P.y - (double)this.markSize, 2 * this.markSize, 2 * this.markSize);
        this.fillOrDraw(this.circle, doFill);
    }

    private void diamondMark(boolean doFill) {
        this.shape.reset();
        this.shape.moveTo((float)this.P.x, (float)(this.P.y - (double)this.markSize));
        this.shape.lineTo((float)(this.P.x + (double)this.markSize), (float)this.P.y);
        this.shape.lineTo((float)this.P.x, (float)(this.P.y + (double)this.markSize));
        this.shape.lineTo((float)(this.P.x - (double)this.markSize), (float)this.P.y);
        this.shape.closePath();
        this.fillOrDraw(this.shape, doFill);
    }

    private void wedgeMarkN(boolean doFill) {
        int offset = 2 * this.markSize;
        this.shape.reset();
        this.shape.moveTo((float)this.P.x, (float)this.P.y);
        this.shape.lineTo((float)(this.P.x + (double)this.markSize), (float)(this.P.y + (double)offset));
        this.shape.lineTo((float)(this.P.x - (double)this.markSize), (float)(this.P.y + (double)offset));
        this.shape.closePath();
        this.fillOrDraw(this.shape, doFill);
    }

    private void wedgeMarkE(boolean doFill) {
        int offset = 2 * this.markSize;
        this.shape.reset();
        this.shape.moveTo((float)this.P.x, (float)this.P.y);
        this.shape.lineTo((float)(this.P.x - (double)offset), (float)(this.P.y + (double)this.markSize));
        this.shape.lineTo((float)(this.P.x - (double)offset), (float)(this.P.y - (double)this.markSize));
        this.shape.closePath();
        this.fillOrDraw(this.shape, doFill);
    }

    private void wedgeMarkS(boolean doFill) {
        int offset = 2 * this.markSize;
        this.shape.reset();
        this.shape.moveTo((float)this.P.x, (float)this.P.y);
        this.shape.lineTo((float)(this.P.x - (double)this.markSize), (float)(this.P.y - (double)offset));
        this.shape.lineTo((float)(this.P.x + (double)this.markSize), (float)(this.P.y - (double)offset));
        this.shape.closePath();
        this.fillOrDraw(this.shape, doFill);
    }

    private void wedgeMarkW(boolean doFill) {
        int offset = 2 * this.markSize;
        this.shape.reset();
        this.shape.moveTo((float)this.P.x, (float)this.P.y);
        this.shape.lineTo((float)(this.P.x + (double)offset), (float)(this.P.y - (double)this.markSize));
        this.shape.lineTo((float)(this.P.x + (double)offset), (float)(this.P.y + (double)this.markSize));
        this.shape.closePath();
        this.fillOrDraw(this.shape, doFill);
    }
}

