/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ComponentWrapper;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.KeyActionAdapter;
import edu.neu.ccs.gui.MouseActionAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class BufferedPanel
extends DisplayPanel {
    public static final Color DEFAULT_BUFFER_BACKGROUND = Color.white;
    protected BufferedImage buffer = null;
    protected ComponentWrapper wrapper = null;
    protected Painter painter = null;
    protected Paint bufferBackground = DEFAULT_BUFFER_BACKGROUND;
    protected MouseActionAdapter mouseActions = null;
    protected KeyActionAdapter keyActions = null;

    public BufferedPanel(int width, int height) {
        this(width, height, DEFAULT_BUFFER_BACKGROUND);
    }

    public BufferedPanel(int width, int height, Paint background) {
        super(new BorderLayout());
        this.setBufferBackground(background);
        this.setBufferSize(width, height);
        this.painter = new Painter(this);
        this.wrapper = new ComponentWrapper(this.painter);
        this.wrapper.setAbsoluteSize(this.getBufferWidth(), this.getBufferHeight());
        this.add((Component)this.wrapper, "Center");
        this.mouseActions = new MouseActionAdapter(this.painter);
        this.keyActions = new KeyActionAdapter(this.painter);
    }

    public Graphics2D getBufferGraphics() {
        return this.buffer.createGraphics();
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    public DisplayPanel getInnerPanel() {
        return this.painter;
    }

    public void setBufferBackground(Paint background) {
        if (background == null) {
            return;
        }
        this.bufferBackground = background;
    }

    public Paint getBufferBackground() {
        return this.bufferBackground;
    }

    public void clearPanel() {
        this.fillPanel(this.getBufferBackground());
    }

    public void fillPanel(Paint fill) {
        Graphics2D g2 = this.getBufferGraphics();
        g2.setPaint(fill);
        g2.fillRect(0, 0, this.getBufferWidth(), this.getBufferHeight());
    }

    public void setBackground(Color background) {
        if (this.wrapper != null) {
            this.wrapper.setBackground(background);
        }
        super.setBackground(background);
    }

    public synchronized void setBufferSize(Dimension size) {
        if (size == null) {
            return;
        }
        this.setBufferSize(size.width, size.height);
    }

    public synchronized void setBufferSize(int width, int height) {
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        BufferedImage oldBuffer = this.buffer;
        this.buffer = new BufferedImage(width, height, 1);
        this.clearPanel();
        if (oldBuffer != null) {
            Graphics2D g2 = this.getBufferGraphics();
            g2.drawImage((Image)oldBuffer, 0, 0, this);
        }
        if (this.wrapper != null) {
            this.wrapper.setAbsoluteSize(this.getBufferWidth(), this.getBufferHeight());
        }
    }

    public int getBufferWidth() {
        return this.buffer.getWidth();
    }

    public int getBufferHeight() {
        return this.buffer.getHeight();
    }

    public void setMouseActionAdapter(MouseActionAdapter adapter) {
        if (adapter == null) {
            return;
        }
        this.painter.removeMouseListener(this.mouseActions);
        this.painter.removeMouseMotionListener(this.mouseActions);
        this.mouseActions = adapter;
        this.painter.addMouseListener(this.mouseActions);
        this.painter.addMouseMotionListener(this.mouseActions);
    }

    public MouseActionAdapter getMouseActionAdapter() {
        return this.mouseActions;
    }

    public void setKeyActionAdapter(KeyActionAdapter adapter) {
        if (adapter == null) {
            return;
        }
        this.painter.removeKeyListener(this.keyActions);
        this.keyActions = adapter;
        this.painter.addKeyListener(this.keyActions);
    }

    public KeyActionAdapter getKeyActionAdapter() {
        return this.keyActions;
    }

    public void paintOver(Graphics2D g2) {
    }

    protected static class Painter
    extends DisplayPanel {
        protected BufferedPanel panel = null;

        protected Painter(BufferedPanel panel) {
            this.panel = panel;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.panel.getBufferWidth(), this.panel.getBufferHeight());
        }

        protected void paintComponent(Graphics g) {
            Insets in = this.getInsets();
            g.drawImage(this.panel.getBuffer(), in.left, in.top, this);
        }

        public void paint(Graphics g) {
            super.paint(g);
            Insets in = this.getInsets();
            Graphics2D g2 = (Graphics2D)g;
            g2.transform(AffineTransform.getTranslateInstance(in.left, in.top));
            this.panel.paintOver(g2);
        }
    }
}

