/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XByte;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XDouble
extends XNumber {
    private double value = 0.0;

    public XDouble() {
    }

    public XDouble(double d) {
        this.value = d;
    }

    public XDouble(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        double oldValue = this.value;
        Parser p = ParserUtilities.getDefaultParser();
        Object obj = p.parse(data);
        if (!(obj instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", data.length());
        }
        XNumber n = (XNumber)obj;
        this.value = n.doubleValue();
        this.changeAdapter.firePropertyChange("value", new Double(oldValue), data);
    }

    public String toStringData() {
        return String.valueOf(this.value);
    }

    public byte byteValue() {
        if (this.getValue() > 127.0 || this.getValue() < -128.0) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue();
    }

    public short shortValue() {
        if (this.getValue() > 32767.0 || this.getValue() < -32768.0) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue();
    }

    public int intValue() {
        if (this.getValue() > 2.147483647E9 || this.getValue() < -2.147483648E9) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return (int)this.getValue();
    }

    public long longValue() {
        if (this.getValue() > 9.223372036854776E18 || this.getValue() < -9.223372036854776E18) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return (long)this.getValue();
    }

    public float floatValue() {
        if (this.getValue() > 3.4028234663852886E38 || this.getValue() < -3.4028234663852886E38) {
            throw new NumberFormatException("Number beyond precision of a float.");
        }
        return (float)this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public boolean equals(Object other) {
        if (other instanceof XByte) {
            return this.getValue() == ((XDouble)other).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Double(this.getValue()).hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(double d) {
        double oldValue = this.value;
        this.value = d;
        if (this.getValue() != oldValue) {
            this.changeAdapter.firePropertyChange("value", new Double(oldValue), new Double(this.getValue()));
        }
    }

    public double getValue() {
        return this.value;
    }

    public static double parseDouble(String s) throws NumberFormatException {
        try {
            return new XDouble((String)s).value;
        }
        catch (ParseException e) {
            throw new NumberFormatException(XObject.formatErrorMessage(e, s));
        }
    }

    public static double[] toPrimitiveArray(XDouble[] x) {
        if (x == null) {
            return null;
        }
        double[] temp = new double[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XDouble[] toXArray(double[] a) {
        if (a == null) {
            return null;
        }
        XDouble[] temp = new XDouble[a.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = new XDouble(a[i]);
            ++i;
        }
        return temp;
    }
}

