/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XByte
extends XNumber {
    private byte value = 0;

    public XByte() {
    }

    public XByte(byte b) {
        this.value = b;
    }

    public XByte(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        byte oldValue = this.value;
        Parser p = ParserUtilities.getDefaultParser();
        Object obj = p.parse(data);
        if (!(obj instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", data.length());
        }
        XNumber n = (XNumber)obj;
        this.value = n.byteValue();
        this.changeAdapter.firePropertyChange("value", new Byte(oldValue), data);
    }

    public String toStringData() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof XByte) {
            return this.getValue() == ((XByte)other).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Byte(this.getValue()).hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(byte b) {
        byte oldValue = this.value;
        this.value = b;
        if (this.getValue() != oldValue) {
            this.changeAdapter.firePropertyChange("value", new Byte(oldValue), new Byte(this.getValue()));
        }
    }

    public byte getValue() {
        return this.value;
    }

    public byte byteValue() {
        return this.getValue();
    }

    public short shortValue() {
        return this.getValue();
    }

    public int intValue() {
        return this.getValue();
    }

    public long longValue() {
        return this.getValue();
    }

    public float floatValue() {
        return this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public static byte parseByte(String s) throws NumberFormatException {
        try {
            return new XByte((String)s).value;
        }
        catch (ParseException e) {
            throw new NumberFormatException(XObject.formatErrorMessage(e, s));
        }
    }

    public static byte[] toPrimitiveArray(XByte[] x) {
        if (x == null) {
            return null;
        }
        byte[] temp = new byte[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XByte[] toXArray(byte[] a) {
        if (a == null) {
            return null;
        }
        XByte[] temp = new XByte[a.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = new XByte(a[i]);
            ++i;
        }
        return temp;
    }
}

