/*
 * @(#)JPFalt.java  1.0  4 September 2002
 *
 * Copyright 2001,2002
 * College of Computer Science
 * Northeastern University
 * Boston, MA  02115
 *
 * This software may be used for educational purposes as long as
 * this copyright notice is retained intact at the top of all files.
 *
 * Should this software be modified, the words "Modified from 
 * Original" must be included as a comment below this notice.
 *
 * All publication rights are retained.  This software or its 
 * documentation may not be published in any media either in whole
 * or in part without explicit permission.
 *
 * Contact information:
 *   Richard Rasala    rasala@ccs.neu.edu
 *   Viera Proulx      vkp@ccs.neu.edu
 *   Jeff Raab         jmr@ccs.neu.edu
 * 
 * Telephone:          617-373-2462
 *
 * This software was created with support from Northeastern 
 * University and from NSF grant DUE-9950829.
 */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.codec.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.parser.*;
import edu.neu.ccs.pedagogy.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.util.*;
import java.text.*;
import java.math.*;
import javax.swing.*;
import java.lang.reflect.*;

/**
 * <P>This class provides the setting for creating a Java
 * application with access to the JPT console I/O and
 * simple graphics using a BufferedPanel window.</P>
 *
 * @author Viera Proulx
 * @author Richard Rasala
 * @author Jason Jay Rodrigues
 * @author Jeff Raab
 */
public class JPFalt
    implements JPTConstants, ConsoleAware
{
    /** The parent Java application. */
    protected static JPFApplicationAlt application = null;
    
    /** The graphics buffered panel window. */
    protected static BufferedPanel window = null;
    
    /** The frame title. */
    private static String frameTitle = null;
    
    /////////////////
    // Constructor //
    /////////////////
    
    /**
     * Construct the JPF application using as the given initializer the
     * derived class that uses this constructor.
     */
    public JPFalt() {
        // create an application object that references this initializer
        application = new JPFApplicationAlt(this, frameTitle);
            
        // obtain the graphics window
        window = application.getGraphicsWindow();
    }
    
    ////////////////
    // Public API //
    ////////////////
    
    public static void setFrameTitle(String title) {
        frameTitle = title;
        
        if (application != null)
            application.setFrameTitle(title);
    }
    
    
    ///////////////////////////////////////
    // Helper Methods for Console Output //
    ///////////////////////////////////////

    ///////////////////////////////////////////////////////
	// Shortcut methods for accessing the console output //
	// and printing the method actual header               //
    ///////////////////////////////////////////////////////
    
    protected void println(Object s){
    	console.out.println(s.toString());
    }
    
    protected void println(byte s){
    	console.out.println("" + s);
    }
    
    protected void println(short s){
    	console.out.println("" + s);
    }
    
    protected void println(int s){
    	console.out.println("" + s);
    }
    
    protected void println(long s){
    	console.out.println("" + s);
    }
    
    protected void println(float s){
    	console.out.println("" + s);
    }
    
    protected void println(double s){
    	console.out.println("" + s);
    }
    
    protected void println(boolean s){
    	console.out.println("" + s);
    }
    
    protected void println(char s){
    	console.out.println("" + s);
    }
    
    protected void println(){
    	console.out.println();
    }
    
    /** The header for a method test. */
    protected void testHeader(String methodName){
    	console.out.println("\nTesting the method " + methodName);
    }

	/** printing the expected results for actuals */
    protected void expected(Object s){
    	console.out.println("Expected result: " + s.toString());
    }
    
    protected void expected(byte s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(short s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(int s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(long s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(float s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(double s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(boolean s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(char s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(){
    	console.out.println("Expected result: ");
    }
    
	/** printing the test results for Tests */
    protected void actual(Object s){
    	console.out.println("Actual result:   " + s.toString());
    }
    
    protected void actual(byte s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(short s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(int s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(long s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(float s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(double s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(boolean s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(char s){
    	console.out.println("Actual result:    " + s);
    }
    
    protected void actual(){
    	console.out.println("Expected result: ");
    }
    
    protected void pressReturn(String s){
        console.pressReturn(s);
    }

    protected void pressReturn(){
        console.pressReturn();
    }
    
    protected void clearWindow(BufferedPanel window){
        window.clearPanel();
        window.repaint();
    }


}

