/*
 * @(#)ActivityIconAlt.java  1.0  5 September 2002
 *
 * Copyright 2001,2002
 * College of Computer Science
 * Northeastern University
 * Boston, MA  02115
 *
 * This software may be used for educational purposes as long as
 * this copyright notice is retained intact at the top of all files.
 *
 * Should this software be modified, the words "Modified from 
 * Original" must be included as a comment below this notice.
 *
 * All publication rights are retained.  This software or its 
 * documentation may not be published in any media either in whole
 * or in part without explicit permission.
 *
 * Contact information:
 *   Richard Rasala    rasala@ccs.neu.edu
 *   Viera Proulx      vkp@ccs.neu.edu
 *   Jeff Raab         jmr@ccs.neu.edu
 * 
 * Telephone:          617-373-2462
 *
 * This software was created with support from Northeastern 
 * University and from NSF grant DUE-9950829.
 */

import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;

/*
 * ActivityIconAlt provides JComponent's that will display
 * icons for the input, action, and output displays for
 * MethodGUI.
 *
 * @author Richard Rasala
 */
public class ActivityIconAlt {

    /** Color of input arrow. */
    public static Color inputColor  = Color.green;
    
    /** Color of action arrow. */
    public static Color actionColor = Color.yellow;
    
    /** Color of output arrow. */
    public static Color outputColor = Color.red;
    
    /** Color of the box. */
    public static Color boxColor    = Color.black;
    
    /** The line width. */
    private static int linewidth = 4;
    
    /** The arrow size. */
    private static int arrowsize = 4;
    
    /** The box size. */
    private static int boxsize = 24;
    
    /** Half of the box size. */
    private static int halfsize = boxsize / 2;
    
    /** The component height. */
    private static int height = boxsize;
    
    
    public static class InputIcon extends JComponent {
        
        /** The component width. */
        private int width = boxsize + halfsize + arrowsize;
        
        /* A shape for the box. */
        private Rectangle2D.Double box = new Rectangle2D.Double();
        
        /* A shape for the line. */
        private Line2D.Double line     = new Line2D.Double();
        
        /* A shape for the arc. */
        private Arc2D.Double arc       = new Arc2D.Double();
        
        
        public InputIcon() {
            setPreferredSize(new Dimension(width, height));
        }
        
        protected void paintComponent(Graphics g) {
            int x, y, w, h;
            Graphics2D g2 = (Graphics2D)g;
            
            g2.setStroke
                (new BasicStroke
                    (linewidth, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
            
            g2.setRenderingHint(
                RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
            
            // draw the box
            if (boxColor == null)
                boxColor = Color.black;
            
            g2.setPaint(boxColor);
            
            box.setFrame(0, 0, boxsize, boxsize);
            
            g2.fill(box);
            
            // draw the arrow segments
            if (inputColor == null)
                inputColor = Color.green;
            
            g2.setPaint(inputColor);
            
            // the line down
            x = boxsize + + arrowsize + linewidth;
            y = 0;
            h = halfsize - linewidth / 2;
            
            line.setLine(x, y, x, y + h);
            g2.draw(line);
            
            // the line into the box
            y = halfsize;
            w = boxsize/2;
            
            line.setLine(x, y, w, y);
            g2.draw(line);
            
            // the arrow head
            x = boxsize/2;
            
            line.setLine(x, y, x + arrowsize, y - arrowsize);
            g2.draw(line);
            
            line.setLine(x, y, x + arrowsize, y + arrowsize);
            g2.draw(line);
        }
        
    }
    
    public static class ActionIcon extends JComponent {
        /** The component width. */
        private int width = boxsize;
        
        /** The arc inset. */
        private int inset = 2;
        
        /* A shape for the box. */
        private Rectangle2D.Double box = new Rectangle2D.Double();
        
        /* A shape for the line. */
        private Line2D.Double line     = new Line2D.Double();
        
        /* A shape for the arc. */
        private Arc2D.Double arc       = new Arc2D.Double();
        
        
        public ActionIcon() {
            setPreferredSize(new Dimension(width, height));
        }
        
        protected void paintComponent(Graphics g) {
            int x, y, w, h;
            Graphics2D g2 = (Graphics2D)g;
            
            g2.setStroke
                (new BasicStroke
                    (linewidth, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
            
            g2.setRenderingHint(
                RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
            
            // draw the box
            if (boxColor == null)
                boxColor = Color.black;
            
            g2.setPaint(boxColor);
            
            box.setFrame(0, 0, boxsize, boxsize);
            
            g2.fill(box);
            
            // draw the arrow segments
            if (actionColor == null)
                actionColor = Color.yellow;
            
            g2.setPaint(actionColor);
            
            // the arc
            w = boxsize - linewidth - 2 * inset;
            h = w;
            
            x = inset + linewidth / 2;
            y = x;
            
            int start = 135;
            int total = 315;
            
            arc.setArc(x, y, w, h, start, total, Arc2D.OPEN);
            
            g2.draw(arc);
            
            // calculate the start of the arc to find the arrow location
            int radius = halfsize - x;
            int side = (int) Math.round(radius * MathUtilities.sindeg(45));
            
            x = halfsize - side;
            y = x;
            
            // the arrow head
            line.setLine(x, y, x - arrowsize, y);
            g2.draw(line);
            
            // x + 1 is used rather than x because it visually looks better!
            line.setLine(x, y, x + 1, y + arrowsize);
            g2.draw(line);
        }
        
    }
    
    public static class OutputIcon extends JComponent {
        /** The component width. */
        private int width = boxsize + halfsize + arrowsize;
        
        /* A shape for the box. */
        private Rectangle2D.Double box = new Rectangle2D.Double();
        
        /* A shape for the line. */
        private Line2D.Double line     = new Line2D.Double();
        
        /* A shape for the arc. */
        private Arc2D.Double arc       = new Arc2D.Double();
        
        
        public OutputIcon() {
            setPreferredSize(new Dimension(width, height));
        }
        
        protected void paintComponent(Graphics g) {
            int x, y, w, h;
            Graphics2D g2 = (Graphics2D)g;
            
            g2.setStroke
                (new BasicStroke
                    (linewidth, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
            
            g2.setRenderingHint(
                RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
            
            // draw the box
            if (boxColor == null)
                boxColor = Color.black;
            
            g2.setPaint(boxColor);
            
            box.setFrame(halfsize + arrowsize, 0, boxsize, boxsize);
            
            g2.fill(box);
            
            // draw the arrow segments
            if (outputColor == null)
                outputColor = Color.blue;
            
            g2.setPaint(outputColor);
            
            // the line out of the box
            x = boxsize + arrowsize;
            y = halfsize;
            w = boxsize - linewidth / 2;
            
            line.setLine(x, y, x - w, y);
            g2.draw(line);
            
            // the line up
            x -= w;
            y = linewidth / 2;
            h = halfsize - linewidth / 2;
            
            line.setLine(x, y, x, y + h);
            g2.draw(line);
            
            // the arrow head
            line.setLine(x, y, x - arrowsize, y + arrowsize);
            g2.draw(line);
            
            line.setLine(x, y, x + arrowsize, y + arrowsize);
            g2.draw(line);
        }
    }
}
