/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.codec.CodecUtilities;
import edu.neu.ccs.util.JPTError;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.event.SwingPropertyChangeSupport;

public class StringableFactory
implements Cloneable,
Serializable {
    public static final String DATA_TYPE = "data.type";
    protected Class type = null;
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);
    static /* synthetic */ Class class$edu$neu$ccs$XString;
    static /* synthetic */ Class class$edu$neu$ccs$Stringable;

    public StringableFactory(Class dataType) {
        this.setDataType(dataType);
    }

    public Stringable getDefaultInstance() {
        try {
            return (Stringable)this.type.newInstance();
        }
        catch (Exception ex) {
            throw new Error("Stringable could not be instantiated: " + ex.getMessage());
        }
    }

    public Stringable constructFrom(String data) throws ParseException {
        return StringableFactory.constructFrom(this.type, data);
    }

    public void setDataType(Class dataType) {
        Class oldType = this.getDataType();
        if (dataType == null) {
            Class clazz = dataType = class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = StringableFactory.class$("edu.neu.ccs.XString"));
        }
        if (!StringableFactory.isStringable(dataType)) {
            throw new Error("Class is not Stringable: " + dataType.getName());
        }
        this.type = dataType;
        if (this.getDataType() != oldType) {
            this.changeAdapter.firePropertyChange(DATA_TYPE, oldType, this.getDataType());
        }
    }

    public Class getDataType() {
        return this.type;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }

    public static boolean isStringable(Class dataType) {
        return (class$edu$neu$ccs$Stringable != null ? class$edu$neu$ccs$Stringable : (class$edu$neu$ccs$Stringable = StringableFactory.class$("edu.neu.ccs.Stringable"))).isAssignableFrom(dataType);
    }

    public static String encodeTypeAndData(Stringable obj) {
        return CodecUtilities.encode(new String[]{obj.getClass().getName(), obj.toStringData()});
    }

    public static Stringable decodeTypeAndData(String data) throws ParseException {
        if (data == null) {
            throw new NullPointerException();
        }
        String[] pair = CodecUtilities.decode(data);
        if (pair == null || pair.length != 2) {
            throw new ParseException("String does not contain both type and state: " + data, -1);
        }
        Class<?> dataType = null;
        try {
            dataType = Class.forName(pair[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParseException("error in data type: " + pair[0], -1);
        }
        return StringableFactory.constructFrom(dataType, pair[1]);
    }

    public static Stringable constructFrom(Class dataType, String data) throws ParseException {
        if (!StringableFactory.isStringable(dataType)) {
            throw new JPTError("Class is not Stringable: " + dataType.getName());
        }
        try {
            Stringable object = (Stringable)dataType.newInstance();
            object.fromStringData(data);
            return object;
        }
        catch (ParseException ex1) {
            throw ex1;
        }
        catch (NumberFormatException ex2) {
            throw new ParseException(ex2.getMessage(), -1);
        }
        catch (Exception ex3) {
            throw new JPTError("Stringable could not be instantiated: " + ex3.getMessage());
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

