/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.filter;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.filter.BoundFilter;
import edu.neu.ccs.filter.FilterException;

public class MinimumBoundFilter
extends BoundFilter {
    public static final String MINIMUM = "minimum";

    public MinimumBoundFilter(boolean inclusive) {
        super(inclusive);
    }

    public static class Long
    extends MinimumBoundFilter {
        protected long minimum = 0L;

        public Long(long min) {
            this(min, true);
        }

        public Long(long min, boolean isInclusive) {
            super(isInclusive);
            this.setMinimum(min);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            XNumber n = (XNumber)super.filterStringable(obj);
            long l = n.longValue();
            if (this.getMinimum() < l || this.isInclusive() && this.getMinimum() == l) {
                return obj;
            }
            String message = "Value not within the range ";
            message = String.valueOf(message) + (super.isInclusive() ? "[" : "(");
            message = String.valueOf(message) + this.getMinimum() + ", inf.]";
            throw new FilterException(obj, message);
        }

        public void setMinimum(long min) {
            long oldMin = this.getMinimum();
            this.minimum = min;
            if (this.getMinimum() != oldMin) {
                this.changeAdapter.firePropertyChange(MinimumBoundFilter.MINIMUM, new java.lang.Long(oldMin), new java.lang.Long(this.getMinimum()));
            }
        }

        public long getMinimum() {
            return this.minimum;
        }
    }

    public static class Double
    extends MinimumBoundFilter {
        protected double minimum = 0.0;

        public Double(double min) {
            this(min, true);
        }

        public Double(double min, boolean isInclusive) {
            super(isInclusive);
            this.setMinimum(min);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            XNumber n = (XNumber)super.filterStringable(obj);
            double d = n.doubleValue();
            if (this.getMinimum() < d || this.isInclusive() && this.getMinimum() == d) {
                return obj;
            }
            String message = "Value not within the range ";
            message = String.valueOf(message) + (super.isInclusive() ? "[" : "(");
            message = String.valueOf(message) + this.getMinimum() + ", inf.]";
            throw new FilterException(obj, message);
        }

        public void setMinimum(double min) {
            double oldMin = this.getMinimum();
            this.minimum = min;
            if (this.getMinimum() != oldMin) {
                this.changeAdapter.firePropertyChange(MinimumBoundFilter.MINIMUM, new java.lang.Double(oldMin), new java.lang.Double(this.getMinimum()));
            }
        }

        public double getMinimum() {
            return this.minimum;
        }
    }

    public static class BigInteger
    extends MinimumBoundFilter {
        protected java.math.BigInteger minimum = null;

        public BigInteger(java.math.BigInteger min) {
            this(min, true);
        }

        public BigInteger(java.math.BigInteger min, boolean isInclusive) {
            super(isInclusive);
            this.setMinimum(min);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            XNumber n = (XNumber)super.filterStringable(obj);
            java.math.BigInteger b = new java.math.BigInteger(new java.lang.Long(n.longValue()).toString());
            if (b.compareTo(this.getMinimum()) > 0 || this.isInclusive() && b.compareTo(this.getMinimum()) == 0) {
                return obj;
            }
            String message = "Value not within the range ";
            message = String.valueOf(message) + (super.isInclusive() ? "[" : "(");
            message = String.valueOf(message) + this.getMinimum() + ", inf.]";
            throw new FilterException(obj, message);
        }

        public void setMinimum(java.math.BigInteger min) {
            if (min == null) {
                return;
            }
            java.math.BigInteger oldMin = this.getMinimum();
            this.minimum = min;
            if (!this.getMinimum().equals(oldMin)) {
                this.changeAdapter.firePropertyChange(MinimumBoundFilter.MINIMUM, oldMin, this.getMinimum());
            }
        }

        public java.math.BigInteger getMinimum() {
            return this.minimum;
        }
    }

    public static class BigDecimal
    extends MinimumBoundFilter {
        protected java.math.BigDecimal minimum = null;

        public BigDecimal(java.math.BigDecimal min) {
            this(min, true);
        }

        public BigDecimal(java.math.BigDecimal min, boolean isInclusive) {
            super(isInclusive);
            this.setMinimum(min);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            XNumber n = (XNumber)super.filterStringable(obj);
            java.math.BigDecimal d = new java.math.BigDecimal(n.doubleValue());
            if (d.compareTo(this.getMinimum()) > 0 || this.isInclusive() && d.compareTo(this.getMinimum()) == 0) {
                return obj;
            }
            String message = "Value not within the range ";
            message = String.valueOf(message) + (super.isInclusive() ? "[" : "(");
            message = String.valueOf(message) + this.getMinimum() + ", inf.]";
            throw new FilterException(obj, message);
        }

        public void setMinimum(java.math.BigDecimal min) {
            if (min == null) {
                return;
            }
            java.math.BigDecimal oldMin = this.getMinimum();
            this.minimum = min;
            if (!this.getMinimum().equals(oldMin)) {
                this.changeAdapter.firePropertyChange(MinimumBoundFilter.MINIMUM, oldMin, this.getMinimum());
            }
        }

        public java.math.BigDecimal getMinimum() {
            return this.minimum;
        }
    }
}

