/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.codec;

import edu.neu.ccs.codec.Codec;
import java.io.Serializable;
import java.text.ParseException;

public class CountPrefixCodec
implements Codec,
Serializable {
    public String encode(String[] data) {
        if (data == null) {
            return "#@";
        }
        String s = String.valueOf(data.length) + "@";
        int i = 0;
        while (i < data.length) {
            s = data[i] == null ? String.valueOf(s) + "#:" : String.valueOf(s) + data[i].length() + ":" + data[i];
            ++i;
        }
        return s;
    }

    public String[] decode(String data) throws ParseException {
        if (data == null) {
            return null;
        }
        int pos = 0;
        int colon = 0;
        int length = 0;
        int strlen = 0;
        String[] element = null;
        String substring = null;
        pos = data.indexOf("@");
        if (pos == -1) {
            throw new ParseException("Expected '#@' OR 'array_length@'", data.length());
        }
        substring = data.substring(0, pos);
        if (substring.length() == 0) {
            throw new ParseException("Expected '#@' OR 'array_length@'", pos);
        }
        if (substring.charAt(0) == '#') {
            return element;
        }
        try {
            length = Integer.parseInt(data.substring(0, pos++));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Expected 'array_length@'", pos);
        }
        if (length < 0) {
            throw new ParseException("Expected array_length >= 0", pos);
        }
        element = new String[length];
        int i = 0;
        while (i < length) {
            colon = data.indexOf(":", pos);
            if (colon == -1) {
                throw new ParseException("Expected '#:' OR 'string_length:'", data.length());
            }
            substring = data.substring(pos, colon);
            pos = colon + 1;
            if (substring.length() == 0) {
                throw new ParseException("Expected '#:' OR 'string_length:'", colon);
            }
            if (substring.charAt(0) != '#') {
                try {
                    strlen = Integer.parseInt(substring);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Expected 'string_length:'", colon);
                }
                if (strlen < 0) {
                    throw new ParseException("Expected string_length >= 0", colon);
                }
                if (pos + strlen > data.length()) {
                    throw new ParseException("Expected " + (pos + strlen - data.length()) + " more characters in the String", data.length());
                }
                element[i] = data.substring(pos, pos + strlen);
                pos += strlen;
            }
            ++i;
        }
        return element;
    }

    public String getPrefix() {
        return "CPC";
    }
}

