import java.io .*;
import java.util.*;


public class Log{
    
    static final String FILEPATH = "log.txt";
    static final String DATAFOLDER = "/home/rahul/data/src/ml/dataset/hw1/housing/";


    // writes the message to screen in a new line
    public static void write(Object message){
	System.out.println(message);
    }

    // write a set
    public static void writeSet(Set items){
	System.out.println("Items count: "+ items.size() + " Values are: ");
	for(Object item : items){
	    System.out.print(item + ",");
	}
	System.out.println();
   }
    // write any List
    public static void writeList(List items){
	System.out.println("Items count: "+ items.size() + " Values are: ");
	for(Object item : items){
	    System.out.print(item + ",");
	}
	System.out.println();
	
    }

    // writes double array
    public static void writeDoubleArray(double[] items){
	System.out.println("Items count: "+ items.length + " Values are: ");
	for(double item : items){
	    System.out.print(item + ",");
	}
	System.out.println();
    }

    // writes any array
    public static void writeObjectArray(Object[] items){
	System.out.println("Items count: "+ items.length + " Values are: ");
	for(Object item : items){
	    System.out.print(item + ",");
	}
	System.out.println();
    }
    //writes the data to a file
    public static void writeToFile(double[][] dataSet, String fileName,
				   String separator) throws IOException{
	int rowCounter, colCounter = 0; 
	BufferedWriter writer = 
	    new BufferedWriter(new FileWriter(DATAFOLDER + fileName));
	for(rowCounter = 0; rowCounter < dataSet.length ; rowCounter++ ){
	    for(colCounter = 0; colCounter < dataSet[rowCounter].length; 
		colCounter++){
		writer.write(Double.toString(dataSet[rowCounter][colCounter]));
		if(colCounter != dataSet[rowCounter].length - 1)
		    writer.write(separator);
	    }
	    writer.newLine();//add new line after each row
	}
	writer.close();
	write("Dataset written back at: "+ DATAFOLDER + fileName);
    }

    //writes 2D Double Array to screen
    public static void write2DDoubleArray(double[][] data){
        if (data.length == 0) System.out.println("No Data available to print");
        int colCount = data[0].length;
        for(int rowCounter = 0; rowCounter < data.length; rowCounter++){
            String currentRow = "";//append all columns to string and print
            // once
            for(int colCounter = 0; colCounter < colCount ; colCounter++){
                currentRow += data[rowCounter][colCounter] + " ";
            }
            System.out.println(currentRow);
        }
    }
}
