/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.LongArray;

public class RadixSort {
    public static int sort(LongArray array, int numRecords, int startByteIndex, int endByteIndex, boolean desc, boolean signed) {
        assert (startByteIndex >= 0) : "startByteIndex (" + startByteIndex + ") should >= 0";
        assert (endByteIndex <= 7) : "endByteIndex (" + endByteIndex + ") should <= 7";
        assert (endByteIndex > startByteIndex);
        assert ((long)(numRecords * 2) <= array.size());
        int inIndex = 0;
        int outIndex = numRecords;
        if (numRecords > 0) {
            long[][] counts = RadixSort.getCounts(array, numRecords, startByteIndex, endByteIndex);
            for (int i = startByteIndex; i <= endByteIndex; ++i) {
                if (counts[i] == null) continue;
                RadixSort.sortAtByte(array, numRecords, counts[i], i, inIndex, outIndex, desc, signed && i == endByteIndex);
                int tmp = inIndex;
                inIndex = outIndex;
                outIndex = tmp;
            }
        }
        return inIndex;
    }

    private static void sortAtByte(LongArray array, int numRecords, long[] counts, int byteIdx, int inIndex, int outIndex, boolean desc, boolean signed) {
        assert (counts.length == 256);
        long[] offsets = RadixSort.transformCountsToOffsets(counts, numRecords, array.getBaseOffset() + (long)(outIndex * 8), 8, desc, signed);
        Object baseObject = array.getBaseObject();
        long baseOffset = array.getBaseOffset() + (long)(inIndex * 8);
        long maxOffset = baseOffset + (long)(numRecords * 8);
        for (long offset = baseOffset; offset < maxOffset; offset += 8L) {
            long value2 = Platform.getLong((Object)baseObject, (long)offset);
            int bucket = (int)(value2 >>> byteIdx * 8 & 0xFFL);
            Platform.putLong((Object)baseObject, (long)offsets[bucket], (long)value2);
            int n = bucket;
            offsets[n] = offsets[n] + 8L;
        }
    }

    private static long[][] getCounts(LongArray array, int numRecords, int startByteIndex, int endByteIndex) {
        long[][] counts = new long[8][];
        long bitwiseMax = 0L;
        long bitwiseMin = -1L;
        long maxOffset = array.getBaseOffset() + (long)(numRecords * 8);
        Object baseObject = array.getBaseObject();
        for (long offset = array.getBaseOffset(); offset < maxOffset; offset += 8L) {
            long value2 = Platform.getLong((Object)baseObject, (long)offset);
            bitwiseMax |= value2;
            bitwiseMin &= value2;
        }
        long bitsChanged = bitwiseMin ^ bitwiseMax;
        for (int i = startByteIndex; i <= endByteIndex; ++i) {
            if ((bitsChanged >>> i * 8 & 0xFFL) == 0L) continue;
            counts[i] = new long[256];
            for (long offset = array.getBaseOffset(); offset < maxOffset; offset += 8L) {
                long[] lArray = counts[i];
                int n = (int)(Platform.getLong((Object)baseObject, (long)offset) >>> i * 8 & 0xFFL);
                lArray[n] = lArray[n] + 1L;
            }
        }
        return counts;
    }

    private static long[] transformCountsToOffsets(long[] counts, int numRecords, long outputOffset, int bytesPerRecord, boolean desc, boolean signed) {
        int start2;
        assert (counts.length == 256);
        int n = start2 = signed ? 128 : 0;
        if (desc) {
            int pos = numRecords;
            for (int i = start2; i < start2 + 256; ++i) {
                pos = (int)((long)pos - counts[i & 0xFF]);
                counts[i & 0xFF] = outputOffset + (long)(pos * bytesPerRecord);
            }
        } else {
            int pos = 0;
            for (int i = start2; i < start2 + 256; ++i) {
                long tmp = counts[i & 0xFF];
                counts[i & 0xFF] = outputOffset + (long)(pos * bytesPerRecord);
                pos = (int)((long)pos + tmp);
            }
        }
        return counts;
    }

    public static int sortKeyPrefixArray(LongArray array, int numRecords, int startByteIndex, int endByteIndex, boolean desc, boolean signed) {
        assert (startByteIndex >= 0) : "startByteIndex (" + startByteIndex + ") should >= 0";
        assert (endByteIndex <= 7) : "endByteIndex (" + endByteIndex + ") should <= 7";
        assert (endByteIndex > startByteIndex);
        assert ((long)(numRecords * 4) <= array.size());
        int inIndex = 0;
        int outIndex = numRecords * 2;
        if (numRecords > 0) {
            long[][] counts = RadixSort.getKeyPrefixArrayCounts(array, numRecords, startByteIndex, endByteIndex);
            for (int i = startByteIndex; i <= endByteIndex; ++i) {
                if (counts[i] == null) continue;
                RadixSort.sortKeyPrefixArrayAtByte(array, numRecords, counts[i], i, inIndex, outIndex, desc, signed && i == endByteIndex);
                int tmp = inIndex;
                inIndex = outIndex;
                outIndex = tmp;
            }
        }
        return inIndex;
    }

    private static long[][] getKeyPrefixArrayCounts(LongArray array, int numRecords, int startByteIndex, int endByteIndex) {
        long[][] counts = new long[8][];
        long bitwiseMax = 0L;
        long bitwiseMin = -1L;
        long limit = array.getBaseOffset() + (long)(numRecords * 16);
        Object baseObject = array.getBaseObject();
        for (long offset = array.getBaseOffset(); offset < limit; offset += 16L) {
            long value2 = Platform.getLong((Object)baseObject, (long)(offset + 8L));
            bitwiseMax |= value2;
            bitwiseMin &= value2;
        }
        long bitsChanged = bitwiseMin ^ bitwiseMax;
        for (int i = startByteIndex; i <= endByteIndex; ++i) {
            if ((bitsChanged >>> i * 8 & 0xFFL) == 0L) continue;
            counts[i] = new long[256];
            for (long offset = array.getBaseOffset(); offset < limit; offset += 16L) {
                long[] lArray = counts[i];
                int n = (int)(Platform.getLong((Object)baseObject, (long)(offset + 8L)) >>> i * 8 & 0xFFL);
                lArray[n] = lArray[n] + 1L;
            }
        }
        return counts;
    }

    private static void sortKeyPrefixArrayAtByte(LongArray array, int numRecords, long[] counts, int byteIdx, int inIndex, int outIndex, boolean desc, boolean signed) {
        assert (counts.length == 256);
        long[] offsets = RadixSort.transformCountsToOffsets(counts, numRecords, array.getBaseOffset() + (long)(outIndex * 8), 16, desc, signed);
        Object baseObject = array.getBaseObject();
        long baseOffset = array.getBaseOffset() + (long)(inIndex * 8);
        long maxOffset = baseOffset + (long)(numRecords * 16);
        for (long offset = baseOffset; offset < maxOffset; offset += 16L) {
            long key = Platform.getLong((Object)baseObject, (long)offset);
            long prefix = Platform.getLong((Object)baseObject, (long)(offset + 8L));
            int bucket = (int)(prefix >>> byteIdx * 8 & 0xFFL);
            long dest = offsets[bucket];
            Platform.putLong((Object)baseObject, (long)dest, (long)key);
            Platform.putLong((Object)baseObject, (long)(dest + 8L), (long)prefix);
            int n = bucket;
            offsets[n] = offsets[n] + 16L;
        }
    }
}

