/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.SparkStatusTracker;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.ui.ConsoleProgressBar$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005}a!B\u0001\u0003\u0001\u0011Q!AE\"p]N|G.\u001a)s_\u001e\u0014Xm]:CCJT!a\u0001\u0003\u0002\u0005UL'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\u0007\u0001Y\u0011\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Ui\u0011a\u0005\u0006\u0003)\u0011\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003-M\u0011q\u0001T8hO&tw\r\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\t\u00198m\u0001\u0001\u0011\u0005maR\"\u0001\u0003\n\u0005u!!\u0001D*qCJ\\7i\u001c8uKb$\b\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\b\u0006\u0002\"GA\u0011!\u0005A\u0007\u0002\u0005!)\u0001D\ba\u00015!9Q\u0005\u0001b\u0001\n\u00031\u0013AA\"S+\u00059\u0003C\u0001\u0007)\u0013\tISB\u0001\u0003DQ\u0006\u0014\bBB\u0016\u0001A\u0003%q%A\u0002D%\u0002Bq!\f\u0001C\u0002\u0013\u0005a&A\u0007V!\u0012\u000bE+R0Q\u000bJKu\nR\u000b\u0002_A\u0011A\u0002M\u0005\u0003c5\u0011A\u0001T8oO\"11\u0007\u0001Q\u0001\n=\na\"\u0016)E\u0003R+u\fU#S\u0013>#\u0005\u0005C\u00046\u0001\t\u0007I\u0011\u0001\u0018\u0002\u0017\u0019K%k\u0015+`\t\u0016c\u0015)\u0017\u0005\u0007o\u0001\u0001\u000b\u0011B\u0018\u0002\u0019\u0019K%k\u0015+`\t\u0016c\u0015)\u0017\u0011\t\u000fe\u0002!\u0019!C\u0001u\u0005iA+\u001a:nS:\fGnV5ei\",\u0012a\u000f\t\u0003\u0019qJ!!P\u0007\u0003\u0007%sG\u000f\u0003\u0004@\u0001\u0001\u0006IaO\u0001\u000f)\u0016\u0014X.\u001b8bY^KG\r\u001e5!\u0011\u001d\t\u0005\u00011A\u0005\u00029\na\u0002\\1ti\u001aKg.[:i)&lW\rC\u0004D\u0001\u0001\u0007I\u0011\u0001#\u0002%1\f7\u000f\u001e$j]&\u001c\b\u000eV5nK~#S-\u001d\u000b\u0003\u000b\"\u0003\"\u0001\u0004$\n\u0005\u001dk!\u0001B+oSRDq!\u0013\"\u0002\u0002\u0003\u0007q&A\u0002yIEBaa\u0013\u0001!B\u0013y\u0013a\u00047bgR4\u0015N\\5tQRKW.\u001a\u0011\t\u000f5\u0003\u0001\u0019!C\u0001]\u0005qA.Y:u+B$\u0017\r^3US6,\u0007bB(\u0001\u0001\u0004%\t\u0001U\u0001\u0013Y\u0006\u001cH/\u00169eCR,G+[7f?\u0012*\u0017\u000f\u0006\u0002F#\"9\u0011JTA\u0001\u0002\u0004y\u0003BB*\u0001A\u0003&q&A\bmCN$X\u000b\u001d3bi\u0016$\u0016.\\3!\u0011\u001d)\u0006\u00011A\u0005\u0002Y\u000bq\u0002\\1tiB\u0013xn\u001a:fgN\u0014\u0015M]\u000b\u0002/B\u0011\u0001,X\u0007\u00023*\u0011!lW\u0001\u0005Y\u0006twMC\u0001]\u0003\u0011Q\u0017M^1\n\u0005yK&AB*ue&tw\rC\u0004a\u0001\u0001\u0007I\u0011A1\u0002'1\f7\u000f\u001e)s_\u001e\u0014Xm]:CCJ|F%Z9\u0015\u0005\u0015\u0013\u0007bB%`\u0003\u0003\u0005\ra\u0016\u0005\u0007I\u0002\u0001\u000b\u0015B,\u0002!1\f7\u000f\u001e)s_\u001e\u0014Xm]:CCJ\u0004\u0003b\u00024\u0001\u0005\u0004%IaZ\u0001\u0006i&lWM]\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111nW\u0001\u0005kRLG.\u0003\u0002nU\n)A+[7fe\"1q\u000e\u0001Q\u0001\n!\fa\u0001^5nKJ\u0004\u0003\"B9\u0001\t\u0013\u0011\u0018a\u0002:fMJ,7\u000f\u001b\u000b\u0002\u000b\")A\u000f\u0001C\u0005k\u0006!1\u000f[8x)\r)e\u000f\u001f\u0005\u0006oN\u0004\raL\u0001\u0004]><\b\"B=t\u0001\u0004Q\u0018AB:uC\u001e,7\u000fE\u0003|\u0003\u000f\tiAD\u0002}\u0003\u0007q1!`A\u0001\u001b\u0005q(BA@\u001a\u0003\u0019a$o\\8u}%\ta\"C\u0002\u0002\u00065\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\n\u0005-!aA*fc*\u0019\u0011QA\u0007\u0011\u0007m\ty!C\u0002\u0002\u0012\u0011\u0011ab\u00159be.\u001cF/Y4f\u0013:4w\u000e\u0003\u0004\u0002\u0016\u0001!IA]\u0001\u0006G2,\u0017M\u001d\u0005\u0007\u00033\u0001A\u0011\u0001:\u0002\u0013\u0019Lg.[:i\u00032d\u0007BBA\u000f\u0001\u0011\u0005!/\u0001\u0003ti>\u0004\b")
public class ConsoleProgressBar
implements Logging {
    private final SparkContext sc;
    private final char CR;
    private final long UPDATE_PERIOD;
    private final long FIRST_DELAY;
    private final int TerminalWidth;
    private long lastFinishTime;
    private long lastUpdateTime;
    private String lastProgressBar;
    private final Timer timer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public char CR() {
        return this.CR;
    }

    public long UPDATE_PERIOD() {
        return this.UPDATE_PERIOD;
    }

    public long FIRST_DELAY() {
        return this.FIRST_DELAY;
    }

    public int TerminalWidth() {
        return this.TerminalWidth;
    }

    public long lastFinishTime() {
        return this.lastFinishTime;
    }

    public void lastFinishTime_$eq(long x$1) {
        this.lastFinishTime = x$1;
    }

    public long lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void lastUpdateTime_$eq(long x$1) {
        this.lastUpdateTime = x$1;
    }

    public String lastProgressBar() {
        return this.lastProgressBar;
    }

    public void lastProgressBar_$eq(String x$1) {
        this.lastProgressBar = x$1;
    }

    private Timer timer() {
        return this.timer;
    }

    public synchronized void org$apache$spark$ui$ConsoleProgressBar$$refresh() {
        long now = System.currentTimeMillis();
        if (now - this.lastFinishTime() < this.FIRST_DELAY()) {
            return;
        }
        int[] stageIds = this.sc.statusTracker().getActiveStageIds();
        SparkStatusTracker sparkStatusTracker = this.sc.statusTracker();
        SparkStageInfo[] stages = (SparkStageInfo[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(stageIds).flatMap((Function1)new Serializable(this, sparkStatusTracker){
            public static final long serialVersionUID = 0L;
            private final SparkStatusTracker eta$0$1$1;

            public final Iterable<SparkStageInfo> apply(int stageId) {
                return Option$.MODULE$.option2Iterable(this.eta$0$1$1.getStageInfo(stageId));
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkStageInfo.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(SparkStageInfo x$1) {
                return x$1.numTasks() > 1;
            }
        })).filter((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsoleProgressBar $outer;
            private final long now$1;

            public final boolean apply(SparkStageInfo x$2) {
                return this.now$1 - x$2.submissionTime() > this.$outer.FIRST_DELAY();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        })).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(SparkStageInfo x$3) {
                return x$3.stageId();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        if (stages.length > 0) {
            this.show(now, (Seq<SparkStageInfo>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])stages).take(3)));
        }
    }

    private void show(long now, Seq<SparkStageInfo> stages) {
        String bar;
        int width = this.TerminalWidth() / stages.size();
        String string = bar = ((TraversableOnce)stages.map((Function1)new Serializable(this, width){
            public static final long serialVersionUID = 0L;
            private final int width$1;

            public final String apply(SparkStageInfo s) {
                String string;
                int total = s.numTasks();
                String header = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Stage ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)s.stageId())}));
                String tailer = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " + ", ") / ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)s.numCompletedTasks()), BoxesRunTime.boxToInteger((int)s.numActiveTasks()), BoxesRunTime.boxToInteger((int)total)}));
                int w = this.width$1 - header.length() - tailer.length();
                if (w > 0) {
                    int percent = w * s.numCompletedTasks() / total;
                    string = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), w).map((Function1)new Serializable(this, percent){
                        public static final long serialVersionUID = 0L;
                        private final int percent$1;

                        public final String apply(int i) {
                            return i < this.percent$1 ? "=" : (i == this.percent$1 ? ">" : " ");
                        }
                        {
                            this.percent$1 = percent$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("");
                } else {
                    string = "";
                }
                String bar = string;
                return new StringBuilder().append((Object)header).append((Object)bar).append((Object)tailer).toString();
            }
            {
                this.width$1 = width$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("");
        String string2 = this.lastProgressBar();
        if ((string != null ? !string.equals(string2) : string2 != null) || now - this.lastUpdateTime() > 60000L) {
            System.err.print(new StringBuilder().append(this.CR()).append((Object)bar).toString());
            this.lastUpdateTime_$eq(now);
        }
        this.lastProgressBar_$eq(bar);
    }

    private void clear() {
        if (!this.lastProgressBar().isEmpty()) {
            System.err.printf(new StringBuilder().append(this.CR()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.TerminalWidth())).append((Object)BoxesRunTime.boxToCharacter((char)this.CR())).toString(), new Object[0]);
            this.lastProgressBar_$eq("");
        }
    }

    public synchronized void finishAll() {
        this.clear();
        this.lastFinishTime_$eq(System.currentTimeMillis());
    }

    public void stop() {
        this.timer().cancel();
    }

    public ConsoleProgressBar(SparkContext sc) {
        this.sc = sc;
        Logging$class.$init$(this);
        this.CR = (char)13;
        this.UPDATE_PERIOD = 200L;
        this.FIRST_DELAY = 500L;
        this.TerminalWidth = ((String)package$.MODULE$.env().getOrElse((Object)"COLUMNS", (Function0)new $anonfun$1(this))).isEmpty() ? 80 : new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().get((Object)"COLUMNS").get())).toInt();
        this.lastFinishTime = 0L;
        this.lastUpdateTime = 0L;
        this.lastProgressBar = "";
        this.timer = new Timer("refresh progress", true);
        this.timer().schedule(new TimerTask(this){
            private final /* synthetic */ ConsoleProgressBar $outer;

            public void run() {
                this.$outer.org$apache$spark$ui$ConsoleProgressBar$$refresh();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.FIRST_DELAY(), this.UPDATE_PERIOD());
    }
}

