/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockStatus$;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u0001-\u0011Qb\u0015;pe\u0006<Wm\u0015;biV\u001c(BA\u0002\u0005\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011)\u0019!C\u0001)\u0005q!\r\\8dW6\u000bg.Y4fe&#W#A\u000b\u0011\u0005Y9R\"\u0001\u0002\n\u0005a\u0011!A\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018\n\u001a\u0005\t5\u0001\u0011\t\u0011)A\u0005+\u0005y!\r\\8dW6\u000bg.Y4fe&#\u0007\u0005\u0003\u0005\u001d\u0001\t\u0015\r\u0011\"\u0001\u001e\u0003\u0019i\u0017\r_'f[V\ta\u0004\u0005\u0002\u000e?%\u0011\u0001E\u0004\u0002\u0005\u0019>tw\r\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u001di\u0017\r_'f[\u0002BQ\u0001\n\u0001\u0005\u0002\u0015\na\u0001P5oSRtDc\u0001\u0014(QA\u0011a\u0003\u0001\u0005\u0006'\r\u0002\r!\u0006\u0005\u00069\r\u0002\rA\b\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0003)y&\u000f\u001a3CY>\u001c7n]\u000b\u0002YA!QF\r\u001b8\u001b\u0005q#BA\u00181\u0003\u001diW\u000f^1cY\u0016T!!\r\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00024]\t9\u0001*Y:i\u001b\u0006\u0004\bCA\u00076\u0013\t1dBA\u0002J]R\u0004B!\f\u001d;{%\u0011\u0011H\f\u0002\u0004\u001b\u0006\u0004\bC\u0001\f<\u0013\ta$AA\u0004CY>\u001c7.\u00133\u0011\u0005Yq\u0014BA \u0003\u0005-\u0011En\\2l'R\fG/^:\t\r\u0005\u0003\u0001\u0015!\u0003-\u0003-y&\u000f\u001a3CY>\u001c7n\u001d\u0011\t\u000f\r\u0003!\u0019!C\u0005\t\u0006iqL\\8o%\u0012$'\t\\8dWN,\u0012!\u0012\t\u0005[IRT\b\u0003\u0004H\u0001\u0001\u0006I!R\u0001\u000f?:|gN\u00153e\u00052|7m[:!\u0011\u001dI\u0005A1A\u0005\n)\u000bqb\u0018:eIN#xN]1hK&sgm\\\u000b\u0002\u0017B!QF\r\u001bM!\u0015iQJ\b\u0010P\u0013\tqeB\u0001\u0004UkBdWm\r\t\u0003-AK!!\u0015\u0002\u0003\u0019M#xN]1hK2+g/\u001a7\t\rM\u0003\u0001\u0015!\u0003L\u0003Ay&\u000f\u001a3Ti>\u0014\u0018mZ3J]\u001a|\u0007\u0005C\u0004V\u0001\u0001\u0007I\u0011\u0002,\u0002%}swN\u001c*eIN#xN]1hK&sgm\\\u000b\u0002/B!Q\u0002\u0017\u0010\u001f\u0013\tIfB\u0001\u0004UkBdWM\r\u0005\b7\u0002\u0001\r\u0011\"\u0003]\u0003Yyfn\u001c8SI\u0012\u001cFo\u001c:bO\u0016LeNZ8`I\u0015\fHCA/a!\tia,\u0003\u0002`\u001d\t!QK\\5u\u0011\u001d\t',!AA\u0002]\u000b1\u0001\u001f\u00132\u0011\u0019\u0019\u0007\u0001)Q\u0005/\u0006\u0019rL\\8o%\u0012$7\u000b^8sC\u001e,\u0017J\u001c4pA!)A\u0005\u0001C\u0001KR!aE\u001a5j\u0011\u00159G\r1\u0001\u0016\u0003\u0011\u0011W.\u001b3\t\u000bq!\u0007\u0019\u0001\u0010\t\u000b)$\u0007\u0019A6\u0002\u001b%t\u0017\u000e^5bY\ncwnY6t!\u0011aWNO\u001f\u000e\u0003AJ!!\u000f\u0019\t\u000b=\u0004A\u0011\u00019\u0002\r\tdwnY6t+\u0005Y\u0007\"\u0002:\u0001\t\u0003\u0001\u0018!\u0003:eI\ncwnY6t\u0011\u0015!\b\u0001\"\u0001v\u00035\u0011H\r\u001a\"m_\u000e\\7OQ=JIR\u00111N\u001e\u0005\u0006oN\u0004\r\u0001N\u0001\u0006e\u0012$\u0017\n\u001a\u0005\u0007s\u0002!\t\u0001\u0002>\u0002\u0011\u0005$GM\u00117pG.$2!X>~\u0011\u0015a\b\u00101\u0001;\u0003\u001d\u0011Gn\\2l\u0013\u0012DQA =A\u0002u\n1B\u00197pG.\u001cF/\u0019;vg\"A\u0011\u0011\u0001\u0001\u0005\u0002\u0011\t\u0019!A\u0006va\u0012\fG/\u001a\"m_\u000e\\G#B/\u0002\u0006\u0005\u001d\u0001\"\u0002?\u0000\u0001\u0004Q\u0004\"\u0002@\u0000\u0001\u0004i\u0004\u0002CA\u0006\u0001\u0011\u0005A!!\u0004\u0002\u0017I,Wn\u001c<f\u00052|7m\u001b\u000b\u0005\u0003\u001f\t)\u0002\u0005\u0003\u000e\u0003#i\u0014bAA\n\u001d\t1q\n\u001d;j_:Da\u0001`A\u0005\u0001\u0004Q\u0004bBA\r\u0001\u0011\u0005\u00111D\u0001\u000eG>tG/Y5og\ncwnY6\u0015\t\u0005u\u00111\u0005\t\u0004\u001b\u0005}\u0011bAA\u0011\u001d\t9!i\\8mK\u0006t\u0007B\u0002?\u0002\u0018\u0001\u0007!\bC\u0004\u0002(\u0001!\t!!\u000b\u0002\u0011\u001d,GO\u00117pG.$B!a\u0004\u0002,!1A0!\nA\u0002iBq!a\f\u0001\t\u0003\t\t$A\u0005ok6\u0014En\\2lgV\tA\u0007C\u0004\u00026\u0001!\t!!\r\u0002\u00199,XN\u00153e\u00052|7m[:\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<\u0005\u0001b.^7SI\u0012\u0014En\\2lg\nK\u0018\n\u001a\u000b\u0004i\u0005u\u0002BB<\u00028\u0001\u0007A\u0007\u0003\u0004\u0002B\u0001!\t!H\u0001\r[\u0016l'+Z7bS:Lgn\u001a\u0005\u0007\u0003\u000b\u0002A\u0011A\u000f\u0002\u000f5,W.V:fI\"1\u0011\u0011\n\u0001\u0005\u0002u\t\u0011bY1dQ\u0016\u001c\u0016N_3\t\r\u00055\u0003\u0001\"\u0001\u001e\u0003!!\u0017n]6Vg\u0016$\u0007bBA)\u0001\u0011\u0005\u00111K\u0001\r[\u0016lWk]3e\u0005f\u0014F\r\u001a\u000b\u0004=\u0005U\u0003BB<\u0002P\u0001\u0007A\u0007C\u0004\u0002Z\u0001!\t!a\u0017\u0002\u001b\u0011L7o[+tK\u0012\u0014\u0015P\u00153e)\rq\u0012Q\f\u0005\u0007o\u0006]\u0003\u0019\u0001\u001b\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d\u0005y!\u000f\u001a3Ti>\u0014\u0018mZ3MKZ,G\u000e\u0006\u0003\u0002f\u0005\u001d\u0004\u0003B\u0007\u0002\u0012=Caa^A0\u0001\u0004!\u0004bBA6\u0001\u0011%\u0011QN\u0001\u0012kB$\u0017\r^3Ti>\u0014\u0018mZ3J]\u001a|G#B/\u0002p\u0005E\u0004B\u0002?\u0002j\u0001\u0007!\bC\u0004\u0002t\u0005%\u0004\u0019A\u001f\u0002\u001d9,wO\u00117pG.\u001cF/\u0019;vg\"\u001a\u0001!a\u001e\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! \u0005\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000e")
public class StorageStatus {
    private final BlockManagerId blockManagerId;
    private final long maxMem;
    private final HashMap<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> _rddBlocks;
    private final HashMap<BlockId, BlockStatus> _nonRddBlocks;
    private final HashMap<Object, Tuple3<Object, Object, StorageLevel>> _rddStorageInfo;
    private Tuple2<Object, Object> _nonRddStorageInfo;

    public BlockManagerId blockManagerId() {
        return this.blockManagerId;
    }

    public long maxMem() {
        return this.maxMem;
    }

    private HashMap<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> _rddBlocks() {
        return this._rddBlocks;
    }

    private HashMap<BlockId, BlockStatus> _nonRddBlocks() {
        return this._nonRddBlocks;
    }

    private HashMap<Object, Tuple3<Object, Object, StorageLevel>> _rddStorageInfo() {
        return this._rddStorageInfo;
    }

    private Tuple2<Object, Object> _nonRddStorageInfo() {
        return this._nonRddStorageInfo;
    }

    private void _nonRddStorageInfo_$eq(Tuple2<Object, Object> x$1) {
        this._nonRddStorageInfo = x$1;
    }

    public Map<BlockId, BlockStatus> blocks() {
        return this._nonRddBlocks().$plus$plus(this.rddBlocks());
    }

    public Map<BlockId, BlockStatus> rddBlocks() {
        return (Map)this._rddBlocks().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.mutable.Map<BlockId, BlockStatus> apply(Tuple2<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> x0$2) {
                Tuple2<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> tuple2 = x0$2;
                if (tuple2 != null) {
                    scala.collection.mutable.Map blocks;
                    scala.collection.mutable.Map map2 = blocks = (scala.collection.mutable.Map)tuple2._2();
                    return map2;
                }
                throw new MatchError(tuple2);
            }
        }, HashMap$.MODULE$.canBuildFrom());
    }

    public Map<BlockId, BlockStatus> rddBlocksById(int rddId) {
        return (Map)this._rddBlocks().getOrElse((Object)BoxesRunTime.boxToInteger((int)rddId), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<BlockId, Nothing$> apply() {
                return Map$.MODULE$.empty();
            }
        });
    }

    public void addBlock(BlockId blockId, BlockStatus blockStatus2) {
        this.updateStorageInfo(blockId, blockStatus2);
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            ((scala.collection.mutable.MapLike)this._rddBlocks().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rddId), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final HashMap<BlockId, BlockStatus> apply() {
                    return new HashMap();
                }
            })).update((Object)blockId, (Object)blockStatus2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this._nonRddBlocks().update((Object)blockId, (Object)blockStatus2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void updateBlock(BlockId blockId, BlockStatus blockStatus2) {
        this.addBlock(blockId, blockStatus2);
    }

    public Option<BlockStatus> removeBlock(BlockId blockId) {
        Option option;
        this.updateStorageInfo(blockId, BlockStatus$.MODULE$.empty());
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            None$ none$;
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            if (this._rddBlocks().contains((Object)BoxesRunTime.boxToInteger((int)rddId))) {
                Option removed = ((scala.collection.mutable.MapLike)this._rddBlocks().apply((Object)BoxesRunTime.boxToInteger((int)rddId))).remove((Object)blockId);
                Object object = ((MapLike)this._rddBlocks().apply((Object)BoxesRunTime.boxToInteger((int)rddId))).isEmpty() ? this._rddBlocks().remove((Object)BoxesRunTime.boxToInteger((int)rddId)) : BoxedUnit.UNIT;
                none$ = removed;
            } else {
                none$ = None$.MODULE$;
            }
            option = none$;
        } else {
            option = this._nonRddBlocks().remove((Object)blockId);
        }
        return option;
    }

    public boolean containsBlock(BlockId blockId) {
        boolean bl;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            bl = this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).exists((Function1)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$1;

                public final boolean apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$1) {
                    return x$1.contains((Object)this.blockId$1);
                }
                {
                    this.blockId$1 = blockId$1;
                }
            });
        } else {
            bl = this._nonRddBlocks().contains((Object)blockId);
        }
        return bl;
    }

    public Option<BlockStatus> getBlock(BlockId blockId) {
        Option option;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            option = this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).flatMap((Function1)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$2;

                public final Option<BlockStatus> apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$2) {
                    return x$2.get((Object)this.blockId$2);
                }
                {
                    this.blockId$2 = blockId$2;
                }
            });
        } else {
            option = this._nonRddBlocks().get((Object)blockId);
        }
        return option;
    }

    public int numBlocks() {
        return this._nonRddBlocks().size() + this.numRddBlocks();
    }

    public int numRddBlocks() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this._rddBlocks().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$3) {
                return x$3.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public int numRddBlocksById(int rddId) {
        return BoxesRunTime.unboxToInt((Object)this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$4) {
                return x$4.size();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
    }

    public long memRemaining() {
        return this.maxMem() - this.memUsed();
    }

    public long memUsed() {
        return this._nonRddStorageInfo()._1$mcJ$sp() + this.cacheSize();
    }

    public long cacheSize() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this._rddBlocks().keys().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(int rddId) {
                return this.apply$mcJI$sp(rddId);
            }

            public long apply$mcJI$sp(int rddId) {
                return this.$outer.memUsedByRdd(rddId);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long diskUsed() {
        return this._nonRddStorageInfo()._2$mcJ$sp() + BoxesRunTime.unboxToLong((Object)((TraversableOnce)this._rddBlocks().keys().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(int rddId) {
                return this.apply$mcJI$sp(rddId);
            }

            public long apply$mcJI$sp(int rddId) {
                return this.$outer.diskUsedByRdd(rddId);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long memUsedByRdd(int rddId) {
        return BoxesRunTime.unboxToLong((Object)this._rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, StorageLevel> x$5) {
                return BoxesRunTime.unboxToLong((Object)x$5._1());
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public long diskUsedByRdd(int rddId) {
        return BoxesRunTime.unboxToLong((Object)this._rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, StorageLevel> x$6) {
                return BoxesRunTime.unboxToLong((Object)x$6._2());
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public Option<StorageLevel> rddStorageLevel(int rddId) {
        return this._rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StorageLevel apply(Tuple3<Object, Object, StorageLevel> x$7) {
                return (StorageLevel)x$7._3();
            }
        });
    }

    private void updateStorageInfo(BlockId blockId, BlockStatus newBlockStatus) {
        Tuple2 tuple2;
        BlockStatus oldBlockStatus = (BlockStatus)this.getBlock(blockId).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BlockStatus apply() {
                return BlockStatus$.MODULE$.empty();
            }
        });
        long changeInMem = newBlockStatus.memSize() - oldBlockStatus.memSize();
        long changeInDisk = newBlockStatus.diskSize() - oldBlockStatus.diskSize();
        StorageLevel level = newBlockStatus.storageLevel();
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            tuple2 = (Tuple2)this._rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new $anonfun$2(this)).getOrElse((Function0)new $anonfun$3(this));
        } else {
            tuple2 = this._nonRddStorageInfo();
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 != null) {
            Tuple2.mcJJ.sp sp2;
            long oldMem = tuple22._1$mcJ$sp();
            long oldDisk = tuple22._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(oldMem, oldDisk);
            long oldMem2 = sp3._1$mcJ$sp();
            long oldDisk2 = sp3._2$mcJ$sp();
            long newMem = package$.MODULE$.max(oldMem2 + changeInMem, 0L);
            long newDisk = package$.MODULE$.max(oldDisk2 + changeInDisk, 0L);
            BlockId blockId3 = blockId;
            if (blockId3 instanceof RDDBlockId) {
                BoxedUnit boxedUnit;
                RDDBlockId rDDBlockId = (RDDBlockId)blockId3;
                int rddId = rDDBlockId.rddId();
                if (newMem + newDisk == 0L) {
                    this._rddStorageInfo().remove((Object)BoxesRunTime.boxToInteger((int)rddId));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this._rddStorageInfo().update((Object)BoxesRunTime.boxToInteger((int)rddId), (Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)newMem), (Object)BoxesRunTime.boxToLong((long)newDisk), (Object)level));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                this._nonRddStorageInfo_$eq((Tuple2<Object, Object>)new Tuple2.mcJJ.sp(newMem, newDisk));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(tuple22);
    }

    public StorageStatus(BlockManagerId blockManagerId, long maxMem) {
        this.blockManagerId = blockManagerId;
        this.maxMem = maxMem;
        this._rddBlocks = new HashMap();
        this._nonRddBlocks = new HashMap();
        this._rddStorageInfo = new HashMap();
        this._nonRddStorageInfo = new Tuple2.mcJJ.sp(0L, 0L);
    }

    public StorageStatus(BlockManagerId bmid, long maxMem, Map<BlockId, BlockStatus> initialBlocks) {
        this(bmid, maxMem);
        initialBlocks.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final void apply(Tuple2<BlockId, BlockStatus> x0$1) {
                Tuple2<BlockId, BlockStatus> tuple2 = x0$1;
                if (tuple2 != null) {
                    BlockId bid = (BlockId)tuple2._1();
                    BlockStatus bstatus = (BlockStatus)tuple2._2();
                    this.$outer.addBlock(bid, bstatus);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

