/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.DiskBlockObjectWriter$;
import org.apache.spark.storage.FileSegment;
import org.apache.spark.storage.TimeTrackingOutputStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t\u0005c!B\u0001\u0003\u0001\u0011Q!!\u0006#jg.\u0014En\\2l\u001f\nTWm\u0019;Xe&$XM\u001d\u0006\u0003\u0007\u0011\tqa\u001d;pe\u0006<WM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\r\u00011b\u0005\t\u0003\u0019Ei\u0011!\u0004\u0006\u0003\u001d=\t!![8\u000b\u0003A\tAA[1wC&\u0011!#\u0004\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0011\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00031U\u0011q\u0001T8hO&tw\r\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\u00111\u0017\u000e\\3\u0004\u0001U\tQ\u0004\u0005\u0002\r=%\u0011q$\u0004\u0002\u0005\r&dW\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u00151\u0017\u000e\\3!\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013AE:fe&\fG.\u001b>fe&s7\u000f^1oG\u0016\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\u0003\u0002\u0015M,'/[1mSj,'/\u0003\u0002*M\t\u00112+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0011!Y\u0003A!A!\u0002\u0013a\u0013A\u00032vM\u001a,'oU5{KB\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t\u0019\u0011J\u001c;\t\u0011M\u0002!\u0011!Q\u0001\nQ\nabY8naJ,7o]*ue\u0016\fW\u000e\u0005\u0003.k-Y\u0011B\u0001\u001c/\u0005%1UO\\2uS>t\u0017\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0003)\u0019\u0018P\\2Xe&$Xm\u001d\t\u0003[iJ!a\u000f\u0018\u0003\u000f\t{w\u000e\\3b]\"AQ\b\u0001B\u0001B\u0003%a(\u0001\u0007xe&$X-T3ue&\u001c7\u000f\u0005\u0002@\u00056\t\u0001I\u0003\u0002B\t\u0005AQ\r_3dkR|'/\u0003\u0002D\u0001\n\u00192\u000b[;gM2,wK]5uK6+GO]5dg\"AQ\t\u0001BC\u0002\u0013\u0005a)A\u0004cY>\u001c7.\u00133\u0016\u0003\u001d\u0003\"\u0001S%\u000e\u0003\tI!A\u0013\u0002\u0003\u000f\tcwnY6JI\"AA\n\u0001B\u0001B\u0003%q)\u0001\u0005cY>\u001c7.\u00133!\u0011\u0015q\u0005\u0001\"\u0001P\u0003\u0019a\u0014N\\5u}QA\u0001+\u0015*T)V3v\u000b\u0005\u0002I\u0001!)!$\u0014a\u0001;!)1%\u0014a\u0001I!)1&\u0014a\u0001Y!)1'\u0014a\u0001i!)\u0001(\u0014a\u0001s!)Q(\u0014a\u0001}!9Q)\u0014I\u0001\u0002\u00049\u0005bB-\u0001\u0001\u0004%IAW\u0001\bG\"\fgN\\3m+\u0005Y\u0006C\u0001/b\u001b\u0005i&B\u00010`\u0003!\u0019\u0007.\u00198oK2\u001c(B\u00011\u0010\u0003\rq\u0017n\\\u0005\u0003Ev\u00131BR5mK\u000eC\u0017M\u001c8fY\"9A\r\u0001a\u0001\n\u0013)\u0017aC2iC:tW\r\\0%KF$\"AZ5\u0011\u00055:\u0017B\u00015/\u0005\u0011)f.\u001b;\t\u000f)\u001c\u0017\u0011!a\u00017\u0006\u0019\u0001\u0010J\u0019\t\r1\u0004\u0001\u0015)\u0003\\\u0003!\u0019\u0007.\u00198oK2\u0004\u0003b\u00028\u0001\u0001\u0004%Ia\\\u0001\u0003EN,\u0012a\u0003\u0005\bc\u0002\u0001\r\u0011\"\u0003s\u0003\u0019\u00117o\u0018\u0013fcR\u0011am\u001d\u0005\bUB\f\t\u00111\u0001\f\u0011\u0019)\b\u0001)Q\u0005\u0017\u0005\u0019!m\u001d\u0011\t\u000f]\u0004\u0001\u0019!C\u0005q\u0006\u0019am\\:\u0016\u0003e\u0004\"\u0001\u0004>\n\u0005ml!\u0001\u0005$jY\u0016|U\u000f\u001e9viN#(/Z1n\u0011\u001di\b\u00011A\u0005\ny\fqAZ8t?\u0012*\u0017\u000f\u0006\u0002g\u007f\"9!\u000e`A\u0001\u0002\u0004I\bbBA\u0002\u0001\u0001\u0006K!_\u0001\u0005M>\u001c\b\u0005C\u0005\u0002\b\u0001\u0001\r\u0011\"\u0003\u0002\n\u0005\u0011Ao]\u000b\u0003\u0003\u0017\u00012\u0001SA\u0007\u0013\r\tyA\u0001\u0002\u0019)&lW\r\u0016:bG.LgnZ(viB,Ho\u0015;sK\u0006l\u0007\"CA\n\u0001\u0001\u0007I\u0011BA\u000b\u0003\u0019!8o\u0018\u0013fcR\u0019a-a\u0006\t\u0013)\f\t\"!AA\u0002\u0005-\u0001\u0002CA\u000e\u0001\u0001\u0006K!a\u0003\u0002\u0007Q\u001c\b\u0005C\u0005\u0002 \u0001\u0001\r\u0011\"\u0003\u0002\"\u00051qN\u00196PkR,\"!a\t\u0011\u0007\u0015\n)#C\u0002\u0002(\u0019\u00121cU3sS\u0006d\u0017N_1uS>t7\u000b\u001e:fC6D\u0011\"a\u000b\u0001\u0001\u0004%I!!\f\u0002\u0015=\u0014'nT;u?\u0012*\u0017\u000fF\u0002g\u0003_A\u0011B[A\u0015\u0003\u0003\u0005\r!a\t\t\u0011\u0005M\u0002\u0001)Q\u0005\u0003G\tqa\u001c2k\u001fV$\b\u0005C\u0005\u00028\u0001\u0001\r\u0011\"\u0003\u0002:\u0005Y\u0011N\\5uS\u0006d\u0017N_3e+\u0005I\u0004\"CA\u001f\u0001\u0001\u0007I\u0011BA \u0003=Ig.\u001b;jC2L'0\u001a3`I\u0015\fHc\u00014\u0002B!A!.a\u000f\u0002\u0002\u0003\u0007\u0011\bC\u0004\u0002F\u0001\u0001\u000b\u0015B\u001d\u0002\u0019%t\u0017\u000e^5bY&TX\r\u001a\u0011\t\u0013\u0005%\u0003\u00011A\u0005\n\u0005e\u0012!\u00045bg\n+WM\\\"m_N,G\rC\u0005\u0002N\u0001\u0001\r\u0011\"\u0003\u0002P\u0005\t\u0002.Y:CK\u0016t7\t\\8tK\u0012|F%Z9\u0015\u0007\u0019\f\t\u0006\u0003\u0005k\u0003\u0017\n\t\u00111\u0001:\u0011\u001d\t)\u0006\u0001Q!\ne\na\u0002[1t\u0005\u0016,gn\u00117pg\u0016$\u0007\u0005C\u0005\u0002Z\u0001\u0001\r\u0011\"\u0003\u0002:\u0005Y2m\\7nSR\fe\u000eZ\"m_N,\u0007*Y:CK\u0016t7)\u00197mK\u0012D\u0011\"!\u0018\u0001\u0001\u0004%I!a\u0018\u0002?\r|W.\\5u\u0003:$7\t\\8tK\"\u000b7OQ3f]\u000e\u000bG\u000e\\3e?\u0012*\u0017\u000fF\u0002g\u0003CB\u0001B[A.\u0003\u0003\u0005\r!\u000f\u0005\b\u0003K\u0002\u0001\u0015)\u0003:\u0003q\u0019w.\\7ji\u0006sGm\u00117pg\u0016D\u0015m\u001d\"fK:\u001c\u0015\r\u001c7fI\u0002B\u0011\"!\u001b\u0001\u0005\u0004%I!a\u001b\u0002\u001f%t\u0017\u000e^5bYB{7/\u001b;j_:,\"!!\u001c\u0011\u00075\ny'C\u0002\u0002r9\u0012A\u0001T8oO\"A\u0011Q\u000f\u0001!\u0002\u0013\ti'\u0001\tj]&$\u0018.\u00197Q_NLG/[8oA!I\u0011\u0011\u0010\u0001A\u0002\u0013%\u00111N\u0001\u000eM&t\u0017\r\u001c)pg&$\u0018n\u001c8\t\u0013\u0005u\u0004\u00011A\u0005\n\u0005}\u0014!\u00054j]\u0006d\u0007k\\:ji&|gn\u0018\u0013fcR\u0019a-!!\t\u0013)\fY(!AA\u0002\u00055\u0004\u0002CAC\u0001\u0001\u0006K!!\u001c\u0002\u001d\u0019Lg.\u00197Q_NLG/[8oA!I\u0011\u0011\u0012\u0001A\u0002\u0013%\u00111N\u0001\u0011e\u0016\u0004xN\u001d;fIB{7/\u001b;j_:D\u0011\"!$\u0001\u0001\u0004%I!a$\u0002)I,\u0007o\u001c:uK\u0012\u0004vn]5uS>tw\fJ3r)\r1\u0017\u0011\u0013\u0005\nU\u0006-\u0015\u0011!a\u0001\u0003[B\u0001\"!&\u0001A\u0003&\u0011QN\u0001\u0012e\u0016\u0004xN\u001d;fIB{7/\u001b;j_:\u0004\u0003\"CAM\u0001\u0001\u0007I\u0011BAN\u0003EqW/\u001c*fG>\u0014Hm],sSR$XM\\\u000b\u0002Y!I\u0011q\u0014\u0001A\u0002\u0013%\u0011\u0011U\u0001\u0016]Vl'+Z2pe\u0012\u001cxK]5ui\u0016tw\fJ3r)\r1\u00171\u0015\u0005\tU\u0006u\u0015\u0011!a\u0001Y!9\u0011q\u0015\u0001!B\u0013a\u0013A\u00058v[J+7m\u001c:eg^\u0013\u0018\u000e\u001e;f]\u0002Bq!a+\u0001\t\u0003\ti+\u0001\u0003pa\u0016tG#\u0001)\t\u000f\u0005E\u0006\u0001\"\u0011\u00024\u0006)1\r\\8tKR\ta\rC\u0004\u00028\u0002!\t!!\u000f\u0002\r%\u001cx\n]3o\u0011\u001d\tY\f\u0001C\u0001\u0003g\u000babY8n[&$\u0018I\u001c3DY>\u001cX\rC\u0004\u0002@\u0002!\t!!1\u00027I,g/\u001a:u!\u0006\u0014H/[1m/JLG/Z:B]\u0012\u001cEn\\:f)\u0005i\u0002bBAc\u0001\u0011\u0005\u0011qY\u0001\u0006oJLG/\u001a\u000b\u0006M\u0006%\u00171\u001b\u0005\t\u0003\u0017\f\u0019\r1\u0001\u0002N\u0006\u00191.Z=\u0011\u00075\ny-C\u0002\u0002R:\u00121!\u00118z\u0011!\t).a1A\u0002\u00055\u0017!\u0002<bYV,\u0007bBAc\u0001\u0011\u0005\u0013\u0011\u001c\u000b\u0004M\u0006m\u0007bBAo\u0003/\u0004\r\u0001L\u0001\u0002E\"9\u0011Q\u0019\u0001\u0005B\u0005\u0005Hc\u00024\u0002d\u0006M\u0018q\u001f\u0005\t\u0003K\fy\u000e1\u0001\u0002h\u000691N\u001e\"zi\u0016\u001c\b#B\u0017\u0002j\u00065\u0018bAAv]\t)\u0011I\u001d:bsB\u0019Q&a<\n\u0007\u0005EhF\u0001\u0003CsR,\u0007bBA{\u0003?\u0004\r\u0001L\u0001\u0005_\u001a47\u000fC\u0004\u0002z\u0006}\u0007\u0019\u0001\u0017\u0002\u00071,g\u000eC\u0004\u0002~\u0002!\t!a-\u0002\u001bI,7m\u001c:e/JLG\u000f^3o\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007\t1BZ5mKN+w-\\3oiR\u0011!Q\u0001\t\u0004\u0011\n\u001d\u0011b\u0001B\u0005\u0005\tYa)\u001b7f'\u0016<W.\u001a8u\u0011\u001d\u0011i\u0001\u0001C\u0005\u0003g\u000b!#\u001e9eCR,')\u001f;fg^\u0013\u0018\u000e\u001e;f]\"A!\u0011\u0003\u0001\u0005B\u0011\t\u0019,A\u0003gYV\u001c\bn\u0002\u0006\u0003\u0016\t\t\t\u0011#\u0001\u0005\u0005/\tQ\u0003R5tW\ncwnY6PE*,7\r^,sSR,'\u000fE\u0002I\u000531\u0011\"\u0001\u0002\u0002\u0002#\u0005AAa\u0007\u0014\t\te!Q\u0004\t\u0004[\t}\u0011b\u0001B\u0011]\t1\u0011I\\=SK\u001aDqA\u0014B\r\t\u0003\u0011)\u0003\u0006\u0002\u0003\u0018!Q!\u0011\u0006B\r#\u0003%\tAa\u000b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011iCK\u0002H\u0005_Y#A!\r\u0011\t\tM\"QH\u0007\u0003\u0005kQAAa\u000e\u0003:\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005wq\u0013AC1o]>$\u0018\r^5p]&!!q\bB\u001b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DiskBlockObjectWriter
extends OutputStream
implements Logging {
    private final File file;
    private final SerializerInstance serializerInstance;
    private final int bufferSize;
    private final Function1<OutputStream, OutputStream> compressStream;
    public final boolean org$apache$spark$storage$DiskBlockObjectWriter$$syncWrites;
    public final ShuffleWriteMetrics org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics;
    private final BlockId blockId;
    private FileChannel channel;
    private OutputStream bs;
    private FileOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$fos;
    private TimeTrackingOutputStream ts;
    private SerializationStream org$apache$spark$storage$DiskBlockObjectWriter$$objOut;
    private boolean initialized;
    private boolean hasBeenClosed;
    private boolean commitAndCloseHasBeenCalled;
    private final long initialPosition;
    private long finalPosition;
    private long reportedPosition;
    private int numRecordsWritten;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static BlockId $lessinit$greater$default$7() {
        return DiskBlockObjectWriter$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public File file() {
        return this.file;
    }

    public BlockId blockId() {
        return this.blockId;
    }

    private FileChannel channel() {
        return this.channel;
    }

    private void channel_$eq(FileChannel x$1) {
        this.channel = x$1;
    }

    private OutputStream bs() {
        return this.bs;
    }

    private void bs_$eq(OutputStream x$1) {
        this.bs = x$1;
    }

    public FileOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$fos() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$fos;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$fos_$eq(FileOutputStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$fos = x$1;
    }

    private TimeTrackingOutputStream ts() {
        return this.ts;
    }

    private void ts_$eq(TimeTrackingOutputStream x$1) {
        this.ts = x$1;
    }

    public SerializationStream org$apache$spark$storage$DiskBlockObjectWriter$$objOut() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$objOut_$eq(SerializationStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean hasBeenClosed() {
        return this.hasBeenClosed;
    }

    private void hasBeenClosed_$eq(boolean x$1) {
        this.hasBeenClosed = x$1;
    }

    private boolean commitAndCloseHasBeenCalled() {
        return this.commitAndCloseHasBeenCalled;
    }

    private void commitAndCloseHasBeenCalled_$eq(boolean x$1) {
        this.commitAndCloseHasBeenCalled = x$1;
    }

    private long initialPosition() {
        return this.initialPosition;
    }

    private long finalPosition() {
        return this.finalPosition;
    }

    private void finalPosition_$eq(long x$1) {
        this.finalPosition = x$1;
    }

    private long reportedPosition() {
        return this.reportedPosition;
    }

    private void reportedPosition_$eq(long x$1) {
        this.reportedPosition = x$1;
    }

    private int numRecordsWritten() {
        return this.numRecordsWritten;
    }

    private void numRecordsWritten_$eq(int x$1) {
        this.numRecordsWritten = x$1;
    }

    public DiskBlockObjectWriter open() {
        if (this.hasBeenClosed()) {
            throw new IllegalStateException("Writer already closed. Cannot be reopened.");
        }
        this.org$apache$spark$storage$DiskBlockObjectWriter$$fos_$eq(new FileOutputStream(this.file(), true));
        this.ts_$eq(new TimeTrackingOutputStream(this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics, this.org$apache$spark$storage$DiskBlockObjectWriter$$fos()));
        this.channel_$eq(this.org$apache$spark$storage$DiskBlockObjectWriter$$fos().getChannel());
        this.bs_$eq((OutputStream)this.compressStream.apply((Object)new BufferedOutputStream(this.ts(), this.bufferSize)));
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut_$eq(this.serializerInstance.serializeStream(this.bs()));
        this.initialized_$eq(true);
        return this;
    }

    @Override
    public void close() {
        if (this.initialized()) {
            Utils$.MODULE$.tryWithSafeFinally(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    if (this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$syncWrites) {
                        this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
                        long start2 = System.nanoTime();
                        this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$fos().getFD().sync();
                        this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incWriteTime(System.nanoTime() - start2);
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().close();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.channel_$eq(null);
            this.bs_$eq(null);
            this.org$apache$spark$storage$DiskBlockObjectWriter$$fos_$eq(null);
            this.ts_$eq(null);
            this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut_$eq(null);
            this.initialized_$eq(false);
            this.hasBeenClosed_$eq(true);
        }
    }

    public boolean isOpen() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut() != null;
    }

    public void commitAndClose() {
        if (this.initialized()) {
            this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
            this.bs().flush();
            this.close();
            this.finalPosition_$eq(this.file().length());
            this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incBytesWritten(this.finalPosition() - this.reportedPosition());
        } else {
            this.finalPosition_$eq(this.file().length());
        }
        this.commitAndCloseHasBeenCalled_$eq(true);
    }

    public File revertPartialWritesAndClose() {
        File file;
        try {
            if (this.initialized()) {
                this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.decBytesWritten(this.reportedPosition() - this.initialPosition());
                this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.decRecordsWritten(this.numRecordsWritten());
                this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
                this.bs().flush();
                this.close();
            }
            FileOutputStream truncateStream = new FileOutputStream(this.file(), true);
            try {
                truncateStream.getChannel().truncate(this.initialPosition());
                file = this.file();
            }
            finally {
                truncateStream.close();
            }
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Uncaught exception while reverting partial writes to file ").append((Object)this.$outer.file()).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, exception2);
            file = this.file();
        }
        return file;
    }

    public void write(Object key, Object value2) {
        Object object = this.initialized() ? BoxedUnit.UNIT : this.open();
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().writeKey(key, ClassTag$.MODULE$.Any());
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().writeValue(value2, ClassTag$.MODULE$.Any());
        this.recordWritten();
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] kvBytes, int offs, int len) {
        Object object = this.initialized() ? BoxedUnit.UNIT : this.open();
        this.bs().write(kvBytes, offs, len);
    }

    public void recordWritten() {
        this.numRecordsWritten_$eq(this.numRecordsWritten() + 1);
        this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incRecordsWritten(1L);
        if (this.numRecordsWritten() % 16384 == 0) {
            this.updateBytesWritten();
        }
    }

    public FileSegment fileSegment() {
        if (this.commitAndCloseHasBeenCalled()) {
            return new FileSegment(this.file(), this.initialPosition(), this.finalPosition() - this.initialPosition());
        }
        throw new IllegalStateException("fileSegment() is only valid after commitAndClose() has been called");
    }

    private void updateBytesWritten() {
        long pos = this.channel().position();
        this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incBytesWritten(pos - this.reportedPosition());
        this.reportedPosition_$eq(pos);
    }

    @Override
    public void flush() {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
        this.bs().flush();
    }

    public DiskBlockObjectWriter(File file, SerializerInstance serializerInstance, int bufferSize, Function1<OutputStream, OutputStream> compressStream, boolean syncWrites, ShuffleWriteMetrics writeMetrics, BlockId blockId) {
        this.file = file;
        this.serializerInstance = serializerInstance;
        this.bufferSize = bufferSize;
        this.compressStream = compressStream;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$syncWrites = syncWrites;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics = writeMetrics;
        this.blockId = blockId;
        Logging$class.$init$(this);
        this.channel = null;
        this.bs = null;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$fos = null;
        this.ts = null;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut = null;
        this.initialized = false;
        this.hasBeenClosed = false;
        this.commitAndCloseHasBeenCalled = false;
        this.initialPosition = file.length();
        this.finalPosition = -1L;
        this.reportedPosition = this.initialPosition();
        this.numRecordsWritten = 0;
    }
}

