/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.util.HashMap;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005=c!B\u0001\u0003\u0001\u0011Q!\u0001\u0005\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018J\u001c4p\u0015\t\u0019A!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0012!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0011!#F\u0007\u0002')\u0011A\u0003B\u0001\tS:$XM\u001d8bY&\u0011ac\u0005\u0002\b\u0019><w-\u001b8h\u0011!A\u0002A!b\u0001\n\u0003Q\u0012A\u00042m_\u000e\\W*\u00198bO\u0016\u0014\u0018\nZ\u0002\u0001+\u0005Y\u0002C\u0001\u000f\u001e\u001b\u0005\u0011\u0011B\u0001\u0010\u0003\u00059\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012D\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0010E2|7m['b]\u0006<WM]%eA!A!\u0005\u0001B\u0001B\u0003%1%\u0001\u0004uS6,Wj\u001d\t\u0003\u0019\u0011J!!J\u0007\u0003\t1{gn\u001a\u0005\tO\u0001\u0011)\u0019!C\u0001Q\u00051Q.\u0019=NK6,\u0012a\t\u0005\tU\u0001\u0011\t\u0011)A\u0005G\u00059Q.\u0019=NK6\u0004\u0003\u0002\u0003\u0017\u0001\u0005\u000b\u0007I\u0011A\u0017\u0002\u001bMd\u0017M^3F]\u0012\u0004x.\u001b8u+\u0005q\u0003CA\u00183\u001b\u0005\u0001$BA\u0019\u0005\u0003\r\u0011\boY\u0005\u0003gA\u0012aB\u00159d\u000b:$\u0007o\\5oiJ+g\r\u0003\u00056\u0001\t\u0005\t\u0015!\u0003/\u00039\u0019H.\u0019<f\u000b:$\u0007o\\5oi\u0002BQa\u000e\u0001\u0005\u0002a\na\u0001P5oSRtD#B\u001d;wqj\u0004C\u0001\u000f\u0001\u0011\u0015Ab\u00071\u0001\u001c\u0011\u0015\u0011c\u00071\u0001$\u0011\u00159c\u00071\u0001$\u0011\u0015ac\u00071\u0001/\u0011\u001dy\u0004\u00011A\u0005\n!\n1b\u00187bgR\u001cV-\u001a8Ng\"9\u0011\t\u0001a\u0001\n\u0013\u0011\u0015aD0mCN$8+Z3o\u001bN|F%Z9\u0015\u0005\r3\u0005C\u0001\u0007E\u0013\t)UB\u0001\u0003V]&$\bbB$A\u0003\u0003\u0005\raI\u0001\u0004q\u0012\n\u0004BB%\u0001A\u0003&1%\u0001\u0007`Y\u0006\u001cHoU3f]6\u001b\b\u0005C\u0004L\u0001\u0001\u0007I\u0011\u0002\u0015\u0002\u001b}\u0013X-\\1j]&tw-T3n\u0011\u001di\u0005\u00011A\u0005\n9\u000b\u0011c\u0018:f[\u0006Lg.\u001b8h\u001b\u0016lw\fJ3r)\t\u0019u\nC\u0004H\u0019\u0006\u0005\t\u0019A\u0012\t\rE\u0003\u0001\u0015)\u0003$\u00039y&/Z7bS:LgnZ'f[\u0002Bqa\u0015\u0001C\u0002\u0013%A+A\u0004`E2|7m[:\u0016\u0003U\u0003BAV.^A6\tqK\u0003\u0002Y3\u0006!Q\u000f^5m\u0015\u0005Q\u0016\u0001\u00026bm\u0006L!\u0001X,\u0003\u000f!\u000b7\u000f['baB\u0011ADX\u0005\u0003?\n\u0011qA\u00117pG.LE\r\u0005\u0002\u001dC&\u0011!M\u0001\u0002\f\u00052|7m[*uCR,8\u000f\u0003\u0004e\u0001\u0001\u0006I!V\u0001\t?\ndwnY6tA!9a\r\u0001b\u0001\n\u00139\u0017!D0dC\u000eDW\r\u001a\"m_\u000e\\7/F\u0001i!\rIg.X\u0007\u0002U*\u00111\u000e\\\u0001\b[V$\u0018M\u00197f\u0015\tiW\"\u0001\u0006d_2dWm\u0019;j_:L!a\u001c6\u0003\u000f!\u000b7\u000f[*fi\"1\u0011\u000f\u0001Q\u0001\n!\fabX2bG\",GM\u00117pG.\u001c\b\u0005C\u0003t\u0001\u0011\u0005A/A\u0005hKR\u001cF/\u0019;vgR\u0011Q\u000f\u001f\t\u0004\u0019Y\u0004\u0017BA<\u000e\u0005\u0019y\u0005\u000f^5p]\")\u0011P\u001da\u0001;\u00069!\r\\8dW&#\u0007\"B>\u0001\t\u0003a\u0018\u0001E;qI\u0006$X\rT1tiN+WM\\'t)\u0005\u0019\u0005\"\u0002@\u0001\t\u0003y\u0018aD;qI\u0006$XM\u00117pG.LeNZ8\u0015\u0013\r\u000b\t!a\u0001\u0002\u000e\u0005E\u0001\"B=~\u0001\u0004i\u0006bBA\u0003{\u0002\u0007\u0011qA\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u00049\u0005%\u0011bAA\u0006\u0005\ta1\u000b^8sC\u001e,G*\u001a<fY\"1\u0011qB?A\u0002\r\nq!\\3n'&TX\r\u0003\u0004\u0002\u0014u\u0004\raI\u0001\tI&\u001c8nU5{K\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011a\u0003:f[>4XM\u00117pG.$2aQA\u000e\u0011\u0019I\u0018Q\u0003a\u0001;\"1\u0011q\u0004\u0001\u0005\u0002!\nAB]3nC&t\u0017N\\4NK6Da!a\t\u0001\t\u0003A\u0013A\u00037bgR\u001cV-\u001a8Ng\"1\u0011q\u0005\u0001\u0005\u0002Q\u000baA\u00197pG.\u001c\bbBA\u0016\u0001\u0011\u0005\u0011QF\u0001\rG\u0006\u001c\u0007.\u001a3CY>\u001c7n]\u000b\u0003\u0003_\u0001R!!\r\u00024uk\u0011\u0001\\\u0005\u0004\u0003ka'aA*fi\"9\u0011\u0011\b\u0001\u0005B\u0005m\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0002\u0003BA \u0003\u000br1\u0001DA!\u0013\r\t\u0019%D\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0013\u0011\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\rS\u0002\u0003\u0004\u0002N\u0001!\t\u0001`\u0001\u0006G2,\u0017M\u001d")
public class BlockManagerInfo
implements Logging {
    private final BlockManagerId blockManagerId;
    private final long timeMs;
    private final long maxMem;
    private final RpcEndpointRef slaveEndpoint;
    private long _lastSeenMs;
    private long org$apache$spark$storage$BlockManagerInfo$$_remainingMem;
    private final HashMap<BlockId, BlockStatus> _blocks;
    private final HashSet<BlockId> _cachedBlocks;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public BlockManagerId blockManagerId() {
        return this.blockManagerId;
    }

    public long maxMem() {
        return this.maxMem;
    }

    public RpcEndpointRef slaveEndpoint() {
        return this.slaveEndpoint;
    }

    private long _lastSeenMs() {
        return this._lastSeenMs;
    }

    private void _lastSeenMs_$eq(long x$1) {
        this._lastSeenMs = x$1;
    }

    public long org$apache$spark$storage$BlockManagerInfo$$_remainingMem() {
        return this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem;
    }

    private void org$apache$spark$storage$BlockManagerInfo$$_remainingMem_$eq(long x$1) {
        this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem = x$1;
    }

    private HashMap<BlockId, BlockStatus> _blocks() {
        return this._blocks;
    }

    private HashSet<BlockId> _cachedBlocks() {
        return this._cachedBlocks;
    }

    public Option<BlockStatus> getStatus(BlockId blockId) {
        return Option$.MODULE$.apply((Object)this._blocks().get(blockId));
    }

    public void updateLastSeenMs() {
        this._lastSeenMs_$eq(System.currentTimeMillis());
    }

    public void updateBlockInfo(BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        this.updateLastSeenMs();
        if (this._blocks().containsKey(blockId)) {
            BlockStatus blockStatus2 = this._blocks().get(blockId);
            StorageLevel originalLevel = blockStatus2.storageLevel();
            long originalMemSize = blockStatus2.memSize();
            if (originalLevel.useMemory()) {
                this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem_$eq(this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem() + originalMemSize);
            }
        }
        if (storageLevel.isValid()) {
            BlockStatus blockStatus3 = null;
            if (storageLevel.useMemory()) {
                blockStatus3 = new BlockStatus(storageLevel, memSize, 0L);
                this._blocks().put(blockId, blockStatus3);
                this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem_$eq(this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem() - memSize);
                this.logInfo((Function0<String>)new Serializable(this, blockId, memSize){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockManagerInfo $outer;
                    private final BlockId blockId$4;
                    private final long memSize$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Added %s in memory on %s (size: %s, free: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4, this.$outer.blockManagerId().hostPort(), Utils$.MODULE$.bytesToString(this.memSize$1), Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$BlockManagerInfo$$_remainingMem())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.blockId$4 = blockId$4;
                        this.memSize$1 = memSize$1;
                    }
                });
            }
            if (storageLevel.useDisk()) {
                blockStatus3 = new BlockStatus(storageLevel, 0L, diskSize);
                this._blocks().put(blockId, blockStatus3);
                this.logInfo((Function0<String>)new Serializable(this, blockId, diskSize){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockManagerInfo $outer;
                    private final BlockId blockId$4;
                    private final long diskSize$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Added %s on disk on %s (size: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4, this.$outer.blockManagerId().hostPort(), Utils$.MODULE$.bytesToString(this.diskSize$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.blockId$4 = blockId$4;
                        this.diskSize$1 = diskSize$1;
                    }
                });
            }
            if (!blockId.isBroadcast() && blockStatus3.isCached()) {
                this._cachedBlocks().$plus$eq((Object)blockId);
            }
        } else if (this._blocks().containsKey(blockId)) {
            BlockStatus blockStatus4 = this._blocks().get(blockId);
            this._blocks().remove(blockId);
            this._cachedBlocks().$minus$eq((Object)blockId);
            if (blockStatus4.storageLevel().useMemory()) {
                this.logInfo((Function0<String>)new Serializable(this, blockId, blockStatus4){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockManagerInfo $outer;
                    private final BlockId blockId$4;
                    private final BlockStatus blockStatus$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Removed %s on %s in memory (size: %s, free: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4, this.$outer.blockManagerId().hostPort(), Utils$.MODULE$.bytesToString(this.blockStatus$1.memSize()), Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$BlockManagerInfo$$_remainingMem())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.blockId$4 = blockId$4;
                        this.blockStatus$1 = blockStatus$1;
                    }
                });
            }
            if (blockStatus4.storageLevel().useDisk()) {
                this.logInfo((Function0<String>)new Serializable(this, blockId, blockStatus4){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockManagerInfo $outer;
                    private final BlockId blockId$4;
                    private final BlockStatus blockStatus$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Removed %s on %s on disk (size: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4, this.$outer.blockManagerId().hostPort(), Utils$.MODULE$.bytesToString(this.blockStatus$1.diskSize())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.blockId$4 = blockId$4;
                        this.blockStatus$1 = blockStatus$1;
                    }
                });
            }
        }
    }

    public void removeBlock(BlockId blockId) {
        Object object;
        if (this._blocks().containsKey(blockId)) {
            this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem_$eq(this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem() + this._blocks().get(blockId).memSize());
            object = this._blocks().remove(blockId);
        } else {
            object = BoxedUnit.UNIT;
        }
        this._cachedBlocks().$minus$eq((Object)blockId);
    }

    public long remainingMem() {
        return this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem();
    }

    public long lastSeenMs() {
        return this._lastSeenMs();
    }

    public HashMap<BlockId, BlockStatus> blocks() {
        return this._blocks();
    }

    public Set<BlockId> cachedBlocks() {
        return this._cachedBlocks();
    }

    public String toString() {
        return new StringBuilder().append((Object)"BlockManagerInfo ").append((Object)BoxesRunTime.boxToLong((long)this.timeMs)).append((Object)" ").append((Object)BoxesRunTime.boxToLong((long)this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem())).toString();
    }

    public void clear() {
        this._blocks().clear();
    }

    public BlockManagerInfo(BlockManagerId blockManagerId, long timeMs, long maxMem, RpcEndpointRef slaveEndpoint) {
        this.blockManagerId = blockManagerId;
        this.timeMs = timeMs;
        this.maxMem = maxMem;
        this.slaveEndpoint = slaveEndpoint;
        Logging$class.$init$(this);
        this._lastSeenMs = timeMs;
        this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem = maxMem;
        this._blocks = new HashMap();
        this._cachedBlocks = new HashSet();
    }
}

