/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.DummySerializerInstance;
import org.apache.spark.shuffle.sort.ShuffleInMemorySorter;
import org.apache.spark.shuffle.sort.SpillInfo;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.DiskBlockObjectWriter;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.annotations.VisibleForTesting;
import scala.Tuple2;

final class ShuffleExternalSorter
extends MemoryConsumer {
    private final Logger logger = LoggerFactory.getLogger(ShuffleExternalSorter.class);
    @VisibleForTesting
    static final int DISK_WRITE_BUFFER_SIZE = 0x100000;
    private final int numPartitions;
    private final TaskMemoryManager taskMemoryManager;
    private final BlockManager blockManager;
    private final TaskContext taskContext;
    private final ShuffleWriteMetrics writeMetrics;
    private final long numElementsForSpillThreshold;
    private final int fileBufferSizeBytes;
    private final LinkedList<MemoryBlock> allocatedPages = new LinkedList();
    private final LinkedList<SpillInfo> spills = new LinkedList();
    private long peakMemoryUsedBytes;
    @Nullable
    private ShuffleInMemorySorter inMemSorter;
    @Nullable
    private MemoryBlock currentPage = null;
    private long pageCursor = -1L;

    ShuffleExternalSorter(TaskMemoryManager memoryManager, BlockManager blockManager2, TaskContext taskContext, int initialSize, int numPartitions, SparkConf conf, ShuffleWriteMetrics writeMetrics) {
        super(memoryManager, (int)Math.min(0x8000000L, memoryManager.pageSizeBytes()), memoryManager.getTungstenMemoryMode());
        this.taskMemoryManager = memoryManager;
        this.blockManager = blockManager2;
        this.taskContext = taskContext;
        this.numPartitions = numPartitions;
        this.fileBufferSizeBytes = (int)conf.getSizeAsKb("spark.shuffle.file.buffer", "32k") * 1024;
        this.numElementsForSpillThreshold = conf.getLong("spark.shuffle.spill.numElementsForceSpillThreshold", 0x40000000L);
        this.writeMetrics = writeMetrics;
        this.inMemSorter = new ShuffleInMemorySorter(this, initialSize, conf.getBoolean("spark.shuffle.sort.useRadixSort", true));
        this.peakMemoryUsedBytes = this.getMemoryUsage();
    }

    private void writeSortedFile(boolean isLastFile) throws IOException {
        ShuffleWriteMetrics writeMetricsToUse = isLastFile ? this.writeMetrics : new ShuffleWriteMetrics();
        ShuffleInMemorySorter.ShuffleSorterIterator sortedRecords = this.inMemSorter.getSortedIterator();
        byte[] writeBuffer = new byte[0x100000];
        Tuple2<TempShuffleBlockId, File> spilledFileInfo = this.blockManager.diskBlockManager().createTempShuffleBlock();
        File file = (File)spilledFileInfo._2();
        TempShuffleBlockId blockId = (TempShuffleBlockId)spilledFileInfo._1();
        SpillInfo spillInfo = new SpillInfo(this.numPartitions, file, blockId);
        DummySerializerInstance ser = DummySerializerInstance.INSTANCE;
        DiskBlockObjectWriter writer = this.blockManager.getDiskWriter(blockId, file, ser, this.fileBufferSizeBytes, writeMetricsToUse);
        int currentPartition = -1;
        while (sortedRecords.hasNext()) {
            int toTransfer;
            sortedRecords.loadNext();
            int partition = sortedRecords.packedRecordPointer.getPartitionId();
            assert (partition >= currentPartition);
            if (partition != currentPartition) {
                if (currentPartition != -1) {
                    writer.commitAndClose();
                    spillInfo.partitionLengths[currentPartition] = writer.fileSegment().length();
                }
                currentPartition = partition;
                writer = this.blockManager.getDiskWriter(blockId, file, ser, this.fileBufferSizeBytes, writeMetricsToUse);
            }
            long recordPointer = sortedRecords.packedRecordPointer.getRecordPointer();
            Object recordPage = this.taskMemoryManager.getPage(recordPointer);
            long recordOffsetInPage = this.taskMemoryManager.getOffsetInPage(recordPointer);
            long recordReadPosition = recordOffsetInPage + 4L;
            for (int dataRemaining = Platform.getInt((Object)recordPage, (long)recordOffsetInPage); dataRemaining > 0; dataRemaining -= toTransfer) {
                toTransfer = Math.min(0x100000, dataRemaining);
                Platform.copyMemory((Object)recordPage, (long)recordReadPosition, (Object)writeBuffer, (long)Platform.BYTE_ARRAY_OFFSET, (long)toTransfer);
                writer.write(writeBuffer, 0, toTransfer);
                recordReadPosition += (long)toTransfer;
            }
            writer.recordWritten();
        }
        if (writer != null) {
            writer.commitAndClose();
            if (currentPartition != -1) {
                spillInfo.partitionLengths[currentPartition] = writer.fileSegment().length();
                this.spills.add(spillInfo);
            }
        }
        if (!isLastFile) {
            this.writeMetrics.incRecordsWritten(writeMetricsToUse.recordsWritten());
            this.taskContext.taskMetrics().incDiskBytesSpilled(writeMetricsToUse.bytesWritten());
        }
    }

    @Override
    public long spill(long size, MemoryConsumer trigger) throws IOException {
        if (trigger != this || this.inMemSorter == null || this.inMemSorter.numRecords() == 0) {
            return 0L;
        }
        this.logger.info("Thread {} spilling sort data of {} to disk ({} {} so far)", new Object[]{Thread.currentThread().getId(), Utils.bytesToString(this.getMemoryUsage()), this.spills.size(), this.spills.size() > 1 ? " times" : " time"});
        this.writeSortedFile(false);
        long spillSize = this.freeMemory();
        this.inMemSorter.reset();
        this.taskContext.taskMetrics().incMemoryBytesSpilled(spillSize);
        return spillSize;
    }

    private long getMemoryUsage() {
        long totalPageSize = 0L;
        for (MemoryBlock page : this.allocatedPages) {
            totalPageSize += page.size();
        }
        return (this.inMemSorter == null ? 0L : this.inMemSorter.getMemoryUsage()) + totalPageSize;
    }

    private void updatePeakMemoryUsed() {
        long mem = this.getMemoryUsage();
        if (mem > this.peakMemoryUsedBytes) {
            this.peakMemoryUsedBytes = mem;
        }
    }

    long getPeakMemoryUsedBytes() {
        this.updatePeakMemoryUsed();
        return this.peakMemoryUsedBytes;
    }

    private long freeMemory() {
        this.updatePeakMemoryUsed();
        long memoryFreed = 0L;
        for (MemoryBlock block : this.allocatedPages) {
            memoryFreed += block.size();
            this.freePage(block);
        }
        this.allocatedPages.clear();
        this.currentPage = null;
        this.pageCursor = 0L;
        return memoryFreed;
    }

    public void cleanupResources() {
        this.freeMemory();
        if (this.inMemSorter != null) {
            this.inMemSorter.free();
            this.inMemSorter = null;
        }
        for (SpillInfo spill2 : this.spills) {
            if (!spill2.file.exists() || spill2.file.delete()) continue;
            this.logger.error("Unable to delete spill file {}", (Object)spill2.file.getPath());
        }
    }

    private void growPointerArrayIfNecessary() throws IOException {
        assert (this.inMemSorter != null);
        if (!this.inMemSorter.hasSpaceForAnotherRecord()) {
            LongArray array;
            long used = this.inMemSorter.getMemoryUsage();
            try {
                array = this.allocateArray(used / 8L * 2L);
            }
            catch (OutOfMemoryError e) {
                if (!this.inMemSorter.hasSpaceForAnotherRecord()) {
                    this.logger.error("Unable to grow the pointer array");
                    throw e;
                }
                return;
            }
            if (this.inMemSorter.hasSpaceForAnotherRecord()) {
                this.freeArray(array);
            } else {
                this.inMemSorter.expandPointerArray(array);
            }
        }
    }

    private void acquireNewPageIfNecessary(int required) {
        if (this.currentPage == null || this.pageCursor + (long)required > this.currentPage.getBaseOffset() + this.currentPage.size()) {
            this.currentPage = this.allocatePage(required);
            this.pageCursor = this.currentPage.getBaseOffset();
            this.allocatedPages.add(this.currentPage);
        }
    }

    public void insertRecord(Object recordBase, long recordOffset, int length, int partitionId) throws IOException {
        assert (this.inMemSorter != null);
        if ((long)this.inMemSorter.numRecords() >= this.numElementsForSpillThreshold) {
            this.logger.info("Spilling data because number of spilledRecords crossed the threshold " + this.numElementsForSpillThreshold);
            this.spill();
        }
        this.growPointerArrayIfNecessary();
        int required = length + 4;
        this.acquireNewPageIfNecessary(required);
        assert (this.currentPage != null);
        Object base = this.currentPage.getBaseObject();
        long recordAddress = this.taskMemoryManager.encodePageNumberAndOffset(this.currentPage, this.pageCursor);
        Platform.putInt((Object)base, (long)this.pageCursor, (int)length);
        this.pageCursor += 4L;
        Platform.copyMemory((Object)recordBase, (long)recordOffset, (Object)base, (long)this.pageCursor, (long)length);
        this.pageCursor += (long)length;
        this.inMemSorter.insertRecord(recordAddress, partitionId);
    }

    public SpillInfo[] closeAndGetSpills() throws IOException {
        try {
            if (this.inMemSorter != null) {
                this.writeSortedFile(true);
                this.freeMemory();
                this.inMemSorter.free();
                this.inMemSorter = null;
            }
            return this.spills.toArray(new SpillInfo[this.spills.size()]);
        }
        catch (IOException e) {
            this.cleanupResources();
            throw e;
        }
    }
}

