/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.spark.SparkException;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.KryoDeserializationStream;
import org.apache.spark.serializer.KryoSerializationStream;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ec!B\u0001\u0003\u0001\u0011Q!AF&ss>\u001cVM]5bY&TXM]%ogR\fgnY3\u000b\u0005\r!\u0011AC:fe&\fG.\u001b>fe*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0005\u0002\u0001\u0017A\u0011A\"D\u0007\u0002\u0005%\u0011aB\u0001\u0002\u0013'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\:uC:\u001cW\r\u0003\u0005\u0011\u0001\t\u0005\t\u0015!\u0003\u0013\u0003\tY7o\u0001\u0001\u0011\u00051\u0019\u0012B\u0001\u000b\u0003\u00059Y%/_8TKJL\u0017\r\\5{KJDQA\u0006\u0001\u0005\u0002]\ta\u0001P5oSRtDC\u0001\r\u001a!\ta\u0001\u0001C\u0003\u0011+\u0001\u0007!\u0003\u0003\u0004\u001c\u0001\u0001\u0006K\u0001H\u0001\u000bG\u0006\u001c\u0007.\u001a3Lef|\u0007CA\u000f%\u001b\u0005q\"BA\u0010!\u0003\u0011Y'/_8\u000b\u0005\u0005\u0012\u0013\u0001E3t_R,'/[2t_\u001a$x/\u0019:f\u0015\u0005\u0019\u0013aA2p[&\u0011QE\b\u0002\u0005\u0017JLx\u000e\u000b\u0002\u001bOA\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u000bC:tw\u000e^1uS>t'\"\u0001\u0017\u0002\u000b)\fg/\u0019=\n\u00059J#\u0001\u0003(vY2\f'\r\\3\t\rA\u0002A\u0011\u0001\u00022\u0003)\u0011wN\u001d:po.\u0013\u0018p\u001c\u000b\u00029!11\u0007\u0001C\u0001\u0005Q\n1B]3mK\u0006\u001cXm\u0013:z_R\u0011Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0005+:LG\u000fC\u0003 e\u0001\u0007A\u0004\u0003\u0005>\u0001!\u0015\r\u0011\"\u0003?\u0003\u0019yW\u000f\u001e9viV\tq\b\u0005\u0002A\u00076\t\u0011I\u0003\u0002C=\u0005\u0011\u0011n\\\u0005\u0003\t\u0006\u0013aaT;uaV$\b\u0002\u0003$\u0001\u0011\u0003\u0005\u000b\u0015B \u0002\u000f=,H\u000f];uA!A\u0001\n\u0001EC\u0002\u0013%\u0011*A\u0003j]B,H/F\u0001K!\t\u00015*\u0003\u0002M\u0003\n)\u0011J\u001c9vi\"Aa\n\u0001E\u0001B\u0003&!*\u0001\u0004j]B,H\u000f\t\u0005\u0006!\u0002!\t%U\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016,\"A\u00154\u0015\u0005M{GC\u0001+]!\t)&,D\u0001W\u0015\t9\u0006,A\u0002oS>T\u0011!W\u0001\u0005U\u00064\u0018-\u0003\u0002\\-\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000fu{\u0015\u0011!a\u0002=\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u0007}\u0013G-D\u0001a\u0015\t\tw'A\u0004sK\u001adWm\u0019;\n\u0005\r\u0004'\u0001C\"mCN\u001cH+Y4\u0011\u0005\u00154G\u0002\u0001\u0003\u0006O>\u0013\r\u0001\u001b\u0002\u0002)F\u0011\u0011\u000e\u001c\t\u0003m)L!a[\u001c\u0003\u000f9{G\u000f[5oOB\u0011a'\\\u0005\u0003]^\u00121!\u00118z\u0011\u0015\u0001x\n1\u0001e\u0003\u0005!\b\"\u0002:\u0001\t\u0003\u001a\u0018a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016,\"\u0001^<\u0015\u0005U\\HC\u0001<y!\t)w\u000fB\u0003hc\n\u0007\u0001\u000eC\u0004zc\u0006\u0005\t9\u0001>\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007E\u0002`EZDQ\u0001`9A\u0002Q\u000bQAY=uKNDQA\u001d\u0001\u0005By,2a`A\u0003)\u0019\t\t!!\u0004\u0002\u0010Q!\u00111AA\u0004!\r)\u0017Q\u0001\u0003\u0006Ov\u0014\r\u0001\u001b\u0005\n\u0003\u0013i\u0018\u0011!a\u0002\u0003\u0017\t!\"\u001a<jI\u0016t7-\u001a\u00136!\u0011y&-a\u0001\t\u000bql\b\u0019\u0001+\t\u000f\u0005EQ\u00101\u0001\u0002\u0014\u00051An\\1eKJ\u0004B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033A\u0016\u0001\u00027b]\u001eLA!!\b\u0002\u0018\tY1\t\\1tg2{\u0017\rZ3s\u0011\u001d\t\t\u0003\u0001C!\u0003G\tqb]3sS\u0006d\u0017N_3TiJ,\u0017-\u001c\u000b\u0005\u0003K\tY\u0003E\u0002\r\u0003OI1!!\u000b\u0003\u0005M\u0019VM]5bY&T\u0018\r^5p]N#(/Z1n\u0011!\ti#a\bA\u0002\u0005=\u0012!A:\u0011\t\u0005E\u0012QG\u0007\u0003\u0003gQ!A\u0011-\n\t\u0005]\u00121\u0007\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003w\u0001A\u0011IA\u001f\u0003E!Wm]3sS\u0006d\u0017N_3TiJ,\u0017-\u001c\u000b\u0005\u0003\u007f\t)\u0005E\u0002\r\u0003\u0003J1!a\u0011\u0003\u0005U!Um]3sS\u0006d\u0017N_1uS>t7\u000b\u001e:fC6D\u0001\"!\f\u0002:\u0001\u0007\u0011q\t\t\u0005\u0003c\tI%\u0003\u0003\u0002L\u0005M\"aC%oaV$8\u000b\u001e:fC6Dq!a\u0014\u0001\t\u0003\t\t&\u0001\u0007hKR\fU\u000f^8SKN,G\u000f\u0006\u0002\u0002TA\u0019a'!\u0016\n\u0007\u0005]sGA\u0004C_>dW-\u00198")
public class KryoSerializerInstance
extends SerializerInstance {
    private final KryoSerializer ks;
    @Nullable
    private Kryo cachedKryo;
    private Output output;
    private Input input;
    private volatile byte bitmap$0;

    private Output output$lzycompute() {
        KryoSerializerInstance kryoSerializerInstance = this;
        synchronized (kryoSerializerInstance) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.output = this.ks.newKryoOutput();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.output;
        }
    }

    private Input input$lzycompute() {
        KryoSerializerInstance kryoSerializerInstance = this;
        synchronized (kryoSerializerInstance) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.input = new Input();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.input;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Kryo borrowKryo() {
        Kryo kryo;
        if (this.cachedKryo == null) {
            kryo = this.ks.newKryo();
        } else {
            void var1_1;
            Kryo kryo2 = this.cachedKryo;
            kryo2.reset();
            this.cachedKryo = null;
            kryo = var1_1;
        }
        return kryo;
    }

    public void releaseKryo(Kryo kryo) {
        if (this.cachedKryo == null) {
            this.cachedKryo = kryo;
        }
    }

    private Output output() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.output$lzycompute() : this.output;
    }

    private Input input() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.input$lzycompute() : this.input;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> ByteBuffer serialize(T t, ClassTag<T> evidence$3) {
        this.output().clear();
        Kryo kryo = this.borrowKryo();
        try {
            kryo.writeClassAndObject(this.output(), t);
            this.releaseKryo(kryo);
        }
        catch (Throwable throwable) {
            try {
                KryoException kryoException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof KryoException && (kryoException = (KryoException)throwable2).getMessage().startsWith("Buffer overflow")) {
                    throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kryo serialization failed: ", ". To avoid this, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kryoException.getMessage()}))).append((Object)"increase spark.kryoserializer.buffer.max value.").toString());
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                void var3_3;
                this.releaseKryo((Kryo)var3_3);
                throw throwable3;
            }
        }
        return ByteBuffer.wrap(this.output().toBytes());
    }

    @Override
    public <T> T deserialize(ByteBuffer bytes, ClassTag<T> evidence$4) {
        Kryo kryo = this.borrowKryo();
        try {
            this.input().setBuffer(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining());
            return (T)kryo.readClassAndObject(this.input());
        }
        finally {
            this.releaseKryo(kryo);
        }
    }

    @Override
    public <T> T deserialize(ByteBuffer bytes, ClassLoader loader, ClassTag<T> evidence$5) {
        Kryo kryo = this.borrowKryo();
        ClassLoader oldClassLoader = kryo.getClassLoader();
        try {
            kryo.setClassLoader(loader);
            this.input().setBuffer(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining());
            return (T)kryo.readClassAndObject(this.input());
        }
        finally {
            kryo.setClassLoader(oldClassLoader);
            this.releaseKryo(kryo);
        }
    }

    @Override
    public SerializationStream serializeStream(OutputStream s) {
        return new KryoSerializationStream(this, s);
    }

    @Override
    public DeserializationStream deserializeStream(InputStream s) {
        return new KryoDeserializationStream(this, s);
    }

    public boolean getAutoReset() {
        Field field = Kryo.class.getDeclaredField("autoReset");
        field.setAccessible(true);
        Kryo kryo = this.borrowKryo();
        try {
            return BoxesRunTime.unboxToBoolean((Object)field.get(kryo));
        }
        finally {
            this.releaseKryo(kryo);
        }
    }

    public KryoSerializerInstance(KryoSerializer ks) {
        this.ks = ks;
        this.cachedKryo = this.borrowKryo();
    }
}

