/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.ExecutorAllocationClient$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskState$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint$class;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.LossReasonPending$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SchedulerBackend$class;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.SlaveLost$;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.TaskDescription;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSetManager;
import org.apache.spark.scheduler.WorkerOffer;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$RegisteredExecutor$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$RetrieveSparkProps$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$ReviveOffers$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopDriver$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopExecutor$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopExecutors$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$DriverEndpoint$;
import org.apache.spark.scheduler.cluster.ExecutorData;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.SerializableBuffer;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\r\u0015f!B\u0001\u0003\u0001\u0019a!!H\"pCJ\u001cXm\u0012:bS:,GmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0003\u000b\u0019\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cR\u0001A\u0007\u0014/m\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005a)\u00050Z2vi>\u0014\u0018\t\u001c7pG\u0006$\u0018n\u001c8DY&,g\u000e\u001e\t\u00031ei\u0011\u0001B\u0005\u00035\u0011\u0011\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0005qyR\"A\u000f\u000b\u0005y1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0001j\"a\u0002'pO\u001eLgn\u001a\u0005\t\u000b\u0001\u0011\t\u0011)A\u0005G\r\u0001\u0001C\u0001\r%\u0013\t)CAA\tUCN\\7k\u00195fIVdWM]%na2D\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001K\u0001\u0007eB\u001cWI\u001c<\u0016\u0003%\u0002\"AK\u0017\u000e\u0003-R!\u0001\f\u0004\u0002\u0007I\u00048-\u0003\u0002/W\t1!\u000b]2F]ZD\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!K\u0001\beB\u001cWI\u001c<!\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q\u0019AGN\u001c\u0011\u0005U\u0002Q\"\u0001\u0002\t\u000b\u0015\t\u0004\u0019A\u0012\t\u000b\u001d\n\u0004\u0019A\u0015\t\u000fe\u0002!\u0019!C\tu\u0005qAo\u001c;bY\u000e{'/Z\"pk:$X#A\u001e\u0011\u0005q*U\"A\u001f\u000b\u0005yz\u0014AB1u_6L7M\u0003\u0002A\u0003\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\t\u001b\u0015\u0001B;uS2T\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G{\ti\u0011\t^8nS\u000eLe\u000e^3hKJDa\u0001\u0013\u0001!\u0002\u0013Y\u0014a\u0004;pi\u0006d7i\u001c:f\u0007>,h\u000e\u001e\u0011\t\u000f)\u0003!\u0019!C\tu\u0005ABo\u001c;bYJ+w-[:uKJ,G-\u0012=fGV$xN]:\t\r1\u0003\u0001\u0015!\u0003<\u0003e!x\u000e^1m%\u0016<\u0017n\u001d;fe\u0016$W\t_3dkR|'o\u001d\u0011\t\u000f9\u0003!\u0019!C\t\u001f\u0006!1m\u001c8g+\u0005\u0001\u0006C\u0001\u000bR\u0013\t\u0011fAA\u0005Ta\u0006\u00148nQ8oM\"1A\u000b\u0001Q\u0001\nA\u000bQaY8oM\u0002BqA\u0016\u0001C\u0002\u0013%q+A\tnCb\u0014\u0006oY'fgN\fw-Z*ju\u0016,\u0012\u0001\u0017\t\u0003\u001deK!AW\b\u0003\u0007%sG\u000f\u0003\u0004]\u0001\u0001\u0006I\u0001W\u0001\u0013[\u0006D(\u000b]2NKN\u001c\u0018mZ3TSj,\u0007\u0005C\u0004_\u0001\t\u0007I\u0011B0\u0002#\u0011,g-Y;mi\u0006\u001b8\u000eV5nK>,H/F\u0001a!\tQ\u0013-\u0003\u0002cW\tQ!\u000b]2US6,w.\u001e;\t\r\u0011\u0004\u0001\u0015!\u0003a\u0003I!WMZ1vYR\f5o\u001b+j[\u0016|W\u000f\u001e\u0011\t\u000f\u0019\u0004!\u0019!C\u0005O\u0006\u0019r,\\5o%\u0016<\u0017n\u001d;fe\u0016$'+\u0019;j_V\t\u0001\u000e\u0005\u0002\u000fS&\u0011!n\u0004\u0002\u0007\t>,(\r\\3\t\r1\u0004\u0001\u0015!\u0003i\u0003QyV.\u001b8SK\u001eL7\u000f^3sK\u0012\u0014\u0016\r^5pA!9a\u000e\u0001b\u0001\n\u0013y\u0017AG7bqJ+w-[:uKJ,GmV1ji&tw\rV5nK6\u001bX#\u00019\u0011\u00059\t\u0018B\u0001:\u0010\u0005\u0011auN\\4\t\rQ\u0004\u0001\u0015!\u0003q\u0003mi\u0017\r\u001f*fO&\u001cH/\u001a:fI^\u000b\u0017\u000e^5oORKW.Z'tA!9a\u000f\u0001b\u0001\n\u0013y\u0017AC2sK\u0006$X\rV5nK\"1\u0001\u0010\u0001Q\u0001\nA\f1b\u0019:fCR,G+[7fA!9!\u0010\u0001b\u0001\n\u0013Y\u0018aD3yK\u000e,Ho\u001c:ECR\fW*\u00199\u0016\u0003q\u0004r!`A\u0003\u0003\u0013\t9\"D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019aD\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0004}\n9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA\u0006\u0003#q1ADA\u0007\u0013\r\tyaD\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0011Q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=q\u0002E\u00026\u00033I1!a\u0007\u0003\u00051)\u00050Z2vi>\u0014H)\u0019;b\u0011\u001d\ty\u0002\u0001Q\u0001\nq\f\u0001#\u001a=fGV$xN\u001d#bi\u0006l\u0015\r\u001d\u0011\t\u0011\u0005\r\u0002\u00011A\u0005\n]\u000b1C\\;n!\u0016tG-\u001b8h\u000bb,7-\u001e;peND\u0011\"a\n\u0001\u0001\u0004%I!!\u000b\u0002/9,X\u000eU3oI&tw-\u0012=fGV$xN]:`I\u0015\fH\u0003BA\u0016\u0003c\u00012ADA\u0017\u0013\r\tyc\u0004\u0002\u0005+:LG\u000fC\u0005\u00024\u0005\u0015\u0012\u0011!a\u00011\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005]\u0002\u0001)Q\u00051\u0006!b.^7QK:$\u0017N\\4Fq\u0016\u001cW\u000f^8sg\u0002B\u0003\"!\u000e\u0002<\u00055\u0013q\n\t\u0005\u0003{\tI%\u0004\u0002\u0002@)\u0019\u0001)!\u0011\u000b\t\u0005\r\u0013QI\u0001\u000bC:tw\u000e^1uS>t'BAA$\u0003\u0015Q\u0017M^1y\u0013\u0011\tY%a\u0010\u0003\u0013\u001d+\u0018M\u001d3fI\nK\u0018!\u0002<bYV,\u0017EAA)\u0003\t\u001au.\u0019:tK\u001e\u0013\u0018-\u001b8fIN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$g\u0006\u001e5jg\"I\u0011Q\u000b\u0001C\u0002\u0013%\u0011qK\u0001\fY&\u001cH/\u001a8fe\n+8/\u0006\u0002\u0002ZA\u0019\u0001$a\u0017\n\u0007\u0005uCAA\bMSZ,G*[:uK:,'OQ;t\u0011!\t\t\u0007\u0001Q\u0001\n\u0005e\u0013\u0001\u00047jgR,g.\u001a:CkN\u0004\u0003\"CA3\u0001\t\u0007I\u0011BA4\u0003a)\u00070Z2vi>\u00148\u000fU3oI&tw\rV8SK6|g/Z\u000b\u0003\u0003S\u0002r!`A\u0003\u0003\u0013\tY\u0007E\u0002\u000f\u0003[J1!a\u001c\u0010\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u001d\u0001A\u0003%\u0011\u0011N\u0001\u001aKb,7-\u001e;peN\u0004VM\u001c3j]\u001e$vNU3n_Z,\u0007\u0005\u000b\u0005\u0002r\u0005m\u0012QJA(\u0011%\tI\b\u0001a\u0001\n#\tY(\u0001\u000bi_N$Hk\u001c'pG\u0006dG+Y:l\u0007>,h\u000e^\u000b\u0003\u0003{\u0002r!a\u0003\u0002\u0000\u0005%\u0001,\u0003\u0003\u0002\u0002\u0006U!aA'ba\"I\u0011Q\u0011\u0001A\u0002\u0013E\u0011qQ\u0001\u0019Q>\u001cH\u000fV8M_\u000e\fG\u000eV1tW\u000e{WO\u001c;`I\u0015\fH\u0003BA\u0016\u0003\u0013C!\"a\r\u0002\u0004\u0006\u0005\t\u0019AA?\u0011!\ti\t\u0001Q!\n\u0005u\u0014!\u00065pgR$v\u000eT8dC2$\u0016m]6D_VtG\u000f\t\u0015\t\u0003\u0017\u000bY$!\u0014\u0002P!A\u00111\u0013\u0001A\u0002\u0013Eq+\u0001\nm_\u000e\fG.\u001b;z\u0003^\f'/\u001a+bg.\u001c\b\"CAL\u0001\u0001\u0007I\u0011CAM\u0003YawnY1mSRL\u0018i^1sKR\u000b7o[:`I\u0015\fH\u0003BA\u0016\u00037C\u0011\"a\r\u0002\u0016\u0006\u0005\t\u0019\u0001-\t\u000f\u0005}\u0005\u0001)Q\u00051\u0006\u0019Bn\\2bY&$\u00180Q<be\u0016$\u0016m]6tA!B\u0011QTA\u001e\u0003\u001b\ny\u0005\u0003\u0005\u0002&\u0002\u0001\r\u0011\"\u0005X\u0003a\u0019WO\u001d:f]R,\u00050Z2vi>\u0014\u0018\nZ\"pk:$XM\u001d\u0005\n\u0003S\u0003\u0001\u0019!C\t\u0003W\u000bAdY;se\u0016tG/\u0012=fGV$xN]%e\u0007>,h\u000e^3s?\u0012*\u0017\u000f\u0006\u0003\u0002,\u00055\u0006\"CA\u001a\u0003O\u000b\t\u00111\u0001Y\u0011\u001d\t\t\f\u0001Q!\na\u000b\u0011dY;se\u0016tG/\u0012=fGV$xN]%e\u0007>,h\u000e^3sA!\"\u0011qVA[!\rq\u0011qW\u0005\u0004\u0003s{!\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0007\r\u0005u\u0006\u0001AA`\u00059!%/\u001b<fe\u0016sG\r]8j]R\u001cb!a/\u000e\u0003\u0003\\\u0002c\u0001\u0016\u0002D&\u0019\u0011QY\u0016\u0003+QC'/Z1e'\u00064WM\u00159d\u000b:$\u0007o\\5oi\"Iq%a/\u0003\u0006\u0004%\t\u0005\u000b\u0005\na\u0005m&\u0011!Q\u0001\n%B1\"!4\u0002<\n\u0005\t\u0015!\u0003\u0002P\u0006y1\u000f]1sWB\u0013x\u000e]3si&,7\u000f\u0005\u0004\u0002R\u0006\u0005\u0018q\u001d\b\u0005\u0003'\fiN\u0004\u0003\u0002V\u0006mWBAAl\u0015\r\tINI\u0001\u0007yI|w\u000e\u001e \n\u0003AI1!a8\u0010\u0003\u001d\u0001\u0018mY6bO\u0016LA!a9\u0002f\n\u00191+Z9\u000b\u0007\u0005}w\u0002E\u0004\u000f\u0003S\fI!!\u0003\n\u0007\u0005-xB\u0001\u0004UkBdWM\r\u0005\be\u0005mF\u0011AAx)\u0019\t\t0!>\u0002xB!\u00111_A^\u001b\u0005\u0001\u0001BB\u0014\u0002n\u0002\u0007\u0011\u0006\u0003\u0005\u0002N\u00065\b\u0019AAh\u0011)\tY0a/C\u0002\u0013E\u0011Q`\u0001\u001bKb,7-\u001e;peN\u0004VM\u001c3j]\u001edun]:SK\u0006\u001cxN\\\u000b\u0003\u0003\u007f\u0004R! B\u0001\u0003\u0013I1Aa\u0001\u007f\u0005\u001dA\u0015m\u001d5TKRD\u0011Ba\u0002\u0002<\u0002\u0006I!a@\u00027\u0015DXmY;u_J\u001c\b+\u001a8eS:<Gj\\:t%\u0016\f7o\u001c8!\u0011)\u0011Y!a/C\u0002\u0013%!QB\u0001\u0004g\u0016\u0014XC\u0001B\b!\u0011\u0011\tBa\u0006\u000e\u0005\tM!b\u0001B\u000b\r\u0005Q1/\u001a:jC2L'0\u001a:\n\t\te!1\u0003\u0002\u0013'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\:uC:\u001cW\rC\u0005\u0003\u001e\u0005m\u0006\u0015!\u0003\u0003\u0010\u0005!1/\u001a:!\u0011)\u0011\t#a/C\u0002\u0013E!1E\u0001\u0014C\u0012$'/Z:t)>,\u00050Z2vi>\u0014\u0018\nZ\u000b\u0003\u0005K\u0001r!`A\u0003\u0005O\tI\u0001E\u0002+\u0005SI1Aa\u000b,\u0005)\u0011\u0006oY!eIJ,7o\u001d\u0005\n\u0005_\tY\f)A\u0005\u0005K\tA#\u00193ee\u0016\u001c8\u000fV8Fq\u0016\u001cW\u000f^8s\u0013\u0012\u0004\u0003B\u0003B\u001a\u0003w\u0013\r\u0011\"\u0003\u00036\u0005a!/\u001a<jm\u0016$\u0006N]3bIV\u0011!q\u0007\t\u0005\u0005s\u0011Y$D\u0001@\u0013\r\u0011id\u0010\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007\"\u0003B!\u0003w\u0003\u000b\u0011\u0002B\u001c\u00035\u0011XM^5wKRC'/Z1eA!A!QIA^\t\u0003\u00129%A\u0004p]N#\u0018M\u001d;\u0015\u0005\u0005-\u0002\u0002\u0003B&\u0003w#\tE!\u0014\u0002\u000fI,7-Z5wKV\u0011!q\n\t\b\u001d\tE#QKA\u0016\u0013\r\u0011\u0019f\u0004\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B\u0019aBa\u0016\n\u0007\tesBA\u0002B]fD\u0001B!\u0018\u0002<\u0012\u0005#qL\u0001\u0010e\u0016\u001cW-\u001b<f\u0003:$'+\u001a9msR!!q\nB1\u0011!\u0011\u0019Ga\u0017A\u0002\t\u0015\u0014aB2p]R,\u0007\u0010\u001e\t\u0004U\t\u001d\u0014b\u0001B5W\tq!\u000b]2DC2d7i\u001c8uKb$\b\u0002\u0003B7\u0003w#IAa\u0012\u0002\u00155\f7.Z(gM\u0016\u00148\u000f\u0003\u0005\u0003r\u0005mF\u0011\tB:\u00039yg\u000eR5tG>tg.Z2uK\u0012$B!a\u000b\u0003v!A!q\u000fB8\u0001\u0004\u00119#A\u0007sK6|G/Z!eIJ,7o\u001d\u0005\t\u0005[\nY\f\"\u0003\u0003|Q!\u00111\u0006B?\u0011!\u0011yH!\u001fA\u0002\u0005%\u0011AC3yK\u000e,Ho\u001c:JI\"A!1QA^\t\u0013\u0011))A\bfq\u0016\u001cW\u000f^8s\u0013N\fE.\u001b<f)\u0011\tYGa\"\t\u0011\t}$\u0011\u0011a\u0001\u0003\u0013A\u0001Ba#\u0002<\u0012%!QR\u0001\fY\u0006,hn\u00195UCN\\7\u000f\u0006\u0003\u0002,\t=\u0005\u0002\u0003BI\u0005\u0013\u0003\rAa%\u0002\u000bQ\f7o[:\u0011\r\u0005E\u0017\u0011\u001dBK!\u0019\t\t.!9\u0003\u0018B\u0019\u0001D!'\n\u0007\tmEAA\bUCN\\G)Z:de&\u0004H/[8o\u0011!\u0011y*a/\u0005\n\t\u0005\u0016A\u0004:f[>4X-\u0012=fGV$xN\u001d\u000b\u0007\u0003W\u0011\u0019K!*\t\u0011\t}$Q\u0014a\u0001\u0003\u0013A\u0001Ba*\u0003\u001e\u0002\u0007!\u0011V\u0001\u0007e\u0016\f7o\u001c8\u0011\u0007a\u0011Y+C\u0002\u0003.\u0012\u0011!#\u0012=fGV$xN\u001d'pgN\u0014V-Y:p]\"A!\u0011WA^\t#\u0011\u0019,A\beSN\f'\r\\3Fq\u0016\u001cW\u000f^8s)\u0011\tYG!.\t\u0011\t}$q\u0016a\u0001\u0003\u0013A\u0001B!/\u0002<\u0012\u0005#qI\u0001\u0007_:\u001cFo\u001c9\t\u0013\tu\u0006\u00011A\u0005\u0002\t}\u0016A\u00043sSZ,'/\u00128ea>Lg\u000e^\u000b\u0003\u0005\u0003\u00042A\u000bBb\u0013\r\u0011)m\u000b\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011%\u0011I\r\u0001a\u0001\n\u0003\u0011Y-\u0001\nee&4XM]#oIB|\u0017N\u001c;`I\u0015\fH\u0003BA\u0016\u0005\u001bD!\"a\r\u0003H\u0006\u0005\t\u0019\u0001Ba\u0011!\u0011\t\u000e\u0001Q!\n\t\u0005\u0017a\u00043sSZ,'/\u00128ea>Lg\u000e\u001e\u0011\t\r\tU\u0007\u0001\"\u0005h\u0003Ii\u0017N\u001c*fO&\u001cH/\u001a:fIJ\u000bG/[8\t\u000f\te\u0007\u0001\"\u0011\u0003H\u0005)1\u000f^1si\"9!Q\u001c\u0001\u0005\u0012\t}\u0017aF2sK\u0006$X\r\u0012:jm\u0016\u0014XI\u001c3q_&tGOU3g)\u0011\u0011\tM!9\t\u0011\t\r(1\u001ca\u0001\u0005K\f!\u0002\u001d:pa\u0016\u0014H/[3t!\u0015i(q]At\u0013\r\u0011IO \u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fC\u0004\u0003n\u0002!\tBa<\u0002)\r\u0014X-\u0019;f\tJLg/\u001a:F]\u0012\u0004x.\u001b8u)\u0011\t\tP!=\t\u0011\t\r(1\u001ea\u0001\u0003\u001fDqA!>\u0001\t\u0003\u00119%A\u0007ti>\u0004X\t_3dkR|'o\u001d\u0005\b\u0005s\u0004A\u0011\tB$\u0003\u0011\u0019Ho\u001c9\t\u000f\tu\b\u0001\"\u0005\u0003H\u0005)!/Z:fi\"91\u0011\u0001\u0001\u0005B\t\u001d\u0013\u0001\u0004:fm&4Xm\u00144gKJ\u001c\bbBB\u0003\u0001\u0011\u00053qA\u0001\tW&dG\u000eV1tWRA\u00111FB\u0005\u0007\u001b\u0019y\u0001C\u0004\u0004\f\r\r\u0001\u0019\u00019\u0002\rQ\f7o[%e\u0011!\u0011yha\u0001A\u0002\u0005%\u0001\u0002CB\t\u0007\u0007\u0001\r!a\u001b\u0002\u001f%tG/\u001a:skB$H\u000b\u001b:fC\u0012Dqa!\u0006\u0001\t\u0003\u001a9\"\u0001\neK\u001a\fW\u000f\u001c;QCJ\fG\u000e\\3mSNlG#\u0001-\t\u000f\t}\u0005\u0001\"\u0005\u0004\u001cQ1\u00111FB\u000f\u0007?A\u0001Ba \u0004\u001a\u0001\u0007\u0011\u0011\u0002\u0005\t\u0005O\u001bI\u00021\u0001\u0003*\"911\u0005\u0001\u0005\u0002\r\u0015\u0012!H:vM\u001aL7-[3oiJ+7o\\;sG\u0016\u001c(+Z4jgR,'/\u001a3\u0015\u0005\u0005-\u0004bBB\u0015\u0001\u0011\u00053QE\u0001\bSN\u0014V-\u00193z\u0011\u0019\u0019i\u0003\u0001C\u0005/\u0006!b.^7Fq&\u001cH/\u001b8h\u000bb,7-\u001e;peNDqa!\r\u0001\t\u0003\u001a\u0019$\u0001\bhKR,\u00050Z2vi>\u0014\u0018\nZ:\u0015\u0005\rU\u0002CBAi\u0003C\fI\u0001C\u0004\u0004:\u0001!)ea\u000f\u0002!I,\u0017/^3ti\u0016CXmY;u_J\u001cH\u0003BA6\u0007{Aqaa\u0010\u00048\u0001\u0007\u0001,\u0001\fok6\fE\rZ5uS>t\u0017\r\\#yK\u000e,Ho\u001c:t\u0011\u001d\u0019\u0019\u0005\u0001C#\u0007\u000b\nQC]3rk\u0016\u001cH\u000fV8uC2,\u00050Z2vi>\u00148\u000f\u0006\u0005\u0002l\r\u001d31JB'\u0011\u001d\u0019Ie!\u0011A\u0002a\u000bAB\\;n\u000bb,7-\u001e;peNDq!a%\u0004B\u0001\u0007\u0001\f\u0003\u0005\u0002z\r\u0005\u0003\u0019AA?\u0011\u001d\u0019\t\u0006\u0001C\t\u0007'\nq\u0003Z8SKF,Xm\u001d;U_R\fG.\u0012=fGV$xN]:\u0015\t\rU3q\f\t\u0007\u0007/\u001aY&a\u001b\u000e\u0005\re#B\u0001!\u0010\u0013\u0011\u0019if!\u0017\u0003\r\u0019+H/\u001e:f\u0011\u001d\u0019\tga\u0014A\u0002a\u000baB]3rk\u0016\u001cH/\u001a3U_R\fG\u000eC\u0004\u0004f\u0001!)ea\u001a\u0002\u001b-LG\u000e\\#yK\u000e,Ho\u001c:t)\u0011\tYg!\u001b\t\u0011\r-41\ra\u0001\u0007k\t1\"\u001a=fGV$xN]%eg\"91Q\r\u0001\u0005\u0006\r=D\u0003CA6\u0007c\u001a\u0019ha\u001e\t\u0011\r-4Q\u000ea\u0001\u0007kA\u0001b!\u001e\u0004n\u0001\u0007\u00111N\u0001\be\u0016\u0004H.Y2f\u0011!\u0019Ih!\u001cA\u0002\u0005-\u0014!\u00024pe\u000e,\u0007bBB?\u0001\u0011E1qP\u0001\u0010I>\\\u0015\u000e\u001c7Fq\u0016\u001cW\u000f^8sgR!1QKBA\u0011!\u0019Yga\u001fA\u0002\rUr\u0001CBC\u0005!\u0005aaa\"\u0002;\r{\u0017M]:f\u000fJ\f\u0017N\\3e'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u00042!NBE\r\u001d\t!\u0001#\u0001\u0007\u0007\u0017\u001b2a!#\u000e\u0011\u001d\u00114\u0011\u0012C\u0001\u0007\u001f#\"aa\"\t\u0015\rM5\u0011\u0012b\u0001\n\u0003\u0019)*A\u0007F\u001d\u0012\u0003v*\u0013(U?:\u000bU*R\u000b\u0003\u0007/\u0003Ba!'\u0004 6\u001111\u0014\u0006\u0004\u0007;\u001b\u0015\u0001\u00027b]\u001eLA!a\u0005\u0004\u001c\"I11UBEA\u0003%1qS\u0001\u000f\u000b:#\u0005kT%O)~s\u0015)T#!\u0001")
public class CoarseGrainedSchedulerBackend
implements ExecutorAllocationClient,
SchedulerBackend,
Logging {
    public final TaskSchedulerImpl org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler;
    private final RpcEnv rpcEnv;
    private final AtomicInteger totalCoreCount;
    private final AtomicInteger totalRegisteredExecutors;
    private final SparkConf conf;
    private final int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize;
    private final RpcTimeout defaultAskTimeout;
    private final double _minRegisteredRatio;
    private final long org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs;
    private final long createTime;
    private final HashMap<String, ExecutorData> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors;
    private final LiveListenerBus org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private final HashMap<String, Object> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private scala.collection.immutable.Map<String, Object> hostToLocalTaskCount;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private int localityAwareTasks;
    private volatile int currentExecutorIdCounter;
    private RpcEndpointRef driverEndpoint;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private final String org$apache$spark$scheduler$SchedulerBackend$$appId;

    public static String ENDPOINT_NAME() {
        return CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public String org$apache$spark$scheduler$SchedulerBackend$$appId() {
        return this.org$apache$spark$scheduler$SchedulerBackend$$appId;
    }

    @Override
    public void org$apache$spark$scheduler$SchedulerBackend$_setter_$org$apache$spark$scheduler$SchedulerBackend$$appId_$eq(String x$1) {
        this.org$apache$spark$scheduler$SchedulerBackend$$appId = x$1;
    }

    @Override
    public String applicationId() {
        return SchedulerBackend$class.applicationId(this);
    }

    @Override
    public Option<String> applicationAttemptId() {
        return SchedulerBackend$class.applicationAttemptId(this);
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> getDriverLogUrls() {
        return SchedulerBackend$class.getDriverLogUrls(this);
    }

    @Override
    public boolean killExecutor(String executorId) {
        return ExecutorAllocationClient$class.killExecutor(this, executorId);
    }

    public RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    public AtomicInteger totalCoreCount() {
        return this.totalCoreCount;
    }

    public AtomicInteger totalRegisteredExecutors() {
        return this.totalRegisteredExecutors;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize;
    }

    private RpcTimeout defaultAskTimeout() {
        return this.defaultAskTimeout;
    }

    private double _minRegisteredRatio() {
        return this._minRegisteredRatio;
    }

    public long org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs;
    }

    private long createTime() {
        return this.createTime;
    }

    public HashMap<String, ExecutorData> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap;
    }

    public int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors;
    }

    public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(int x$1) {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors = x$1;
    }

    public LiveListenerBus org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus;
    }

    public HashMap<String, Object> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove;
    }

    public scala.collection.immutable.Map<String, Object> hostToLocalTaskCount() {
        return this.hostToLocalTaskCount;
    }

    public void hostToLocalTaskCount_$eq(scala.collection.immutable.Map<String, Object> x$1) {
        this.hostToLocalTaskCount = x$1;
    }

    public int localityAwareTasks() {
        return this.localityAwareTasks;
    }

    public void localityAwareTasks_$eq(int x$1) {
        this.localityAwareTasks = x$1;
    }

    public int currentExecutorIdCounter() {
        return this.currentExecutorIdCounter;
    }

    public void currentExecutorIdCounter_$eq(int x$1) {
        this.currentExecutorIdCounter = x$1;
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public double minRegisteredRatio() {
        return this._minRegisteredRatio();
    }

    @Override
    public void start() {
        ArrayBuffer properties = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.sc().conf().getAll()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$2) {
                Tuple2<String, String> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, properties){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer properties$1;

            public final Object apply(Tuple2<String, String> x$5) {
                Tuple2<String, String> tuple2 = x$5;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value2 = (String)tuple2._2();
                    BoxedUnit boxedUnit = key.startsWith("spark.") ? this.properties$1.$plus$eq((Object)new Tuple2((Object)key, (Object)value2)) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.properties$1 = properties$1;
            }
        });
        this.driverEndpoint_$eq(this.createDriverEndpointRef((ArrayBuffer<Tuple2<String, String>>)properties));
    }

    public RpcEndpointRef createDriverEndpointRef(ArrayBuffer<Tuple2<String, String>> properties) {
        return this.rpcEnv().setupEndpoint(CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME(), this.createDriverEndpoint((Seq<Tuple2<String, String>>)properties));
    }

    public DriverEndpoint createDriverEndpoint(Seq<Tuple2<String, String>> properties) {
        return new DriverEndpoint(this, this.rpcEnv(), properties);
    }

    public void stopExecutors() {
        try {
            if (this.driverEndpoint() != null) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Shutting down all executors";
                    }
                });
                this.driverEndpoint().askWithRetry(CoarseGrainedClusterMessages$StopExecutors$.MODULE$, ClassTag$.MODULE$.Boolean());
            }
            return;
        }
        catch (Exception exception2) {
            throw new SparkException("Error asking standalone scheduler to shut down executors", exception2);
        }
    }

    @Override
    public void stop() {
        this.stopExecutors();
        try {
            if (this.driverEndpoint() != null) {
                this.driverEndpoint().askWithRetry(CoarseGrainedClusterMessages$StopDriver$.MODULE$, ClassTag$.MODULE$.Boolean());
            }
            return;
        }
        catch (Exception exception2) {
            throw new SparkException("Error stopping standalone scheduler's driver endpoint", exception2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        Set set;
        CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this;
        synchronized (coarseGrainedSchedulerBackend) {
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(0);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().clear();
            set = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().keys());
        }
        scala.collection.immutable.Set executors = (scala.collection.immutable.Set)set;
        executors.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

            public final void apply(String eid) {
                this.$outer.removeExecutor(eid, new SlaveLost("Stale executor after cluster manager re-registered.", SlaveLost$.MODULE$.apply$default$2()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void reviveOffers() {
        this.driverEndpoint().send(CoarseGrainedClusterMessages$ReviveOffers$.MODULE$);
    }

    @Override
    public void killTask(long taskId, String executorId, boolean interruptThread) {
        this.driverEndpoint().send(new CoarseGrainedClusterMessages.KillTask(taskId, executorId, interruptThread));
    }

    @Override
    public int defaultParallelism() {
        return this.conf().getInt("spark.default.parallelism", package$.MODULE$.max(this.totalCoreCount().get(), 2));
    }

    public void removeExecutor(String executorId, ExecutorLossReason reason) {
        this.driverEndpoint().ask(new CoarseGrainedClusterMessages.RemoveExecutor(executorId, reason), ClassTag$.MODULE$.Boolean()).onFailure((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                this.$outer.logError((Function0<String>)new Serializable(this, A1){
                    public static final long serialVersionUID = 0L;
                    private final Throwable x1$1;

                    public final String apply() {
                        return this.x1$1.getMessage();
                    }
                    {
                        this.x1$1 = x1$1;
                    }
                }, A1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public boolean sufficientResourcesRegistered() {
        return true;
    }

    @Override
    public boolean isReady() {
        if (this.sufficientResourcesRegistered()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"SchedulerBackend is ready for scheduling beginning after ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reached minRegisteredResourcesRatio: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.minRegisteredRatio())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return true;
        }
        if (System.currentTimeMillis() - this.createTime() >= this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"SchedulerBackend is ready for scheduling beginning after waiting ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxRegisteredResourcesWaitingTime: ", "(ms)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return true;
        }
        return false;
    }

    private int numExistingExecutors() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().size();
    }

    @Override
    public Seq<String> getExecutorIds() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().keySet().toSeq();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean requestExecutors(int numAdditionalExecutors) {
        if (numAdditionalExecutors < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Attempted to request a negative number of additional executor(s) ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " from the cluster manager. Please specify a positive number!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numAdditionalExecutors)}))).toString());
        }
        this.logInfo((Function0<String>)new Serializable(this, numAdditionalExecutors){
            public static final long serialVersionUID = 0L;
            private final int numAdditionalExecutors$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting ", " additional executor(s) from the cluster manager"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numAdditionalExecutors$1)}));
            }
            {
                this.numAdditionalExecutors$1 = numAdditionalExecutors$1;
            }
        });
        CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this;
        synchronized (coarseGrainedSchedulerBackend) {
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() + numAdditionalExecutors);
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of pending executors is now ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Future<Object> future = this.doRequestTotalExecutors(this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : coarseGrainedSchedulerBackend
            Future<Object> response = future;
            return BoxesRunTime.unboxToBoolean((Object)this.defaultAskTimeout().awaitResult(response));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean requestTotalExecutors(int numExecutors2, int localityAwareTasks, scala.collection.immutable.Map<String, Object> hostToLocalTaskCount) {
        if (numExecutors2 < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Attempted to request a negative number of executor(s) ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " from the cluster manager. Please specify a positive number!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numExecutors2)}))).toString());
        }
        CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this;
        synchronized (coarseGrainedSchedulerBackend) {
            this.localityAwareTasks_$eq(localityAwareTasks);
            this.hostToLocalTaskCount_$eq(hostToLocalTaskCount);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(package$.MODULE$.max(numExecutors2 - this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size(), 0));
            Future<Object> future = this.doRequestTotalExecutors(numExecutors2);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : coarseGrainedSchedulerBackend
            Future<Object> response = future;
            return BoxesRunTime.unboxToBoolean((Object)this.defaultAskTimeout().awaitResult(response));
        }
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public final boolean killExecutors(Seq<String> executorIds) {
        return this.killExecutors(executorIds, false, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean killExecutors(Seq<String> executorIds, boolean replace, boolean force) {
        this.logInfo((Function0<String>)new Serializable(this, executorIds){
            public static final long serialVersionUID = 0L;
            private final Seq executorIds$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting to kill executor(s) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorIds$1.mkString(", ")}));
            }
            {
                this.executorIds$1 = executorIds$1;
            }
        });
        CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this;
        synchronized (coarseGrainedSchedulerBackend) {
            Future<Object> future;
            Tuple2 tuple2;
            Tuple2 tuple22 = executorIds.partition((Function1)new $anonfun$5(this));
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Seq knownExecutors = (Seq)tuple22._1();
            Seq unknownExecutors = (Seq)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)knownExecutors, (Object)unknownExecutors);
            Seq knownExecutors2 = (Seq)tuple23._1();
            Seq unknownExecutors2 = (Seq)tuple23._2();
            unknownExecutors2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final void apply(String id) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this, id){
                        public static final long serialVersionUID = 0L;
                        private final String id$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor to kill ", " does not exist!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1}));
                        }
                        {
                            this.id$1 = id$1;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Seq executorsToKill = (Seq)((TraversableLike)knownExecutors2.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final boolean apply(String id) {
                    return !this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)id);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            })).filter((Function1)new Serializable(this, force){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;
                private final boolean force$1;

                public final boolean apply(String id) {
                    return this.force$1 || !this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.isExecutorBusy(id);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.force$1 = force$1;
                }
            });
            executorsToKill.foreach((Function1)new Serializable(this, replace){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;
                private final boolean replace$1;

                public final void apply(String id) {
                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().update((Object)id, (Object)BoxesRunTime.boxToBoolean((!this.replace$1 ? 1 : 0) != 0));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.replace$1 = replace$1;
                }
            });
            if (replace) {
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() + knownExecutors2.size());
                future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                future = this.doRequestTotalExecutors(this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size());
            }
            Future<Object> adjustTotalExecutors = future;
            Object object = executorsToKill.isEmpty() ? new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Future<Object> apply(boolean x$8) {
                    return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
            } : new Serializable(this, executorsToKill){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;
                private final Seq executorsToKill$1;

                public final Future<Object> apply(boolean x$7) {
                    return this.$outer.doKillExecutors((Seq<String>)this.executorsToKill$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.executorsToKill$1 = executorsToKill$1;
                }
            };
            Future future2 = adjustTotalExecutors.flatMap((Function1)object, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl23 : MonitorExitStatement: MONITOREXIT : var4_4
            Future response = future2;
            return BoxesRunTime.unboxToBoolean(this.defaultAskTimeout().awaitResult(response));
        }
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public CoarseGrainedSchedulerBackend(TaskSchedulerImpl scheduler, RpcEnv rpcEnv) {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler = scheduler;
        this.rpcEnv = rpcEnv;
        ExecutorAllocationClient$class.$init$(this);
        SchedulerBackend$class.$init$(this);
        Logging$class.$init$(this);
        this.totalCoreCount = new AtomicInteger(0);
        this.totalRegisteredExecutors = new AtomicInteger(0);
        this.conf = scheduler.sc().conf();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize = RpcUtils$.MODULE$.maxMessageSizeBytes(this.conf());
        this.defaultAskTimeout = RpcUtils$.MODULE$.askRpcTimeout(this.conf());
        this._minRegisteredRatio = package$.MODULE$.min(1.0, this.conf().getDouble("spark.scheduler.minRegisteredResourcesRatio", 0.0));
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs = this.conf().getTimeAsMs("spark.scheduler.maxRegisteredResourcesWaitingTime", "30s");
        this.createTime = System.currentTimeMillis();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap = new HashMap();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors = 0;
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus = scheduler.sc().listenerBus();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove = new HashMap();
        this.hostToLocalTaskCount = Predef$.MODULE$.Map().empty();
        this.localityAwareTasks = 0;
        this.currentExecutorIdCounter = 0;
        this.driverEndpoint = null;
    }

    public class DriverEndpoint
    implements ThreadSafeRpcEndpoint,
    Logging {
        private final RpcEnv rpcEnv;
        public final Seq<Tuple2<String, String>> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties;
        private final HashSet<String> executorsPendingLossReason;
        private final SerializerInstance org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser;
        private final HashMap<RpcAddress, String> addressToExecutorId;
        private final ScheduledExecutorService reviveThread;
        public final /* synthetic */ CoarseGrainedSchedulerBackend $outer;
        private transient Logger org$apache$spark$internal$Logging$$log_;

        @Override
        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        @Override
        @TraitSetter
        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        @Override
        public String logName() {
            return Logging$class.logName(this);
        }

        @Override
        public Logger log() {
            return Logging$class.log(this);
        }

        @Override
        public void logInfo(Function0<String> msg) {
            Logging$class.logInfo(this, msg);
        }

        @Override
        public void logDebug(Function0<String> msg) {
            Logging$class.logDebug(this, msg);
        }

        @Override
        public void logTrace(Function0<String> msg) {
            Logging$class.logTrace(this, msg);
        }

        @Override
        public void logWarning(Function0<String> msg) {
            Logging$class.logWarning(this, msg);
        }

        @Override
        public void logError(Function0<String> msg) {
            Logging$class.logError(this, msg);
        }

        @Override
        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging$class.logInfo(this, msg, throwable);
        }

        @Override
        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging$class.logDebug(this, msg, throwable);
        }

        @Override
        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging$class.logTrace(this, msg, throwable);
        }

        @Override
        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging$class.logWarning(this, msg, throwable);
        }

        @Override
        public void logError(Function0<String> msg, Throwable throwable) {
            Logging$class.logError(this, msg, throwable);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging$class.isTraceEnabled(this);
        }

        @Override
        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging$class.initializeLogIfNecessary(this, isInterpreter);
        }

        @Override
        public final RpcEndpointRef self() {
            return RpcEndpoint$class.self(this);
        }

        @Override
        public void onError(Throwable cause) {
            RpcEndpoint$class.onError(this, cause);
        }

        @Override
        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint$class.onConnected(this, remoteAddress);
        }

        @Override
        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint$class.onNetworkError(this, cause, remoteAddress);
        }

        @Override
        public final void stop() {
            RpcEndpoint$class.stop(this);
        }

        @Override
        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public HashSet<String> executorsPendingLossReason() {
            return this.executorsPendingLossReason;
        }

        public SerializerInstance org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser() {
            return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser;
        }

        public HashMap<RpcAddress, String> addressToExecutorId() {
            return this.addressToExecutorId;
        }

        private ScheduledExecutorService reviveThread() {
            return this.reviveThread;
        }

        @Override
        public void onStart() {
            long reviveIntervalMs = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().conf().getTimeAsMs("spark.scheduler.revive.interval", "1s");
            this.reviveThread().scheduleAtFixedRate(new Runnable(this){
                private final /* synthetic */ DriverEndpoint $outer;

                public void run() {
                    Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DriverEndpoint$$anon$1 $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            Option$.MODULE$.apply((Object)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anon$$$outer().self()).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(RpcEndpointRef x$1) {
                                    x$1.send(CoarseGrainedClusterMessages$ReviveOffers$.MODULE$);
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, 0L, reviveIntervalMs, TimeUnit.MILLISECONDS);
        }

        @Override
        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var15_19;
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.StatusUpdate) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.StatusUpdate statusUpdate2 = (CoarseGrainedClusterMessages.StatusUpdate)A1;
                        String executorId = statusUpdate2.executorId();
                        long taskId = statusUpdate2.taskId();
                        Enumeration.Value state = statusUpdate2.state();
                        SerializableBuffer data = statusUpdate2.data();
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.statusUpdate(taskId, state, data.value());
                        if (TaskState$.MODULE$.isFinished(state)) {
                            Option option = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                ExecutorData executorInfo = (ExecutorData)some.x();
                                executorInfo.freeCores_$eq(executorInfo.freeCores() + this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.CPUS_PER_TASK());
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers(executorId);
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                None$ none$ = None$.MODULE$;
                                Option option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError((Object)option);
                                this.$outer.logWarning((Function0<String>)new Serializable(this, executorId, taskId, state){
                                    public static final long serialVersionUID = 0L;
                                    private final String executorId$1;
                                    private final long taskId$1;
                                    private final Enumeration.Value state$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored task status update (", " state ", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.taskId$1), this.state$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from unknown executor with ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$1}))).toString();
                                    }
                                    {
                                        this.executorId$1 = executorId$1;
                                        this.taskId$1 = taskId$1;
                                        this.state$1 = state$1;
                                    }
                                });
                                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit4 = boxedUnit;
                        return var15_19;
                    } else {
                        CoarseGrainedClusterMessages$ReviveOffers$ coarseGrainedClusterMessages$ReviveOffers$ = CoarseGrainedClusterMessages$ReviveOffers$.MODULE$;
                        A1 A12 = A1;
                        if (!(coarseGrainedClusterMessages$ReviveOffers$ != null ? !coarseGrainedClusterMessages$ReviveOffers$.equals(A12) : A12 != null)) {
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return var15_19;
                        } else if (A1 instanceof CoarseGrainedClusterMessages.KillTask) {
                            CoarseGrainedClusterMessages.KillTask killTask2 = (CoarseGrainedClusterMessages.KillTask)A1;
                            long taskId = killTask2.taskId();
                            String executorId = killTask2.executor();
                            boolean interruptThread = killTask2.interruptThread();
                            Option option = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                ExecutorData executorInfo = (ExecutorData)some.x();
                                executorInfo.executorEndpoint().send(new CoarseGrainedClusterMessages.KillTask(taskId, executorId, interruptThread));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                None$ none$ = None$.MODULE$;
                                Option option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError((Object)option);
                                this.$outer.logWarning((Function0<String>)new Serializable(this, taskId, executorId){
                                    public static final long serialVersionUID = 0L;
                                    private final long taskId$2;
                                    private final String executorId$2;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to kill task ", " for unknown executor ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.taskId$2), this.executorId$2}));
                                    }
                                    {
                                        this.taskId$2 = taskId$2;
                                        this.executorId$2 = executorId$2;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return var15_19;
                        } else {
                            Object object = function1.apply(x1);
                        }
                    }
                    return var15_19;
                }

                public final boolean isDefinedAt(Object x1) {
                    boolean bl;
                    Object object = x1;
                    if (object instanceof CoarseGrainedClusterMessages.StatusUpdate) {
                        bl = true;
                    } else {
                        CoarseGrainedClusterMessages$ReviveOffers$ coarseGrainedClusterMessages$ReviveOffers$ = CoarseGrainedClusterMessages$ReviveOffers$.MODULE$;
                        Object object2 = object;
                        bl = !(coarseGrainedClusterMessages$ReviveOffers$ != null ? !coarseGrainedClusterMessages$ReviveOffers$.equals(object2) : object2 != null) ? true : object instanceof CoarseGrainedClusterMessages.KillTask;
                    }
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
        }

        @Override
        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;
                private final RpcCallContext context$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterExecutor) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.RegisterExecutor registerExecutor = (CoarseGrainedClusterMessages.RegisterExecutor)A1;
                        String executorId = registerExecutor.executorId();
                        RpcEndpointRef executorRef = registerExecutor.executorRef();
                        String hostname = registerExecutor.hostname();
                        int cores = registerExecutor.cores();
                        scala.collection.immutable.Map<String, String> logUrls = registerExecutor.logUrls();
                        if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().contains((Object)executorId)) {
                            executorRef.send(new CoarseGrainedClusterMessages.RegisterExecutorFailed(new StringBuilder().append((Object)"Duplicate executor ID: ").append((Object)executorId).toString()));
                            this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            RpcAddress executorAddress = executorRef.address() == null ? this.context$1.senderAddress() : executorRef.address();
                            this.$outer.logInfo((Function0<String>)new Serializable(this, executorId, executorRef, executorAddress){
                                public static final long serialVersionUID = 0L;
                                private final String executorId$3;
                                private final RpcEndpointRef executorRef$1;
                                private final RpcAddress executorAddress$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered executor ", " (", ") with ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorRef$1, this.executorAddress$1, this.executorId$3}));
                                }
                                {
                                    this.executorId$3 = executorId$3;
                                    this.executorRef$1 = executorRef$1;
                                    this.executorAddress$1 = executorAddress$1;
                                }
                            });
                            this.$outer.addressToExecutorId().update((Object)executorAddress, (Object)executorId);
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalCoreCount().addAndGet(cores);
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalRegisteredExecutors().addAndGet(1);
                            ExecutorData data = new ExecutorData(executorRef, executorRef.address(), hostname, cores, cores, logUrls);
                            CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                            synchronized (coarseGrainedSchedulerBackend) {
                                BoxedUnit boxedUnit2;
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().put((Object)executorId, (Object)data);
                                if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().currentExecutorIdCounter() < new StringOps(Predef$.MODULE$.augmentString(executorId)).toInt()) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().currentExecutorIdCounter_$eq(new StringOps(Predef$.MODULE$.augmentString(executorId)).toInt());
                                }
                                if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() > 0) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - 1);
                                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ DriverEndpoint$$anonfun$receiveAndReply$1 $outer;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decremented number of pending executors (", " left)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors())}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 10, 12] lbl35 : MonitorExitStatement: MONITOREXIT : coarseGrainedSchedulerBackend
                                executorRef.send(CoarseGrainedClusterMessages$RegisteredExecutor$.MODULE$);
                                this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus().post(new SparkListenerExecutorAdded(System.currentTimeMillis(), executorId, data));
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers();
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        object = boxedUnit;
                        return (B1)object;
                    }
                    CoarseGrainedClusterMessages$StopDriver$ coarseGrainedClusterMessages$StopDriver$ = CoarseGrainedClusterMessages$StopDriver$.MODULE$;
                    A1 A12 = A1;
                    if (!(coarseGrainedClusterMessages$StopDriver$ != null ? !coarseGrainedClusterMessages$StopDriver$.equals(A12) : A12 != null)) {
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        this.$outer.stop();
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    CoarseGrainedClusterMessages$StopExecutors$ coarseGrainedClusterMessages$StopExecutors$ = CoarseGrainedClusterMessages$StopExecutors$.MODULE$;
                    A1 A13 = A1;
                    if (!(coarseGrainedClusterMessages$StopExecutors$ != null ? !coarseGrainedClusterMessages$StopExecutors$.equals(A13) : A13 != null)) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Asking each executor to shut down";
                            }
                        });
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<String, ExecutorData> check$ifrefutable$1) {
                                Tuple2<String, ExecutorData> tuple2 = check$ifrefutable$1;
                                boolean bl = tuple2 != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<String, ExecutorData> x$2) {
                                Tuple2<String, ExecutorData> tuple2 = x$2;
                                if (tuple2 != null) {
                                    ExecutorData executorData = (ExecutorData)tuple2._2();
                                    executorData.executorEndpoint().send(CoarseGrainedClusterMessages$StopExecutor$.MODULE$);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                        });
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    if (A1 instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                        CoarseGrainedClusterMessages.RemoveExecutor removeExecutor2 = (CoarseGrainedClusterMessages.RemoveExecutor)A1;
                        String executorId = removeExecutor2.executorId();
                        ExecutorLossReason reason = removeExecutor2.reason();
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(ExecutorData x$3) {
                                x$3.executorEndpoint().send(CoarseGrainedClusterMessages$StopExecutor$.MODULE$);
                            }
                        });
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$removeExecutor(executorId, reason);
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    CoarseGrainedClusterMessages$RetrieveSparkProps$ coarseGrainedClusterMessages$RetrieveSparkProps$ = CoarseGrainedClusterMessages$RetrieveSparkProps$.MODULE$;
                    A1 A14 = A1;
                    if (!(coarseGrainedClusterMessages$RetrieveSparkProps$ != null ? !coarseGrainedClusterMessages$RetrieveSparkProps$.equals(A14) : A14 != null)) {
                        this.context$1.reply(this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties);
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    object = function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x2) {
                    boolean bl;
                    Object object = x2;
                    if (object instanceof CoarseGrainedClusterMessages.RegisterExecutor) {
                        bl = true;
                    } else {
                        CoarseGrainedClusterMessages$StopDriver$ coarseGrainedClusterMessages$StopDriver$ = CoarseGrainedClusterMessages$StopDriver$.MODULE$;
                        Object object2 = object;
                        if (!(coarseGrainedClusterMessages$StopDriver$ != null ? !coarseGrainedClusterMessages$StopDriver$.equals(object2) : object2 != null)) {
                            bl = true;
                        } else {
                            CoarseGrainedClusterMessages$StopExecutors$ coarseGrainedClusterMessages$StopExecutors$ = CoarseGrainedClusterMessages$StopExecutors$.MODULE$;
                            Object object3 = object;
                            if (!(coarseGrainedClusterMessages$StopExecutors$ != null ? !coarseGrainedClusterMessages$StopExecutors$.equals(object3) : object3 != null)) {
                                bl = true;
                            } else if (object instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                                bl = true;
                            } else {
                                CoarseGrainedClusterMessages$RetrieveSparkProps$ coarseGrainedClusterMessages$RetrieveSparkProps$ = CoarseGrainedClusterMessages$RetrieveSparkProps$.MODULE$;
                                Object object4 = object;
                                bl = !(coarseGrainedClusterMessages$RetrieveSparkProps$ != null ? !coarseGrainedClusterMessages$RetrieveSparkProps$.equals(object4) : object4 != null);
                            }
                        }
                    }
                    return bl;
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers() {
            Map activeExecutors = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().filterKeys((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final boolean apply(String executorId) {
                    return this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(executorId);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Seq workOffers = ((TraversableOnce)activeExecutors.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final WorkerOffer apply(Tuple2<String, ExecutorData> x0$1) {
                    Tuple2<String, ExecutorData> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String id = (String)tuple2._1();
                        ExecutorData executorData = (ExecutorData)tuple2._2();
                        WorkerOffer workerOffer = new WorkerOffer(id, executorData.executorHost(), executorData.freeCores());
                        return workerOffer;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.launchTasks(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.resourceOffers((Seq<WorkerOffer>)workOffers));
        }

        @Override
        public void onDisconnected(RpcAddress remoteAddress) {
            this.addressToExecutorId().get((Object)remoteAddress).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final void apply(String x$4) {
                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$removeExecutor(x$4, new SlaveLost("Remote RPC client disassociated. Likely due to containers exceeding thresholds, or network issues. Check driver logs for WARN messages.", SlaveLost$.MODULE$.apply$default$2()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers(String executorId) {
            if (this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(executorId)) {
                ExecutorData executorData = (ExecutorData)this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().apply((Object)executorId);
                Seq workOffers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WorkerOffer[]{new WorkerOffer(executorId, executorData.executorHost(), executorData.freeCores())}));
                this.launchTasks(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.resourceOffers((Seq<WorkerOffer>)workOffers));
            }
        }

        public synchronized boolean org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(String executorId) {
            return !this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)executorId) && !this.executorsPendingLossReason().contains((Object)executorId);
        }

        private void launchTasks(Seq<Seq<TaskDescription>> tasks) {
            ((IterableLike)tasks.flatten((Function1)Predef$.MODULE$.conforms())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final void apply(TaskDescription task) {
                    ByteBuffer serializedTask = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser().serialize(task, ClassTag$.MODULE$.apply(TaskDescription.class));
                    if (serializedTask.limit() >= this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize()) {
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.taskIdToTaskSetManager().get((Object)BoxesRunTime.boxToLong((long)task.taskId())).foreach((Function1)new Serializable(this, task, serializedTask){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DriverEndpoint$$anonfun$launchTasks$1 $outer;
                            private final TaskDescription task$1;
                            private final ByteBuffer serializedTask$1;

                            public final void apply(TaskSetManager taskSetMgr) {
                                try {
                                    String msg = "Serialized task %s:%d was %d bytes, which exceeds max allowed: spark.rpc.message.maxSize (%d bytes). Consider increasing spark.rpc.message.maxSize or using broadcast variables for large values.";
                                    msg = new StringOps(Predef$.MODULE$.augmentString(msg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.task$1.taskId()), BoxesRunTime.boxToInteger((int)this.task$1.index()), BoxesRunTime.boxToInteger((int)this.serializedTask$1.limit()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize())}));
                                    taskSetMgr.abort(msg, taskSetMgr.abort$default$2());
                                }
                                catch (Exception exception2) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().logError((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Exception in error callback";
                                        }
                                    }, exception2);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.task$1 = task$1;
                                this.serializedTask$1 = serializedTask$1;
                            }
                        });
                    } else {
                        ExecutorData executorData = (ExecutorData)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().apply((Object)task.executorId());
                        executorData.freeCores_$eq(executorData.freeCores() - this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.CPUS_PER_TASK());
                        this.$outer.logInfo((Function0<String>)new Serializable(this, task, executorData){
                            public static final long serialVersionUID = 0L;
                            private final TaskDescription task$1;
                            private final ExecutorData executorData$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Launching task ", " on executor id: ", " hostname: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.task$1.taskId()), this.task$1.executorId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorData$1.executorHost()}))).toString();
                            }
                            {
                                this.task$1 = task$1;
                                this.executorData$1 = executorData$1;
                            }
                        });
                        executorData.executorEndpoint().send(new CoarseGrainedClusterMessages.LaunchTask(new SerializableBuffer(serializedTask)));
                    }
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$removeExecutor(String executorId, ExecutorLossReason reason) {
            this.logDebug((Function0<String>)new Serializable(this, executorId, reason){
                public static final long serialVersionUID = 0L;
                private final String executorId$4;
                private final ExecutorLossReason reason$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Asked to remove executor ", " with reason ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$4, this.reason$1}));
                }
                {
                    this.executorId$4 = executorId$4;
                    this.reason$1 = reason$1;
                }
            });
            Option option = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
            if (option instanceof Some) {
                Object object;
                Some some = (Some)option;
                ExecutorData executorInfo = (ExecutorData)some.x();
                CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                synchronized (coarseGrainedSchedulerBackend) {
                    this.addressToExecutorId().$minus$eq((Object)executorInfo.executorAddress());
                    this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().$minus$eq((Object)executorId);
                    this.executorsPendingLossReason().$minus$eq((Object)executorId);
                    object = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().remove((Object)executorId).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return false;
                        }
                    });
                }
                boolean killed = BoxesRunTime.unboxToBoolean((Object)object);
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalCoreCount().addAndGet(-executorInfo.totalCores());
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalRegisteredExecutors().addAndGet(-1);
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.executorLost(executorId, killed ? ExecutorKilled$.MODULE$ : reason);
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus().post(new SparkListenerExecutorRemoved(System.currentTimeMillis(), executorId, reason.toString()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            None$ none$ = None$.MODULE$;
            Option option2 = option;
            if (none$ == null) {
                if (option2 != null) {
                    throw new MatchError((Object)option);
                }
            } else if (!none$.equals(option2)) throw new MatchError((Object)option);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.sc().env().blockManager().master().removeExecutorAsync(executorId);
            this.logInfo((Function0<String>)new Serializable(this, executorId){
                public static final long serialVersionUID = 0L;
                private final String executorId$4;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Asked to remove non-existent executor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$4}));
                }
                {
                    this.executorId$4 = executorId$4;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean disableExecutor(String executorId) {
            Boolean bl;
            CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
            synchronized (coarseGrainedSchedulerBackend) {
                Boolean bl2;
                if (this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(executorId)) {
                    this.executorsPendingLossReason().$plus$eq((Object)executorId);
                    bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                } else {
                    bl2 = BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)executorId));
                }
                bl = bl2;
            }
            boolean shouldDisable = BoxesRunTime.unboxToBoolean((Object)bl);
            if (shouldDisable) {
                this.logInfo((Function0<String>)new Serializable(this, executorId){
                    public static final long serialVersionUID = 0L;
                    private final String executorId$5;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disabling executor ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$5}));
                    }
                    {
                        this.executorId$5 = executorId$5;
                    }
                });
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.executorLost(executorId, LossReasonPending$.MODULE$);
            }
            return shouldDisable;
        }

        @Override
        public void onStop() {
            this.reviveThread().shutdownNow();
        }

        public /* synthetic */ CoarseGrainedSchedulerBackend org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer() {
            return this.$outer;
        }

        public DriverEndpoint(CoarseGrainedSchedulerBackend $outer, RpcEnv rpcEnv, Seq<Tuple2<String, String>> sparkProperties) {
            this.rpcEnv = rpcEnv;
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties = sparkProperties;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            RpcEndpoint$class.$init$(this);
            Logging$class.$init$(this);
            this.executorsPendingLossReason = new HashSet();
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser = SparkEnv$.MODULE$.get().closureSerializer().newInstance();
            this.addressToExecutorId = new HashMap();
            this.reviveThread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("driver-revive-thread");
        }
    }
}

