/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.spark.InternalAccumulator$;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskEndReason;
import org.apache.spark.TaskResultLost$;
import org.apache.spark.TaskState$;
import org.apache.spark.UnknownReason$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.scheduler.DirectTaskResult;
import org.apache.spark.scheduler.IndirectTaskResult;
import org.apache.spark.scheduler.TaskResult;
import org.apache.spark.scheduler.TaskResultGetter$;
import org.apache.spark.scheduler.TaskResultGetter$$anon$2$$anonfun$run$1$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSetManager;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!B\u0001\u0003\u0001\u0011Q!\u0001\u0005+bg.\u0014Vm];mi\u001e+G\u000f^3s\u0015\t\u0019A!A\u0005tG\",G-\u001e7fe*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\f\u0014\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\tgB\f'o[#om\u000e\u0001\u0001CA\u000e\u001d\u001b\u0005!\u0011BA\u000f\u0005\u0005!\u0019\u0006/\u0019:l\u000b:4\b\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!\u0005+bg.\u001c6\r[3ek2,'/S7qY\")A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"2AJ\u0014)!\t\u0001\u0003\u0001C\u0003\u0019G\u0001\u0007!\u0004C\u0003\u0004G\u0001\u0007q\u0004C\u0004+\u0001\t\u0007I\u0011B\u0016\u0002\u000fQC%+R!E'V\tA\u0006\u0005\u0002\r[%\u0011a&\u0004\u0002\u0004\u0013:$\bB\u0002\u0019\u0001A\u0003%A&\u0001\u0005U\u0011J+\u0015\tR*!\u0011\u001d\u0011\u0004A1A\u0005\u0012M\nQcZ3u)\u0006\u001c8NU3tk2$X\t_3dkR|'/F\u00015!\t)D(D\u00017\u0015\t9\u0004(\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u000f\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0002w\u0005!!.\u0019<b\u0013\tidGA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u0019y\u0004\u0001)A\u0005i\u00051r-\u001a;UCN\\'+Z:vYR,\u00050Z2vi>\u0014\b\u0005C\u0004B\u0001\t\u0007I\u0011\u0003\"\u0002\u0015M,'/[1mSj,'/F\u0001D!\r!u)S\u0007\u0002\u000b*\u0011aIO\u0001\u0005Y\u0006tw-\u0003\u0002I\u000b\nYA\u000b\u001b:fC\u0012dunY1m!\tQE*D\u0001L\u0015\t\tE!\u0003\u0002N\u0017\n\u00112+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0011\u0019y\u0005\u0001)A\u0005\u0007\u0006Y1/\u001a:jC2L'0\u001a:!\u0011\u0015\t\u0006\u0001\"\u0001S\u0003U)g.];fk\u0016\u001cVoY2fgN4W\u000f\u001c+bg.$Ba\u0015,\\AB\u0011A\u0002V\u0005\u0003+6\u0011A!\u00168ji\")q\u000b\u0015a\u00011\u0006qA/Y:l'\u0016$X*\u00198bO\u0016\u0014\bC\u0001\u0011Z\u0013\tQ&A\u0001\bUCN\\7+\u001a;NC:\fw-\u001a:\t\u000bq\u0003\u0006\u0019A/\u0002\u0007QLG\r\u0005\u0002\r=&\u0011q,\u0004\u0002\u0005\u0019>tw\rC\u0003b!\u0002\u0007!-\u0001\btKJL\u0017\r\\5{K\u0012$\u0015\r^1\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015T\u0014a\u00018j_&\u0011q\r\u001a\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B5\u0001\t\u0003Q\u0017!E3ocV,W/\u001a$bS2,G\rV1tWR)1k\u001b7n\u007f\")q\u000b\u001ba\u00011\")A\f\u001ba\u0001;\")a\u000e\u001ba\u0001_\u0006IA/Y:l'R\fG/\u001a\t\u0003art!!\u001d>\u000f\u0005ILhBA:y\u001d\t!x/D\u0001v\u0015\t1\u0018$\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u001f\u0003\u0002\u0013Q\u000b7o[*uCR,\u0017BA?\u007f\u0005%!\u0016m]6Ti\u0006$XM\u0003\u0002|\t!)\u0011\r\u001ba\u0001E\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0011\u0001B:u_B$\u0012a\u0015")
public class TaskResultGetter
implements Logging {
    public final SparkEnv org$apache$spark$scheduler$TaskResultGetter$$sparkEnv;
    public final TaskSchedulerImpl org$apache$spark$scheduler$TaskResultGetter$$scheduler;
    private final int THREADS;
    private final ExecutorService getTaskResultExecutor;
    private final ThreadLocal<SerializerInstance> serializer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private int THREADS() {
        return this.THREADS;
    }

    public ExecutorService getTaskResultExecutor() {
        return this.getTaskResultExecutor;
    }

    public ThreadLocal<SerializerInstance> serializer() {
        return this.serializer;
    }

    public void enqueueSuccessfulTask(TaskSetManager taskSetManager, long tid, ByteBuffer serializedData) {
        this.getTaskResultExecutor().execute(new Runnable(this, taskSetManager, tid, serializedData){
            private final /* synthetic */ TaskResultGetter $outer;
            public final TaskSetManager taskSetManager$1;
            public final long tid$1;
            public final ByteBuffer serializedData$1;

            public void run() {
                NonLocalReturnControl nonLocalReturnControl2;
                block2: {
                    Object object = new Object();
                    try {
                        Utils$.MODULE$.logUncaughtExceptions(new Serializable(this, object){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$2 $outer;
                            private final Object nonLocalReturnKey1$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void apply$mcV$sp() {
                                try {
                                    Tuple2 tuple2;
                                    Tuple2 tuple22;
                                    TaskResult taskResult = (TaskResult)this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().serializer().get().deserialize(this.$outer.serializedData$1, ClassTag$.MODULE$.apply(TaskResult.class));
                                    if (taskResult instanceof DirectTaskResult) {
                                        DirectTaskResult directTaskResult = (DirectTaskResult)taskResult;
                                        if (!this.$outer.taskSetManager$1.canFetchMoreResults(this.$outer.serializedData$1.limit())) throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                                        directTaskResult.value();
                                        tuple22 = new Tuple2((Object)directTaskResult, (Object)BoxesRunTime.boxToInteger((int)this.$outer.serializedData$1.limit()));
                                    } else {
                                        if (!(taskResult instanceof IndirectTaskResult)) throw new MatchError((Object)taskResult);
                                        IndirectTaskResult indirectTaskResult = (IndirectTaskResult)taskResult;
                                        BlockId blockId = indirectTaskResult.blockId();
                                        int size = indirectTaskResult.size();
                                        if (!this.$outer.taskSetManager$1.canFetchMoreResults(size)) {
                                            this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().master().removeBlock(blockId);
                                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                                        }
                                        this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().logDebug((Function0<String>)new $anon$2$$anonfun$run$1$$anonfun$1(this));
                                        this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleTaskGettingResult(this.$outer.taskSetManager$1, this.$outer.tid$1);
                                        Option<ChunkedByteBuffer> serializedTaskResult = this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().getRemoteBytes(blockId);
                                        if (!serializedTaskResult.isDefined()) {
                                            this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask(this.$outer.taskSetManager$1, this.$outer.tid$1, TaskState$.MODULE$.FINISHED(), TaskResultLost$.MODULE$);
                                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                                        }
                                        DirectTaskResult deserializedResult = (DirectTaskResult)this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().serializer().get().deserialize(((ChunkedByteBuffer)serializedTaskResult.get()).toByteBuffer(), ClassTag$.MODULE$.apply(DirectTaskResult.class));
                                        this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().master().removeBlock(blockId);
                                        tuple22 = new Tuple2((Object)deserializedResult, (Object)BoxesRunTime.boxToInteger((int)size));
                                    }
                                    Tuple2 tuple23 = tuple22;
                                    if (tuple23 == null) throw new MatchError((Object)tuple23);
                                    DirectTaskResult result2 = (DirectTaskResult)tuple23._1();
                                    int size = tuple23._2$mcI$sp();
                                    Tuple2 tuple24 = tuple2 = new Tuple2((Object)result2, (Object)BoxesRunTime.boxToInteger((int)size));
                                    DirectTaskResult result3 = (DirectTaskResult)tuple24._1();
                                    int size2 = tuple24._2$mcI$sp();
                                    result3.accumUpdates_$eq((Seq)result3.accumUpdates().map((Function1)new Serializable(this, size2){
                                        public static final long serialVersionUID = 0L;
                                        private final int size$1;

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final AccumulatorV2<? super Long, ? super Long> apply(AccumulatorV2<?, ?> a) {
                                            AccumulatorV2<?, ?> accumulatorV2;
                                            Option<String> option = a.name();
                                            Some some = new Some((Object)InternalAccumulator$.MODULE$.RESULT_SIZE());
                                            if (!(option != null ? !option.equals((Object)some) : some != null)) {
                                                void var3_3;
                                                LongAccumulator acc = (LongAccumulator)a;
                                                Predef$.MODULE$.assert(acc.sum() == 0L, (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "task result size should not have been set on the executors";
                                                    }
                                                });
                                                acc.setValue(this.size$1);
                                                accumulatorV2 = var3_3;
                                            } else {
                                                accumulatorV2 = a;
                                            }
                                            return accumulatorV2;
                                        }
                                        {
                                            this.size$1 = size$1;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom()));
                                    this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleSuccessfulTask(this.$outer.taskSetManager$1, this.$outer.tid$1, result3);
                                    return;
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2 = throwable;
                                    if (throwable2 instanceof ClassNotFoundException) {
                                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                                        this.$outer.taskSetManager$1.abort(new StringBuilder().append((Object)"ClassNotFound with classloader: ").append((Object)loader).toString(), this.$outer.taskSetManager$1.abort$default$2());
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                                    if (option.isEmpty()) {
                                        throw throwable;
                                    }
                                    Throwable ex = (Throwable)option.get();
                                    this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().logError((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Exception while getting task result";
                                        }
                                    }, ex);
                                    this.$outer.taskSetManager$1.abort(new StringOps(Predef$.MODULE$.augmentString("Exception while getting task result: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ex})), this.$outer.taskSetManager$1.abort$default$2());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                            }

                            public /* synthetic */ $anon$2 org$apache$spark$scheduler$TaskResultGetter$$anon$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                            }
                        });
                    }
                    catch (NonLocalReturnControl nonLocalReturnControl2) {
                        if (nonLocalReturnControl2.key() != object) break block2;
                        nonLocalReturnControl2.value$mcV$sp();
                    }
                    return;
                }
                throw nonLocalReturnControl2;
            }

            public /* synthetic */ TaskResultGetter org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.taskSetManager$1 = taskSetManager$1;
                this.tid$1 = tid$1;
                this.serializedData$1 = serializedData$1;
            }
        });
    }

    public void enqueueFailedTask(TaskSetManager taskSetManager, long tid, Enumeration.Value taskState, ByteBuffer serializedData) {
        Throwable throwable2;
        block2: {
            ObjectRef reason = new ObjectRef((Object)UnknownReason$.MODULE$);
            try {
                this.getTaskResultExecutor().execute(new Runnable(this, taskSetManager, tid, taskState, serializedData, reason){
                    private final /* synthetic */ TaskResultGetter $outer;
                    public final TaskSetManager taskSetManager$2;
                    public final long tid$2;
                    public final Enumeration.Value taskState$1;
                    public final ByteBuffer serializedData$2;
                    public final ObjectRef reason$1;

                    public void run() {
                        Utils$.MODULE$.logUncaughtExceptions(new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$3 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
                                try {
                                    if (this.$outer.serializedData$2 != null && this.$outer.serializedData$2.limit() > 0) {
                                        this.$outer.reason$1.elem = (TaskEndReason)this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().serializer().get().deserialize(this.$outer.serializedData$2, loader, ClassTag$.MODULE$.apply(TaskEndReason.class));
                                    }
                                }
                                catch (Exception exception2) {
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().logError((Function0<String>)new Serializable(this, loader){
                                        public static final long serialVersionUID = 0L;
                                        private final ClassLoader loader$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"Could not deserialize TaskEndReason: ClassNotFound with classloader ").append((Object)this.loader$1).toString();
                                        }
                                        {
                                            this.loader$1 = loader$1;
                                        }
                                    });
                                }
                                this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask(this.$outer.taskSetManager$2, this.$outer.tid$2, this.$outer.taskState$1, (TaskEndReason)this.$outer.reason$1.elem);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ TaskResultGetter org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.taskSetManager$2 = taskSetManager$2;
                        this.tid$2 = tid$2;
                        this.taskState$1 = taskState$1;
                        this.serializedData$2 = serializedData$2;
                        this.reason$1 = reason$1;
                    }
                });
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof RejectedExecutionException) || !this.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.isStopped()) break block2;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public void stop() {
        this.getTaskResultExecutor().shutdownNow();
    }

    public TaskResultGetter(SparkEnv sparkEnv, TaskSchedulerImpl scheduler) {
        this.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv = sparkEnv;
        this.org$apache$spark$scheduler$TaskResultGetter$$scheduler = scheduler;
        Logging$class.$init$(this);
        this.THREADS = sparkEnv.conf().getInt("spark.resultGetter.threads", 4);
        this.getTaskResultExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.THREADS(), "task-result-getter");
        this.serializer = new $anon$1(this);
    }
}

